/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import junit.framework.TestCase;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.junit.Assert;

public abstract class PerformanceTestRunner {
    private String regressionReason;
    private String fingerprintName;

    public void setRegressionReason(String comment) {
        this.regressionReason = comment;
    }

    protected abstract void test() throws Exception;

    public final void run(TestCase testCase, int outer, int inner) {
        this.run(testCase, null, outer, inner);
    }

    public final void run(TestCase testCase, String localName, int outer, int inner) {
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId(testCase));
        try {
            this.runTest(meter, localName, outer, inner);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed performance test with exception:" + String.valueOf(e)));
        }
    }

    public final void run(Class<?> testClass, String testMethodName, int outer, int inner) throws Exception {
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId(testClass, testMethodName));
        this.runTest(meter, null, outer, inner);
    }

    private void runTest(PerformanceMeter meter, String localName, int outer, int inner) throws Exception {
        Performance perf = Performance.getDefault();
        if (this.regressionReason != null) {
            perf.setComment(meter, 1, this.regressionReason);
        }
        try {
            int i = 0;
            while (i < outer) {
                this.setUp();
                meter.start();
                int j = 0;
                while (j < inner) {
                    this.test();
                    ++j;
                }
                meter.stop();
                this.tearDown();
                ++i;
            }
            if (localName != null) {
                perf.tagAsSummary(meter, localName, Dimension.ELAPSED_PROCESS);
            }
            if (this.fingerprintName != null) {
                perf.tagAsSummary(meter, this.fingerprintName, Dimension.ELAPSED_PROCESS);
            }
            meter.commit();
            perf.assertPerformance(meter);
        }
        finally {
            meter.dispose();
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void setFingerprintName(String fingerprintName) {
        this.fingerprintName = fingerprintName;
    }
}

