/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Collectors;
import org.junit.Assert;

public class TestBarrier2 {
    public static final int STATUS_BLOCKED = 6;
    public static final int STATUS_DONE = 5;
    public static final int STATUS_RUNNING = 3;
    public static final int STATUS_START = 1;
    public static final int STATUS_WAIT_FOR_DONE = 4;
    public static final int STATUS_WAIT_FOR_RUN = 2;
    public static final int STATUS_WAIT_FOR_START = 0;
    private final int myIndex;
    private final AtomicIntegerArray myStatus;

    private static void doWaitForStatus(AtomicIntegerArray statuses, int index, int status, int timeout) {
        long start = System.nanoTime();
        while (statuses.get(index) != status) {
            boolean condition;
            Thread.yield();
            long elapsed = (System.nanoTime() - start) / 1000000L;
            boolean bl = condition = elapsed < (long)timeout;
            if (condition) continue;
            String dump = TestBarrier2.getThreadDump();
            if (statuses.get(index) > status) {
                Assert.fail((String)("Timeout after " + elapsed + "ms - Status already in state " + TestBarrier2.getStatus(statuses.get(index)) + " - waiting for " + TestBarrier2.getStatus(status) + "\n" + dump));
                continue;
            }
            Assert.fail((String)("Timeout after " + elapsed + "ms waiting for status to change from " + TestBarrier2.getStatus(statuses.get(index)) + " to " + TestBarrier2.getStatus(status) + "\n" + dump));
        }
    }

    public static String getThreadDump() {
        StringBuilder out = new StringBuilder();
        out.append(" [ThreadDump taken from thread '" + Thread.currentThread().getName() + "' at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(System.currentTimeMillis())) + ":\n");
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Comparator<Map.Entry> byId = Comparator.comparing(e -> ((Thread)e.getKey()).getId());
        for (Map.Entry entry : stackTraces.entrySet().stream().sorted(byId).collect(Collectors.toList())) {
            StackTraceElement[] stack;
            Thread thread = (Thread)entry.getKey();
            String name = thread.getName();
            out.append("   Thread \"" + name + "\" #" + thread.getId() + " prio=" + thread.getPriority() + " " + String.valueOf((Object)thread.getState()) + "\n");
            StackTraceElement[] stackTraceElementArray = stack = (StackTraceElement[])entry.getValue();
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement se = stackTraceElementArray[n2];
                out.append("     at " + String.valueOf(se) + "\n");
                ++n2;
            }
        }
        out.append(" ] // ThreadDump end\n");
        return out.toString();
    }

    private static String getStatus(int status) {
        switch (status) {
            case 0: {
                return "WAIT_FOR_START";
            }
            case 1: {
                return "START";
            }
            case 2: {
                return "WAIT_FOR_RUN";
            }
            case 3: {
                return "RUNNING";
            }
            case 4: {
                return "WAIT_FOR_DONE";
            }
            case 5: {
                return "DONE";
            }
            case 6: {
                return "BLOCKED";
            }
        }
        return "UNKNOWN_STATUS";
    }

    public static void waitForStatus(AtomicIntegerArray location, int status) {
        TestBarrier2.doWaitForStatus(location, 0, status, 10000);
    }

    public static void waitForStatus(AtomicIntegerArray location, int index, int status) {
        TestBarrier2.doWaitForStatus(location, index, status, 10000);
    }

    public TestBarrier2() {
        this(new AtomicIntegerArray(new int[1]), 0);
    }

    public TestBarrier2(int initalStatus) {
        this(new AtomicIntegerArray(new int[]{initalStatus}), 0);
    }

    public TestBarrier2(AtomicIntegerArray location, int index) {
        this.myStatus = location;
        this.myIndex = index;
    }

    public void setStatus(int status) {
        this.myStatus.set(this.myIndex, status);
    }

    public void waitForStatus(int status) {
        TestBarrier2.waitForStatus(this.myStatus, this.myIndex, status);
    }

    public void waitForStatusNoFail(int status) {
        TestBarrier2.doWaitForStatus(this.myStatus, this.myIndex, status, 100000);
    }

    public void upgradeTo(int newValue) {
        int actual = this.myStatus.get(this.myIndex);
        if (actual >= newValue) {
            String s = "wrong state " + this.myStatus.get(this.myIndex) + " should be < " + newValue;
            System.out.println(s);
            throw new IllegalStateException(s);
        }
        if (!this.myStatus.compareAndSet(this.myIndex, actual, newValue)) {
            String s = "wrong state " + this.myStatus.get(this.myIndex) + " should be " + actual + " upgrade to " + newValue;
            System.out.println(s);
            throw new IllegalStateException(s);
        }
    }
}

