/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness.session;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.TestHarnessPlugin;
import org.eclipse.core.tests.session.RemoteAssertionFailedError;
import org.eclipse.core.tests.session.RemoteTestException;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.TestDescriptor;

class RemoteTestExecutor {
    private static final String REMOTE_EXECUTION_INDICATION_SYSTEM_PROPERY = "org.eclipse.core.tests.session.isRemoteExecution";
    private final String pluginId;
    private final String applicationId;
    private final Setup setup;

    static boolean isRemoteExecution() {
        return System.getProperty(REMOTE_EXECUTION_INDICATION_SYSTEM_PROPERY, "").equals(Boolean.toString(true));
    }

    RemoteTestExecutor(Setup setup, String applicationId, String pluginId) {
        this.setup = setup;
        this.applicationId = applicationId;
        this.pluginId = pluginId;
    }

    void executeRemotely(String testClass, String testMethod, boolean shouldFail) throws Throwable {
        Setup localSetup = this.createSingleTestSetup(testClass, testMethod);
        localSetup.setSystemProperty(REMOTE_EXECUTION_INDICATION_SYSTEM_PROPERY, Boolean.toString(true));
        TestDescriptor descriptor = new TestDescriptor(testClass, testMethod);
        ResultCollector collector = new ResultCollector(RemoteTestExecutor.getTestId(testClass, testMethod));
        localSetup.setEclipseArgument("port", Integer.toString(collector.getPort()));
        new Thread((Runnable)collector, "Test result collector").start();
        IStatus status = RemoteTestExecutor.launch(localSetup);
        collector.shutdown();
        if (!shouldFail) {
            if (!status.isOK()) {
                TestHarnessPlugin.log(status);
                throw new CoreException(status);
            }
            if (!collector.didTestFinish()) {
                throw new Exception("session test did not run: " + String.valueOf((Object)descriptor));
            }
            if (!collector.wasTestSuccessful()) {
                throw collector.getError();
            }
        } else if (status.isOK() && collector.wasTestSuccessful()) {
            throw new AssertionFailedException("test should fail but did not: " + String.valueOf((Object)descriptor));
        }
    }

    private static String getTestId(String testClass, String testMethod) {
        return testMethod + "(" + testClass + ")";
    }

    private Setup createSingleTestSetup(String testClassName, String testMethodName) {
        Setup localSetup = (Setup)this.setup.clone();
        localSetup.setEclipseArgument("application", this.applicationId);
        localSetup.setEclipseArgument("loaderpluginname", "org.eclipse.core.tests.harness");
        localSetup.setEclipseArgument("testloaderclass", "org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader");
        localSetup.setEclipseArgument("testpluginname", this.pluginId);
        localSetup.setEclipseArgument("test", testClassName + ":" + testMethodName);
        return localSetup;
    }

    private static IStatus launch(Setup setup) {
        Assert.isNotNull((Object)setup.getEclipseArgument("application"), (String)"test application is not defined");
        Assert.isNotNull((Object)setup.getEclipseArgument("testpluginname"), (String)"test plug-in id not defined");
        Assert.isTrue((boolean)(setup.getEclipseArgument("classname") != null ^ setup.getEclipseArgument("test") != null), (String)"either a test suite or a test case must be provided");
        setup.setEclipseArgument("version", "4");
        IStatus outcome = Status.OK_STATUS;
        try {
            int returnCode = setup.run();
            if (returnCode == 23) {
                returnCode = setup.run();
            }
            if (returnCode != 0) {
                outcome = new Status(2, "org.eclipse.core.runtime", returnCode, "Process returned non-zero code: " + returnCode + "\n\tCommand: " + String.valueOf(setup), null);
            }
        }
        catch (Exception e) {
            outcome = new Status(4, "org.eclipse.core.runtime", -1, "Error running process\n\tCommand: " + String.valueOf(setup), (Throwable)e);
        }
        return outcome;
    }

    private static class ResultCollector
    implements Runnable {
        private final String testId;
        private final ServerSocket serverSocket;
        private volatile boolean shouldRun = true;
        private volatile boolean executionFinished;
        private STATE state = STATE.SUCCESS;
        private StringBuilder stackBuilder;
        private String stackTrace;
        private boolean testFinished;
        private Throwable error;

        ResultCollector(String testId) throws IOException {
            this.serverSocket = new ServerSocket(0);
            this.testId = testId;
        }

        int getPort() {
            return this.serverSocket.getLocalPort();
        }

        boolean didTestFinish() {
            return this.testFinished;
        }

        boolean wasTestSuccessful() {
            return this.testFinished && this.error == null;
        }

        Throwable getError() {
            return this.error;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 36[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void shutdown() {
            ResultCollector resultCollector = this;
            synchronized (resultCollector) {
                if (this.executionFinished) {
                    return;
                }
                this.shouldRun = false;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    TestHarnessPlugin.log((IStatus)new Status(4, "org.eclipse.core.tests.harness", 4, "Error", (Throwable)e));
                }
                this.notifyAll();
            }
            resultCollector = this;
            synchronized (resultCollector) {
                while (true) {
                    if (this.executionFinished) {
                        return;
                    }
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private void processAvailableMessages(BufferedReader messageReader) throws IOException {
            while (messageReader.ready()) {
                String message = messageReader.readLine();
                this.processMessage(message);
            }
        }

        private void processMessage(String message) {
            if (message.startsWith("%TESTS")) {
                String receivedTestId = this.parseTestId(message);
                if (!this.testId.equals(receivedTestId)) {
                    throw new IllegalStateException("unknown test id: " + receivedTestId + message);
                }
                return;
            }
            if (message.startsWith("%TESTE")) {
                switch (this.state) {
                    case FAILURE: {
                        this.error = new RemoteAssertionFailedError("", this.stackTrace);
                        break;
                    }
                    case ERROR: {
                        this.error = new RemoteTestException("", this.stackTrace);
                    }
                }
                this.testFinished = true;
            } else if (message.startsWith("%ERROR")) {
                this.state = STATE.ERROR;
            } else if (message.startsWith("%FAILED")) {
                this.state = STATE.FAILURE;
            } else if (message.startsWith("%TRACES")) {
                this.stackBuilder = new StringBuilder();
            } else if (message.startsWith("%TRACEE")) {
                this.stackTrace = this.stackBuilder.toString();
                this.stackBuilder = null;
            } else if (!message.startsWith("%") && this.stackBuilder != null) {
                this.stackBuilder.append(message);
                this.stackBuilder.append(System.lineSeparator());
            }
        }

        private String parseTestId(String message) {
            if (message.isEmpty() || message.charAt(0) != '%') {
                return null;
            }
            int firstComma = message.indexOf(44);
            if (firstComma == -1) {
                return null;
            }
            int secondComma = message.indexOf(44, firstComma + 1);
            if (secondComma == -1) {
                secondComma = message.length();
            }
            return message.substring(firstComma + 1, secondComma);
        }

        private static enum STATE {
            SUCCESS,
            FAILURE,
            ERROR;

        }
    }
}

