/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness.session;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.session.CustomSessionConfiguration;
import org.eclipse.core.tests.harness.session.CustomSessionWorkspace;
import org.eclipse.core.tests.harness.session.RemoteTestExecutor;
import org.eclipse.core.tests.harness.session.SessionTestExtensionHost;
import org.eclipse.core.tests.harness.session.SessionTestExtensionRemote;
import org.eclipse.core.tests.harness.session.customization.CustomSessionConfigurationDummy;
import org.eclipse.core.tests.harness.session.customization.CustomSessionConfigurationImpl;
import org.eclipse.core.tests.harness.session.customization.CustomSessionWorkspaceDummy;
import org.eclipse.core.tests.harness.session.customization.CustomSessionWorkspaceImpl;
import org.eclipse.core.tests.harness.session.customization.SessionCustomization;
import org.junit.jupiter.api.extension.InvocationInterceptor;

public interface SessionTestExtension
extends InvocationInterceptor {
    public static final String CORE_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";

    public static SessionTestExtensionBuilder forPlugin(String pluginId) {
        return new SessionTestExtensionBuilder(pluginId);
    }

    public static CustomSessionWorkspace createCustomWorkspace() {
        if (RemoteTestExecutor.isRemoteExecution()) {
            return new CustomSessionWorkspaceDummy();
        }
        return new CustomSessionWorkspaceImpl();
    }

    public static CustomSessionConfiguration createCustomConfiguration() {
        if (RemoteTestExecutor.isRemoteExecution()) {
            return new CustomSessionConfigurationDummy();
        }
        return new CustomSessionConfigurationImpl();
    }

    public void setEclipseArgument(String var1, String var2);

    public void setSystemProperty(String var1, String var2);

    public static class SessionTestExtensionBuilder {
        private final String storedPluginId;
        private String storedApplicationId = "org.eclipse.pde.junit.runtime.coretestapplication";
        private Set<SessionCustomization> storedSessionCustomizations = new HashSet<SessionCustomization>();

        private SessionTestExtensionBuilder(String pluginId) {
            Objects.requireNonNull(pluginId);
            this.storedPluginId = pluginId;
        }

        public SessionTestExtensionBuilder withApplicationId(String applicationId) {
            Objects.requireNonNull(applicationId);
            this.storedApplicationId = applicationId;
            return this;
        }

        public SessionTestExtensionBuilder withCustomization(CustomSessionWorkspace sessionWorkspace) {
            Objects.requireNonNull(sessionWorkspace);
            this.storedSessionCustomizations.add(sessionWorkspace);
            return this;
        }

        public SessionTestExtensionBuilder withCustomization(CustomSessionConfiguration sessionConfiguration) {
            Objects.requireNonNull(sessionConfiguration);
            sessionConfiguration.addBundle(Platform.getBundle((String)this.storedPluginId));
            this.storedSessionCustomizations.add(sessionConfiguration);
            return this;
        }

        public SessionTestExtension create() {
            if (RemoteTestExecutor.isRemoteExecution()) {
                return new SessionTestExtensionRemote();
            }
            SessionTestExtensionHost extension = new SessionTestExtensionHost(this.storedPluginId, this.storedApplicationId);
            this.storedSessionCustomizations.forEach(customization -> extension.addSessionCustomization((SessionCustomization)customization));
            return extension;
        }
    }
}

