/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness.session;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.tests.harness.session.ExecuteInHost;
import org.eclipse.core.tests.harness.session.RemoteTestExecutor;
import org.eclipse.core.tests.harness.session.SessionShouldError;
import org.eclipse.core.tests.harness.session.SessionTestExtension;
import org.eclipse.core.tests.harness.session.customization.SessionCustomization;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.SetupManager;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

class SessionTestExtensionHost
implements SessionTestExtension {
    public static final String CORE_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";
    private final RemoteTestExecutor testExecutor;
    private final Setup setup;
    private final Set<SessionCustomization> sessionCustomizations = new HashSet<SessionCustomization>();

    SessionTestExtensionHost(String pluginId, String applicationId) {
        try {
            this.setup = SetupManager.getInstance().getDefaultSetup();
            this.setup.setSystemProperty("org.eclipse.update.reconcile", "false");
            this.testExecutor = new RemoteTestExecutor(this.setup, applicationId, pluginId);
        }
        catch (SetupManager.SetupException e) {
            throw new IllegalStateException("unable to create setup", e);
        }
    }

    void addSessionCustomization(SessionCustomization sessionCustomization) {
        this.sessionCustomizations.add(sessionCustomization);
    }

    @Override
    public void setEclipseArgument(String key, String value) {
        this.setup.setEclipseArgument(key, value);
    }

    @Override
    public void setSystemProperty(String key, String value) {
        this.setup.setSystemProperty(key, value);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (!this.skipIfNotExecuteInHost(invocation, invocationContext)) {
            return;
        }
        Class testClass = (Class)extensionContext.getTestClass().get();
        Method testMethod = (Method)extensionContext.getTestMethod().get();
        boolean shouldFail = ((Method)extensionContext.getTestMethod().get()).getAnnotation(SessionShouldError.class) != null;
        try {
            this.prepareSession();
            this.testExecutor.executeRemotely(testClass.getName(), testMethod.getName(), shouldFail);
        }
        finally {
            this.cleanupSession();
        }
    }

    private boolean skipIfNotExecuteInHost(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext) throws Throwable {
        boolean shouldExecuteInHost;
        boolean bl = shouldExecuteInHost = ((Method)invocationContext.getExecutable()).getAnnotation(ExecuteInHost.class) != null;
        if (!shouldExecuteInHost) {
            invocation.skip();
            return true;
        }
        invocation.proceed();
        return false;
    }

    private void prepareSession() throws Exception {
        for (SessionCustomization customization : this.sessionCustomizations) {
            customization.prepareSession(this.setup);
        }
    }

    private void cleanupSession() throws Exception {
        for (SessionCustomization customization : this.sessionCustomizations) {
            customization.cleanupSession(this.setup);
        }
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.skipIfNotExecuteInHost(invocation, invocationContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.skipIfNotExecuteInHost(invocation, invocationContext);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.skipIfNotExecuteInHost(invocation, invocationContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.skipIfNotExecuteInHost(invocation, invocationContext);
    }
}

