/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness.session.customization;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import org.apiguardian.api.API;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.TestHarnessPlugin;
import org.eclipse.core.tests.harness.session.CustomSessionConfiguration;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestLoader;
import org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader;
import org.eclipse.pde.internal.junit.runtime.CoreTestApplication;
import org.eclipse.test.performance.Performance;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.migrationsupport.EnableJUnit4MigrationSupport;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.engine.SuiteTestEngine;
import org.junit.vintage.engine.VintageTestEngine;
import org.opentest4j.AssertionFailedError;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.prefs.Preferences;

public class CustomSessionConfigurationImpl
implements CustomSessionConfiguration {
    private static final String PROP_BUNDLES = "osgi.bundles";
    private static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_BUNDLES_DEFAULT_START_LEVEL = "osgi.bundles.defaultStartLevel";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA_READ_ONLY = "osgi.configuration.area.readOnly";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String TEMP_DIR_PREFIX = "eclipse_session_configuration";
    private final Collection<BundleReference> bundleReferences = new ArrayList<BundleReference>();
    private Path configurationDirectory;
    private boolean readOnly = false;
    private boolean cascaded = false;
    private boolean firstExecutedSession = true;

    public CustomSessionConfigurationImpl() {
        this.addMinimalBundleSet();
    }

    private void addMinimalBundleSet() {
        this.addBundle(FileLocator.class, "@2:start");
        this.addBundle(Platform.class, "@:start");
        this.addBundle(Job.class);
        this.addBundle(IExtension.class);
        this.addBundle(IEclipsePreferences.class);
        this.addBundle(Preferences.class);
        this.addBundle(IContentType.class);
        this.addBundle(IApplication.class);
        this.addBundle(TestHarnessPlugin.class);
        this.addBundle(Performance.class);
        this.addBundle(ITestLoader.class);
        this.addBundle(JUnit4TestLoader.class);
        this.addBundle(JUnit5TestLoader.class);
        this.addBundle(CoreTestApplication.class);
        this.addBundle(ByteBuddy.class);
        this.addBundle(Assertions.class);
        this.addBundle(CoreMatchers.class);
        if ("org.hamcrest".equals(FrameworkUtil.getBundle(CoreMatchers.class).getSymbolicName())) {
            Bundle maxHamcrestCoreBundle = null;
            Version maxHamcrestCoreVersion = null;
            Bundle[] bundleArray = FrameworkUtil.getBundle(ConfigurationSessionTestSuite.class).getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.hamcrest.core".equals(bundle.getSymbolicName())) {
                    Version version = bundle.getVersion();
                    if (maxHamcrestCoreVersion == null || maxHamcrestCoreVersion.compareTo(version) < 0) {
                        maxHamcrestCoreVersion = version;
                        maxHamcrestCoreBundle = bundle;
                    }
                }
                ++n2;
            }
            if (maxHamcrestCoreBundle != null) {
                this.addBundle(maxHamcrestCoreBundle, null);
            }
        }
        this.addBundle(Test.class);
        this.addBundle(org.junit.jupiter.api.Test.class);
        this.addBundle(JupiterTestEngine.class);
        this.addBundle(EnableJUnit4MigrationSupport.class);
        this.addBundle(ParameterizedTest.class);
        this.addBundle(VintageTestEngine.class);
        this.addBundle(JUnitException.class);
        this.addBundle(TestEngine.class);
        this.addBundle(Launcher.class);
        this.addBundle(JUnitPlatform.class);
        this.addBundle(Suite.class);
        this.addBundle(SuiteLauncherDiscoveryRequestBuilder.class);
        this.addBundle(SuiteTestEngine.class);
        this.addBundle(API.class);
        this.addBundle(AssertionFailedError.class);
    }

    @Override
    public CustomSessionConfiguration setCascaded() {
        this.cascaded = true;
        return this;
    }

    @Override
    public CustomSessionConfiguration setReadOnly() {
        this.readOnly = true;
        return this;
    }

    @Override
    public CustomSessionConfiguration setConfigurationDirectory(Path configurationDirectory) {
        Objects.requireNonNull(configurationDirectory);
        this.configurationDirectory = configurationDirectory;
        FileSystemHelper.deleteOnShutdownRecursively(configurationDirectory);
        return this;
    }

    @Override
    public Path getConfigurationDirectory() throws IOException {
        if (this.configurationDirectory == null) {
            this.setConfigurationDirectory(Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]));
        }
        return this.configurationDirectory;
    }

    @Override
    public void prepareSession(Setup setup) throws IOException {
        if (this.firstExecutedSession) {
            this.overwriteConfigurationAreaWritability(setup);
        }
        this.setCustomConfigurationArea(setup);
        if (this.firstExecutedSession) {
            this.createOrRefreshConfigIni();
        }
        if (this.cascaded) {
            this.createOrRefreshConfigIni();
        }
    }

    @Override
    public void cleanupSession(Setup setup) {
        if (this.firstExecutedSession) {
            this.removeConfigurationAreaWritabilityOverwrite(setup);
        }
        this.firstExecutedSession = false;
    }

    private void overwriteConfigurationAreaWritability(Setup setup) {
        setup.setSystemProperty(PROP_CONFIG_AREA_READ_ONLY, Boolean.FALSE.toString());
    }

    private void removeConfigurationAreaWritabilityOverwrite(Setup setup) {
        setup.setSystemProperty(PROP_CONFIG_AREA_READ_ONLY, null);
    }

    private void setCustomConfigurationArea(Setup setup) throws IOException {
        setup.setEclipseArgument("configuration", null);
        setup.setSystemProperty("osgi.configuration.area", this.getConfigurationDirectory().toString());
    }

    private void createOrRefreshConfigIni() throws IOException {
        Properties contents = new Properties();
        contents.put(PROP_BUNDLES, String.join((CharSequence)",", this.getBundleUrls()));
        contents.put(PROP_FRAMEWORK, CustomSessionConfigurationImpl.getOsgiFrameworkBundleUrl());
        contents.put(PROP_BUNDLES_DEFAULT_START_LEVEL, "4");
        contents.put(PROP_INSTALL_AREA, Platform.getInstallLocation().getURL().toExternalForm());
        contents.put(PROP_CONFIG_CASCADED, Boolean.valueOf(this.cascaded).toString());
        if (this.cascaded) {
            contents.put(PROP_SHARED_CONFIG_AREA, Platform.getConfigurationLocation().getURL().toExternalForm());
        }
        contents.put(PROP_CONFIG_AREA_READ_ONLY, Boolean.valueOf(this.readOnly).toString());
        Path configINI = this.getConfigurationDirectory().resolve("config.ini");
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = Files.newOutputStream(configINI, new OpenOption[0]);){
            contents.store(out, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public CustomSessionConfiguration addBundle(Class<?> classFromBundle) {
        Objects.requireNonNull(classFromBundle);
        this.addBundle(classFromBundle, null);
        return this;
    }

    private void addBundle(Class<?> classFromBundle, String suffix) {
        Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
        Assert.assertNotNull((String)("Class is not from a bundle: " + String.valueOf(classFromBundle)), (Object)bundle);
        this.addBundle(bundle, suffix);
    }

    @Override
    public CustomSessionConfiguration addBundle(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.addBundle(bundle, "");
        return this;
    }

    private void addBundle(Bundle bundle, String suffix) {
        this.bundleReferences.add(new BundleReference(bundle, suffix));
    }

    private Collection<String> getBundleUrls() {
        ((AbstractCollectionAssert)Assertions.assertThat(this.bundleReferences).as("check bundles are not empty", new Object[0])).isNotEmpty();
        return this.bundleReferences.stream().map(BundleReference::toURL).collect(Collectors.toList());
    }

    private static String getOsgiFrameworkBundleUrl() {
        Bundle osgiFrameworkBundle = FrameworkUtil.getBundle(CustomSessionConfigurationImpl.class).getBundleContext().getBundle("System Bundle");
        BundleReference osgiFrameworkBundleReference = new BundleReference(osgiFrameworkBundle);
        return osgiFrameworkBundleReference.toURL();
    }

    private record BundleReference(Bundle bundle, String suffix) {
        BundleReference(Bundle bundle, String suffix) {
            this.bundle = bundle;
            this.suffix = suffix != null ? suffix : "";
        }

        BundleReference(Bundle bundle) {
            this(bundle, null);
        }

        String toURL() {
            String externalForm;
            Optional location = FileLocator.getBundleFileLocation((Bundle)this.bundle);
            Assert.assertTrue((String)("Unable to locate bundle with id: " + this.bundle.getSymbolicName()), (boolean)location.isPresent());
            try {
                externalForm = ((File)location.get()).toURI().toURL().toExternalForm();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert file to URL string:" + String.valueOf(location.get()), e);
            }
            return "reference:" + externalForm + this.suffix;
        }
    }
}

