/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness.session.customization;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.session.CustomSessionWorkspace;
import org.eclipse.core.tests.session.Setup;

public class CustomSessionWorkspaceImpl
implements CustomSessionWorkspace {
    private Path workspaceDirectory;
    private static final String TEMP_DIR_PREFIX = "eclipse_session_workspace";

    @Override
    public CustomSessionWorkspace setWorkspaceDirectory(Path workspaceDirectory) {
        Objects.requireNonNull(workspaceDirectory);
        this.workspaceDirectory = workspaceDirectory;
        FileSystemHelper.deleteOnShutdownRecursively(workspaceDirectory);
        return this;
    }

    @Override
    public Path getWorkspaceDirectory() throws IOException {
        if (this.workspaceDirectory == null) {
            this.setWorkspaceDirectory(Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]));
        }
        return this.workspaceDirectory;
    }

    @Override
    public void prepareSession(Setup setup) throws Exception {
        setup.setEclipseArgument("data", this.getWorkspaceDirectory().toString());
    }

    @Override
    public void cleanupSession(Setup setup) throws Exception {
    }
}

