/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import junit.framework.TestResult;
import net.bytebuddy.ByteBuddy;
import org.apiguardian.api.API;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.TestHarnessPlugin;
import org.eclipse.core.tests.session.SessionTestSuite;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestLoader;
import org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.internal.junit.runtime.CoreTestApplication;
import org.eclipse.test.performance.Performance;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.migrationsupport.EnableJUnit4MigrationSupport;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.runner.JUnitPlatform;
import org.junit.platform.suite.api.Suite;
import org.junit.platform.suite.commons.SuiteLauncherDiscoveryRequestBuilder;
import org.junit.platform.suite.engine.SuiteTestEngine;
import org.junit.vintage.engine.VintageTestEngine;
import org.opentest4j.AssertionFailedError;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.prefs.Preferences;

public class ConfigurationSessionTestSuite
extends SessionTestSuite {
    private static final String PROP_CONFIG_AREA_READ_ONLY = "osgi.configuration.area.readOnly";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private final Collection<String> bundles = new ArrayList<String>();
    private final Map<String, String> configIniValues = new HashMap<String, String>();
    private boolean cascaded;
    private boolean cleanUp = true;
    private IPath configurationPath = FileSystemHelper.getRandomLocation(FileSystemHelper.getTempDir());
    private boolean prime = true;
    private boolean readOnly;
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    public ConfigurationSessionTestSuite(String pluginId, Class<?> theClass) {
        super(pluginId, theClass);
    }

    public ConfigurationSessionTestSuite(String pluginId, String name) {
        super(pluginId, name);
    }

    public void addMinimalBundleSet() {
        this.addBundle(FileLocator.class, "@2:start");
        this.addBundle(Platform.class, "@:start");
        this.addBundle(Job.class);
        this.addBundle(IExtension.class);
        this.addBundle(IEclipsePreferences.class);
        this.addBundle(Preferences.class);
        this.addBundle(IContentType.class);
        this.addBundle(IApplication.class);
        this.addBundle(TestHarnessPlugin.class);
        this.addBundle(Performance.class);
        this.addBundle(ITestLoader.class);
        this.addBundle(JUnit4TestLoader.class);
        this.addBundle(JUnit5TestLoader.class);
        this.addBundle(CoreTestApplication.class);
        this.addBundle(ByteBuddy.class);
        this.addBundle(Assertions.class);
        this.addBundle(CoreMatchers.class);
        if ("org.hamcrest".equals(FrameworkUtil.getBundle(CoreMatchers.class).getSymbolicName())) {
            Bundle maxHamcrestCoreBundle = null;
            Version maxHamcrestCoreVersion = null;
            Bundle[] bundleArray = FrameworkUtil.getBundle(ConfigurationSessionTestSuite.class).getBundleContext().getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.hamcrest.core".equals(bundle.getSymbolicName())) {
                    Version version = bundle.getVersion();
                    if (maxHamcrestCoreVersion == null || maxHamcrestCoreVersion.compareTo(version) < 0) {
                        maxHamcrestCoreVersion = version;
                        maxHamcrestCoreBundle = bundle;
                    }
                }
                ++n2;
            }
            if (maxHamcrestCoreBundle != null) {
                this.addBundle(maxHamcrestCoreBundle, null);
            }
        }
        this.addBundle(Test.class);
        this.addBundle(org.junit.jupiter.api.Test.class);
        this.addBundle(JupiterTestEngine.class);
        this.addBundle(EnableJUnit4MigrationSupport.class);
        this.addBundle(ParameterizedTest.class);
        this.addBundle(VintageTestEngine.class);
        this.addBundle(JUnitException.class);
        this.addBundle(TestEngine.class);
        this.addBundle(Launcher.class);
        this.addBundle(JUnitPlatform.class);
        this.addBundle(Suite.class);
        this.addBundle(SuiteLauncherDiscoveryRequestBuilder.class);
        this.addBundle(SuiteTestEngine.class);
        this.addBundle(API.class);
        this.addBundle(AssertionFailedError.class);
    }

    public void addBundle(String id) {
        String suffix = "";
        int atIndex = id.indexOf(64);
        if (atIndex >= 0) {
            suffix = id.substring(atIndex);
            id = id.substring(0, atIndex);
        }
        Bundle[] allVersions = Platform.getBundles((String)id, null);
        Assert.assertNotNull((String)("No bundles found in test runtime with id: " + id), (Object)allVersions);
        String refSuffix = suffix;
        List urLs = Arrays.stream(allVersions).map(b -> this.getBundleReference((Bundle)b, refSuffix)).collect(Collectors.toList());
        this.bundles.addAll(urLs);
    }

    public void addThisBundle() {
        this.addBundle(STACK_WALKER.getCallerClass());
    }

    public void addBundle(Class<?> classFromBundle) {
        this.addBundle(classFromBundle, null);
    }

    public void addBundle(Class<?> classFromBundle, String suffix) {
        Bundle bundle = FrameworkUtil.getBundle(classFromBundle);
        Assert.assertNotNull((String)("Class is not from a bundle: " + String.valueOf(classFromBundle)), (Object)bundle);
        this.addBundle(bundle, suffix);
    }

    public void addBundle(Bundle bundle, String suffix) {
        String url = this.getBundleReference(bundle, suffix);
        this.bundles.add(url);
    }

    public void setConfigIniValue(String key, String value) {
        this.configIniValues.put(key, value);
    }

    private void createConfigINI() throws IOException {
        Assert.assertTrue((String)"1.0", (!this.bundles.isEmpty() ? 1 : 0) != 0);
        Properties contents = new Properties();
        StringBuilder osgiBundles = new StringBuilder();
        for (String string : this.bundles) {
            osgiBundles.append(string);
            osgiBundles.append(',');
        }
        osgiBundles.deleteCharAt(osgiBundles.length() - 1);
        contents.put("osgi.bundles", osgiBundles.toString());
        Bundle osgiFrameworkBundle = FrameworkUtil.getBundle(ConfigurationSessionTestSuite.class).getBundleContext().getBundle("System Bundle");
        String osgiFramework = this.getBundleReference(osgiFrameworkBundle, null);
        contents.put("osgi.framework", osgiFramework);
        contents.put("osgi.bundles.defaultStartLevel", "4");
        contents.put("osgi.install.area", Platform.getInstallLocation().getURL().toExternalForm());
        contents.put(PROP_CONFIG_CASCADED, Boolean.toString(this.cascaded));
        if (this.cascaded) {
            contents.put(PROP_SHARED_CONFIG_AREA, Platform.getConfigurationLocation().getURL().toExternalForm());
        }
        contents.put(PROP_CONFIG_AREA_READ_ONLY, Boolean.toString(this.readOnly));
        for (Map.Entry<String, String> entry : this.configIniValues.entrySet()) {
            contents.put(entry.getKey(), entry.getValue());
        }
        File configINI = this.configurationPath.append("config.ini").toFile();
        Object object = null;
        Object var7_8 = null;
        try (FileOutputStream out = new FileOutputStream(configINI);){
            contents.store(out, null);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    @Override
    protected void fillTestDescriptor(TestDescriptor test) throws SetupManager.SetupException {
        super.fillTestDescriptor(test);
        if (this.prime) {
            test.getSetup().setSystemProperty(PROP_CONFIG_AREA_READ_ONLY, Boolean.FALSE.toString());
            this.prime = false;
        }
    }

    public IPath getConfigurationPath() {
        return this.configurationPath;
    }

    private String getBundleReference(Bundle bundle, String suffix) {
        String externalForm;
        Optional location = FileLocator.getBundleFileLocation((Bundle)bundle);
        Assert.assertTrue((String)("Unable to locate bundle with id: " + bundle.getSymbolicName()), (boolean)location.isPresent());
        try {
            externalForm = ((File)location.get()).toURI().toURL().toExternalForm();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert file to URL string:" + String.valueOf(location.get()), e);
        }
        return "reference:" + externalForm + (suffix != null ? suffix : "");
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected Setup newSetup() throws SetupManager.SetupException {
        Setup base = super.newSetup();
        base.setEclipseArgument("configuration", null);
        base.setSystemProperty("osgi.configuration.area", this.configurationPath.toOSString());
        return base;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(TestResult result) {
        this.configurationPath.toFile().mkdirs();
        try {
            block13: {
                int i;
                junit.framework.Test[] allTests;
                block12: {
                    if (this.prime) {
                        try {
                            this.createConfigINI();
                        }
                        catch (IOException e) {
                            org.junit.jupiter.api.Assertions.fail((Throwable)e);
                        }
                    }
                    allTests = this.getTests(true);
                    i = 0;
                    if (!true) break block12;
                    if (i >= allTests.length) return;
                    if (result.shouldStop()) break block13;
                }
                do {
                    if (this.cascaded) {
                        try {
                            this.createConfigINI();
                        }
                        catch (IOException e) {
                            org.junit.jupiter.api.Assertions.fail((Throwable)e);
                        }
                    }
                    this.runTest(allTests[i], result);
                    ++i;
                    if (i >= allTests.length) return;
                } while (!result.shouldStop());
            }
            return;
        }
        finally {
            if (this.cleanUp) {
                FileSystemHelper.clear(this.configurationPath.toFile());
            }
        }
    }

    public void setCascaded(boolean cascaded) {
        this.cascaded = cascaded;
    }

    public void setCleanup(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public void setConfigurationPath(IPath configurationPath) {
        this.configurationPath = configurationPath;
    }

    public void setPrime(boolean prime) {
        this.prime = prime;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static File getConfigurationDir() {
        Location configurationLocation = Platform.getConfigurationLocation();
        URL configurationURL = configurationLocation.getURL();
        if (!"file".equals(configurationURL.getProtocol())) {
            throw new IllegalStateException();
        }
        return new File(configurationURL.getFile());
    }
}

