/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.SessionTestRunner;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;

public class SessionTestSuite
extends TestSuite {
    public static final String CORE_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";
    public static final String UI_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.uitestapplication";
    protected String applicationId = "org.eclipse.pde.junit.runtime.coretestapplication";
    private final Set<TestCase> crashTests = new HashSet<TestCase>();
    protected String pluginId;
    private Setup setup;
    protected SessionTestRunner testRunner;

    public SessionTestSuite(String pluginId) {
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, Class<?> theClass) {
        super(theClass);
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, Class<? extends TestCase> theClass, String name) {
        super(theClass, name);
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, String name) {
        super(name);
        this.pluginId = pluginId;
    }

    public void addCrashTest(TestCase test) {
        this.crashTests.add(test);
        super.addTest((Test)test);
    }

    protected void fillTestDescriptor(TestDescriptor test) throws SetupManager.SetupException {
        if (test.getApplicationId() == null) {
            test.setApplicationId(this.applicationId);
        }
        if (test.getPluginId() == null) {
            test.setPluginId(this.pluginId);
        }
        if (test.getSetup() == null) {
            test.setSetup(this.getSetup());
        }
        if (!test.isCrashTest() && this.crashTests.contains(test.getTest())) {
            test.setCrashTest(true);
        }
        test.setTestRunner(this.getTestRunner());
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Setup getSetup() throws SetupManager.SetupException {
        if (this.setup == null) {
            this.setup = this.newSetup();
        }
        return this.setup;
    }

    protected SessionTestRunner getTestRunner() {
        if (this.testRunner == null) {
            this.testRunner = new SessionTestRunner();
        }
        return this.testRunner;
    }

    protected Test[] getTests(boolean sort) {
        Test[] allTests = new Test[this.testCount()];
        Enumeration e = this.tests();
        int i = 0;
        while (i < allTests.length) {
            allTests[i] = (Test)e.nextElement();
            ++i;
        }
        if (sort) {
            Arrays.sort(allTests, (o1, o2) -> ((TestCase)o1).getName().compareTo(((TestCase)o2).getName()));
        }
        return allTests;
    }

    protected Setup newSetup() throws SetupManager.SetupException {
        Setup base = SetupManager.getInstance().getDefaultSetup();
        base.setSystemProperty("org.eclipse.update.reconcile", "false");
        return base;
    }

    protected void runSessionTest(TestDescriptor test, TestResult result) {
        try {
            this.fillTestDescriptor(test);
            test.run(result);
        }
        catch (SetupManager.SetupException e) {
            Throwable cause = e.getCause();
            result.addError(test.getTest(), cause != null ? cause : e);
        }
    }

    public final void runTest(Test test, TestResult result) {
        if (test instanceof TestDescriptor) {
            this.runSessionTest((TestDescriptor)test, result);
        } else if (test instanceof TestCase) {
            this.runSessionTest(new TestDescriptor((TestCase)test), result);
        } else if (test instanceof TestSuite) {
            this.runTestSuite((TestSuite)test, result);
        } else {
            test.run(result);
        }
    }

    protected void runTestSuite(TestSuite suite, TestResult result) {
        Enumeration e = suite.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            this.runTest(test, result);
        }
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    void setSetup(Setup setup) {
        this.setup = setup;
    }
}

