/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session.samples;

import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.eclipse.core.tests.session.SessionTestRunner;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;
import org.eclipse.core.tests.session.samples.SampleSessionTest;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class MultipleRunsTest
extends TestCase {
    public void testMultipleRuns() throws SetupManager.SetupException {
        TestDescriptor test = new TestDescriptor(SampleSessionTest.class.getName(), "testApplicationStartup");
        test.setApplicationId("org.eclipse.pde.junit.runtime.coretestapplication");
        test.setPluginId("org.eclipse.core.tests.harness");
        test.setTestRunner(new SessionTestRunner());
        test.setSetup(SetupManager.getInstance().getDefaultSetup());
        test.getSetup().setSystemProperty("eclipse.perf.dbloc", System.getProperty("eclipse.perf.dbloc"));
        test.getSetup().setSystemProperty("eclipse.perf.config", System.getProperty("eclipse.perf.config"));
        TestResult result = new TestResult();
        int i = 0;
        while (i < 5) {
            test.run(result);
            if (result.failureCount() > 0) {
                ((TestFailure)result.failures().nextElement()).thrownException().printStackTrace();
                return;
            }
            if (result.errorCount() > 0) {
                ((TestFailure)result.errors().nextElement()).thrownException().printStackTrace();
                return;
            }
            ++i;
        }
        PerformanceMeter meter = Performance.getDefault().createPerformanceMeter(test.getTestClass() + "." + test.getTestMethod());
        Performance.getDefault().assertPerformanceInRelativeBand(meter, Dimension.ELAPSED_PROCESS, -50, 5);
    }
}

