/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browser.demos.views;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.examples.browser.demos.BrowserDemoPlugin;
import org.eclipse.swt.examples.browser.demos.Pawns;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabItem;

public class PawnTab {
    Action pawnAction;
    Action editAction;
    Browser browser = null;
    ReversiListener reversiListener;
    static final int TYPE_WELCOME = 1;
    static final int TYPE_START = 2;
    static final int TYPE_BOARD = 3;
    static final int TYPE_BOARD_OVER = 4;
    static final String URL = "http://www.org.eclipse.swt.examples.browser.demos.pawns/";
    static String PLUGIN_PATH = BrowserDemoPlugin.PLUGIN_PATH;
    static String CSS_FOLDER = "css2";
    static String URL_CSS = PLUGIN_PATH + CSS_FOLDER + "/style.css";
    static String URL_WELCOME = PLUGIN_PATH + CSS_FOLDER + "/welcome.html";
    static final String ACTION_START_2_PLAYERS = "actionstart2players";
    static final String ACTION_START_1_PLAYER = "actionstart1player";
    static final String ACTION_WHITE = "actionwhite";
    static final String ACTION_BLACK = "actionblack";
    static final String ACTION_THEME = "actiontheme";
    static byte[][] game = null;
    static boolean isWhite = true;
    static int cntWhite = 0;
    static int cntBlack = 0;
    static boolean computer = false;
    static int cx;
    static int cy;
    static final byte EMPTY = 0;
    static final byte WHITE = 1;
    static final byte BLACK = 2;
    static final byte WALL = 3;
    static Pawns ttr;
    static int[] move;

    static {
        ttr = null;
        move = new int[2];
    }

    public PawnTab(TabItem item) {
        try {
            this.browser = new Browser((Composite)item.getParent(), 0);
        }
        catch (SWTError e2) {
            e2.printStackTrace();
            return;
        }
        item.setText("Pawns");
        item.setControl((Control)this.browser);
        Menu menu = new Menu((Decorations)this.browser.getShell(), 8);
        MenuItem item2 = new MenuItem(menu, 8);
        item2.setText("End Game");
        item2.addListener(13, e -> {
            game = null;
            isWhite = true;
            cntWhite = 0;
            cntBlack = 0;
            ttr = null;
            this.browser.setUrl(URL_WELCOME);
        });
        this.browser.setMenu(menu);
        this.reversiListener = new ReversiListener();
        this.browser.addLocationListener((LocationListener)this.reversiListener);
        this.browser.setUrl(URL_WELCOME);
    }

    static String getHtml(int type) {
        String html = null;
        switch (type) {
            case 3: 
            case 4: {
                html = "<html><header><link rel=\"stylesheet\" type=\"text/css\" href=\"" + URL_CSS + "\"></header><body><div class=\"board\"><table><tbody>";
                Object classPlayerWhite = "playerwhite";
                Object classPlayerBlack = "playerblack";
                if (type == 4) {
                    if (cntWhite > cntBlack) {
                        classPlayerWhite = (String)classPlayerWhite + " winner";
                        classPlayerBlack = (String)classPlayerBlack + " loser";
                    } else {
                        classPlayerWhite = (String)classPlayerWhite + " loser";
                        classPlayerBlack = (String)classPlayerBlack + " winner";
                    }
                }
                String white = "<td class=\"white\"/>";
                String black = "<td class=\"black\"/>";
                String wall = "<td class=\"wall\"/>";
                int i = 0;
                while (i < game.length) {
                    html = html + "<tr>";
                    int j = 0;
                    while (j < game[0].length) {
                        switch (game[i][j]) {
                            case 0: {
                                String empty = "<td class=\"" + (isWhite ? "whitelink" : "blacklink") + "\">" + (String)(isWhite || !isWhite && !computer ? "<a href=\"http://www.org.eclipse.swt.examples.browser.demos.pawns/" + (isWhite ? ACTION_WHITE : ACTION_BLACK) + "/xx" + i + "yy" + j + "\" class=\"empty\"/>" : "<div class=\"empty\"/>") + "</td>";
                                html = html + empty;
                                break;
                            }
                            case 1: {
                                html = html + white;
                                break;
                            }
                            case 2: {
                                html = html + black;
                                break;
                            }
                            case 3: {
                                html = html + wall;
                            }
                        }
                        ++j;
                    }
                    html = html + "</tr>";
                    ++i;
                }
                html = html + "</tbody></table></div>";
                html = html + "<div class=\"" + (String)classPlayerWhite + "\">" + cntWhite + "</div>";
                html = html + "<div class=\"" + (String)classPlayerBlack + "\">" + cntBlack + "</div>";
                html = html + "</body></html>";
            }
        }
        return html;
    }

    public static boolean add(int x, int y, byte color) {
        PawnTab.game[x][y] = color;
        int cnt = Math.min(x, y);
        int n = 0;
        byte other_color = color == 1 ? (byte)2 : 1;
        int d = 1;
        while (d <= cnt) {
            if (game[x - d][y - d] != other_color) {
                if (game[x - d][y - d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x - d][y - d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = Math.min(game.length - 1 - x, game[0].length - 1 - y);
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x + d][y + d] != other_color) {
                if (game[x + d][y + d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x + d][y + d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = Math.min(game.length - 1 - x, y);
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x + d][y - d] != other_color) {
                if (game[x + d][y - d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x + d][y - d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = Math.min(x, game[0].length - 1 - y);
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x - d][y + d] != other_color) {
                if (game[x - d][y + d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x - d][y + d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = y;
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x][y - d] != other_color) {
                if (game[x][y - d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x][y - d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = game[0].length - 1 - y;
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x][y + d] != other_color) {
                if (game[x][y + d] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x][y + d] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = x;
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x - d][y] != other_color) {
                if (game[x - d][y] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x - d][y] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        cnt = game.length - 1 - x;
        n = 0;
        d = 1;
        while (d <= cnt) {
            if (game[x + d][y] != other_color) {
                if (game[x + d][y] != color || n <= 0) break;
                d = 1;
                while (d <= n) {
                    PawnTab.game[x + d][y] = color;
                    ++d;
                }
                break;
            }
            ++n;
            ++d;
        }
        boolean hasMore = false;
        cntWhite = 0;
        cntBlack = 0;
        byte[][] byArray = game;
        int n2 = game.length;
        int n3 = 0;
        while (n3 < n2) {
            byte[] element = byArray[n3];
            int j = 0;
            while (j < game[0].length) {
                switch (element[j]) {
                    case 0: {
                        hasMore = true;
                        break;
                    }
                    case 1: {
                        ++cntWhite;
                        break;
                    }
                    case 2: {
                        ++cntBlack;
                    }
                }
                ++j;
            }
            ++n3;
        }
        return hasMore;
    }

    public static void play(Display display, Browser browser, int delay) {
        ttr.playRequest(game, 2);
        display.timerExec(3000, () -> {
            ttr.getBestMove(move);
            boolean hasMore = PawnTab.add(move[0], move[1], (byte)2);
            isWhite = true;
            browser.setText(PawnTab.getHtml(hasMore ? 3 : 4));
        });
    }

    public static void main(String[] args) {
    }

    public class ReversiListener
    implements LocationListener {
        public void changed(LocationEvent e) {
        }

        public void changing(LocationEvent e) {
            try {
                Browser browser = (Browser)e.widget;
                if (e.location.contains(PawnTab.ACTION_START_1_PLAYER) || e.location.contains(PawnTab.ACTION_START_2_PLAYERS)) {
                    computer = e.location.contains(PawnTab.ACTION_START_1_PLAYER);
                    game = new byte[8][8];
                    if (computer) {
                        ttr = new Pawns();
                    }
                    int i = 0;
                    while (i < 5) {
                        PawnTab.game[(int)(Math.random() * (double)PawnTab.game.length)][(int)(Math.random() * (double)PawnTab.game[0].length)] = 3;
                        ++i;
                    }
                    e.display.asyncExec(() -> {
                        boolean bl = browser.setText(PawnTab.getHtml(3));
                    });
                    e.doit = false;
                    return;
                }
                if (e.location.contains(PawnTab.ACTION_THEME)) {
                    int index = e.location.indexOf(PawnTab.ACTION_THEME) + PawnTab.ACTION_THEME.length() + 1;
                    CSS_FOLDER = e.location.substring(index, index + 4);
                    URL_CSS = PLUGIN_PATH + CSS_FOLDER + "/style.css";
                    URL_WELCOME = PLUGIN_PATH + CSS_FOLDER + "/welcome.html";
                    e.display.asyncExec(() -> {
                        boolean bl = browser.setUrl(URL_WELCOME);
                    });
                    e.doit = false;
                    return;
                }
                byte player = 0;
                if (e.location.contains(PawnTab.ACTION_WHITE)) {
                    player = 1;
                } else if (e.location.contains(PawnTab.ACTION_BLACK)) {
                    player = 2;
                }
                if (player != 0) {
                    int index = e.location.indexOf("xx") + 2;
                    int x = Integer.parseInt(e.location.substring(index, index + 1));
                    index = e.location.indexOf("yy") + 2;
                    int y = Integer.parseInt(e.location.substring(index, index + 1));
                    boolean hasMore = PawnTab.add(x, y, player);
                    isWhite = player != 1;
                    browser.setText(PawnTab.getHtml(hasMore ? 3 : 4));
                    if (computer && hasMore && !isWhite) {
                        PawnTab.play(e.display, browser, 5000);
                    }
                    e.doit = false;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

