/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests;

import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceMemento;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.progress.UIJob;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class AbstractDebugTest {
    private static boolean welcomeClosed;
    protected long testTimeout = 30000L;
    private final PreferenceMemento prefMemento = new PreferenceMemento();
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        TestUtil.log(1, this.name.getMethodName(), "setUp", new Throwable[0]);
        this.assertWelcomeScreenClosed();
    }

    @After
    public void tearDown() throws Exception {
        TestUtil.log(1, this.name.getMethodName(), "tearDown", new Throwable[0]);
        TestUtil.cleanUp(this.name.getMethodName());
        this.prefMemento.resetPreferences();
    }

    protected final void assertWelcomeScreenClosed() throws Exception {
        if (!welcomeClosed && PlatformUI.isWorkbenchRunning()) {
            final IWorkbench wb = PlatformUI.getWorkbench();
            if (wb == null) {
                return;
            }
            if (Display.getCurrent() != null) {
                AbstractDebugTest.closeIntro(wb);
                return;
            }
            UIJob job = new UIJob("close welcome screen for debug test suite"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AbstractDebugTest.closeIntro(wb);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.setSystem(true);
            job.schedule();
        }
    }

    public void waitWhile(Predicate<AbstractDebugTest> condition, long timeout, Function<AbstractDebugTest, String> errorMessage) throws Exception {
        TestUtil.waitWhile(condition, this, timeout, errorMessage);
    }

    public void waitWhile(Predicate<AbstractDebugTest> condition, Function<AbstractDebugTest, String> errorMessage) throws Exception {
        TestUtil.waitWhile(condition, this, this.testTimeout, errorMessage);
    }

    private static void closeIntro(IWorkbench wb) {
        IIntroManager im;
        IIntroPart intro;
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        if (window != null && (intro = (im = wb.getIntroManager()).getIntro()) != null) {
            welcomeClosed = im.closeIntro(intro);
        }
    }

    protected <T> void setPreference(IPreferenceStore store, String name, T value) {
        this.prefMemento.setValue(store, name, value);
    }
}

