/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TestUtil {
    static Set<Job> runningJobs = new LinkedHashSet<Job>();

    public static void cleanUp(String owner) {
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
        boolean timedOut = TestUtil.waitForJobs(owner, 5L, 5000L, new Object[0]);
        if (timedOut) {
            TestUtil.log(1, owner, "Trying to cancel running jobs: " + String.valueOf(TestUtil.getRunningOrWaitingJobs(null, new Object[0])), new Throwable[0]);
            TestUtil.getRunningOrWaitingJobs(null, new Object[0]).forEach(Job::cancel);
            TestUtil.waitForJobs(owner, 5L, 1000L, new Object[0]);
        }
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
    }

    public static void log(int severity, String owner, String message, Throwable ... optionalError) {
        Throwable error = null;
        if (optionalError != null && optionalError.length > 0) {
            error = optionalError[0];
        }
        Bundle testBundle = FrameworkUtil.getBundle(TestUtil.class);
        Status status = new Status(severity, testBundle.getSymbolicName(), "[" + owner + "] " + message, error);
        ILog.of((Bundle)testBundle).log((IStatus)status);
    }

    public static void processUIEvents() {
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static void processUIEvents(long millis) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < millis) {
            Display display = Display.getCurrent();
            if (display != null && !display.isDisposed()) {
                while (display.readAndDispatch()) {
                }
                continue;
            }
            Thread.sleep(10L);
        }
    }

    public static <T> void waitWhile(Predicate<T> condition, T context, long timeout, Function<T, String> errorMessage) throws Exception {
        long start = System.currentTimeMillis();
        Display display = Display.getCurrent();
        while (System.currentTimeMillis() - start < timeout && condition.test(context)) {
            if (display != null && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                Thread.sleep(0L);
                continue;
            }
            Thread.sleep(5L);
        }
        Boolean stillTrue = condition.test(context);
        if (stillTrue.booleanValue()) {
            Assert.fail((String)errorMessage.apply(context));
        }
    }

    public static boolean waitWhile(Supplier<Boolean> condition, long timeout) throws Exception {
        Supplier<Boolean> nonNullCondition = condition != null ? condition : () -> true;
        long start = System.currentTimeMillis();
        Display display = Display.getCurrent();
        while (System.currentTimeMillis() - start < timeout && nonNullCondition.get().booleanValue()) {
            Thread.yield();
            if (display != null && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                Thread.sleep(1L);
                continue;
            }
            Thread.sleep(5L);
        }
        return nonNullCondition.get();
    }

    public static boolean waitForJobs(String owner, Object jobFamily, long minTimeMs, long maxTimeMs) {
        return TestUtil.waitForJobs(owner, jobFamily, minTimeMs, maxTimeMs, null);
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs, Object ... excludedFamilies) {
        return TestUtil.waitForJobs(owner, null, minTimeMs, maxTimeMs, excludedFamilies);
    }

    public static boolean waitForJobs(String owner, Object jobFamily, long minTimeMs, long maxTimeMs, Object ... excludedFamilies) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        Job.getJobManager().wakeUp(jobFamily);
        long start = System.nanoTime();
        while (System.nanoTime() - start < minTimeMs * 1000000L) {
            TestUtil.processUIEvents();
            try {
                Thread.sleep(Math.min(10L, minTimeMs));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!Job.getJobManager().isIdle()) {
            List<Job> jobs = TestUtil.getRunningOrWaitingJobs(jobFamily, excludedFamilies);
            if (jobs.isEmpty()) break;
            jobs.forEach(Job::wakeUp);
            if (runningJobs.containsAll(jobs)) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            if (System.nanoTime() - start >= maxTimeMs * 1000000L) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            TestUtil.processUIEvents();
            Thread.yield();
        }
        runningJobs.clear();
        return false;
    }

    private static void dumpRunningOrWaitingJobs(String owner, List<Job> jobs) {
        String message = "Some job is still running or waiting to run: " + TestUtil.getDump(jobs);
        TestUtil.log(4, owner, message, new RuntimeException(message));
    }

    private static String getDump(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return "";
        }
        runningJobs.clear();
        StringBuilder sb = new StringBuilder();
        for (Job job : jobs) {
            ThreadInfo[] threadInfos;
            runningJobs.add(job);
            sb.append("\n'").append(job.toString()).append("'/");
            sb.append(job.getClass().getName());
            sb.append(":").append(JobManager.printState((Job)job));
            Thread thread = job.getThread();
            if (thread != null && (threadInfos = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{thread.threadId()}, true, true))[0] != null) {
                sb.append("\nthread info: ").append(threadInfos[0]);
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static List<Job> getRunningOrWaitingJobs(Object jobFamily, Object ... excludedFamilies) {
        Job[] jobs;
        ArrayList<Job> running = new ArrayList<Job>();
        Job[] jobArray = jobs = Job.getJobManager().find(jobFamily);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (TestUtil.isRunningOrWaitingJob(job) && !TestUtil.belongsToFamilies(job, excludedFamilies)) {
                running.add(job);
            }
            ++n2;
        }
        return running;
    }

    private static boolean isRunningOrWaitingJob(Job job) {
        int state = job.getState();
        return state == 4 || state == 2;
    }

    private static boolean belongsToFamilies(Job job, Object ... excludedFamilies) {
        if (excludedFamilies == null || excludedFamilies.length == 0) {
            return false;
        }
        Object[] objectArray = excludedFamilies;
        int n = excludedFamilies.length;
        int n2 = 0;
        while (n2 < n) {
            Object family = objectArray[n2];
            if (job.belongsTo(family)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

