/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.breakpoint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.breakpoint.TestBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class BreakpointTests
extends AbstractDebugTest {
    private final IBreakpointManager bpm = DebugPlugin.getDefault().getBreakpointManager();

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        for (IBreakpoint iBreakpoint : this.getTestBreakpoints()) {
            iBreakpoint.delete();
        }
    }

    private List<TestBreakpoint> getTestBreakpoints() {
        ArrayList<TestBreakpoint> bps = new ArrayList<TestBreakpoint>();
        IBreakpoint[] iBreakpointArray = this.bpm.getBreakpoints("org.eclipse.debug.tests");
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            Assert.assertTrue((boolean)(bp instanceof TestBreakpoint));
            bps.add((TestBreakpoint)bp);
            ++n2;
        }
        return bps;
    }

    @Test
    public void testBug424561_undoRedoUndoGone() throws Exception {
        boolean viewVisible = true;
        BreakpointsView view = (BreakpointsView)DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
        if (view == null) {
            viewVisible = false;
            view = (BreakpointsView)DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.debug.ui.BreakpointView");
        }
        Assert.assertNotNull((String)"Failed to obtain breakpoint view.", (Object)view);
        try {
            String content = "Bug 424561";
            TestBreakpoint bp = new TestBreakpoint(content);
            IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
            IUndoContext context = DebugUITools.getBreakpointsUndoContext();
            this.bpm.addBreakpoint((IBreakpoint)bp);
            TestUtil.waitWhile(c -> c.getTestBreakpoints().isEmpty(), this, this.testTimeout, c -> "Breakpoint is not created");
            Assert.assertTrue((String)"Breakpoint marker missing", (boolean)bp.getMarker().exists());
            Assert.assertTrue((String)"Breakpoint not registered", (boolean)bp.isRegistered());
            DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{bp}, null, null);
            Assert.assertTrue((boolean)operationHistory.canUndo(context));
            TestUtil.waitWhile(c -> !c.getTestBreakpoints().isEmpty(), this, this.testTimeout, c -> "Breakpoint is not deleted");
            Assert.assertFalse((String)"Breakpoint marker not removed", (boolean)bp.getMarker().exists());
            Assert.assertFalse((String)"Breakpoint still registered", (boolean)bp.isRegistered());
            operationHistory.undo(context, null, null);
            Assert.assertTrue((boolean)operationHistory.canRedo(context));
            TestUtil.waitWhile(c -> c.getTestBreakpoints().isEmpty(), this, this.testTimeout, c -> "Breakpoint is not recreated");
            bp = this.getTestBreakpoints().get(0);
            Assert.assertEquals((String)"Breakpoint attributes not correctly restored", (Object)content, (Object)bp.getText());
            Assert.assertTrue((String)"Breakpoint marker missing", (boolean)bp.getMarker().exists());
            Assert.assertTrue((String)"Breakpoint not registered", (boolean)bp.isRegistered());
            operationHistory.redo(context, null, null);
            Assert.assertTrue((boolean)operationHistory.canUndo(context));
            TestUtil.waitWhile(c -> !c.getTestBreakpoints().isEmpty(), this, this.testTimeout, c -> "Breakpoint is not deleted");
            Assert.assertFalse((String)"Breakpoint marker not removed", (boolean)bp.getMarker().exists());
            Assert.assertFalse((String)"Breakpoint still registered", (boolean)bp.isRegistered());
            operationHistory.undo(context, null, null);
            Assert.assertTrue((boolean)operationHistory.canRedo(context));
            TestUtil.waitWhile(c -> c.getTestBreakpoints().isEmpty(), this, this.testTimeout, c -> "Breakpoint is not recreated");
            bp = this.getTestBreakpoints().get(0);
            Assert.assertEquals((String)"Breakpoint attributes not correctly restored", (Object)content, (Object)bp.getText());
            Assert.assertTrue((String)"Breakpoint marker missing", (boolean)bp.getMarker().exists());
            Assert.assertTrue((String)"Breakpoint not registered", (boolean)bp.isRegistered());
            BreakpointsView finalView = view;
            TestBreakpoint finalBp = bp;
            TestUtil.waitWhile(c -> {
                TreeItem item = (TreeItem)finalView.getTreeModelViewer().testFindItem((Object)finalBp);
                return item == null || item.getText() == null || !item.getText().contains(content);
            }, this, this.testTimeout, c -> "Breakpoint not restored in view");
        }
        finally {
            if (!viewVisible) {
                DebugUIPlugin.getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)view);
            }
        }
    }
}

