/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.breakpoint;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.model.elements.SerialExecutor;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.junit.Assert;
import org.junit.Test;

public class SerialExecutorTest
extends AbstractDebugTest {
    @Override
    public void tearDown() throws Exception {
        Job.getJobManager().cancel((Object)this);
        super.tearDown();
    }

    @Test
    public void testSimpleExecution() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", (Object)this);
        AtomicInteger executions = new AtomicInteger(0);
        serialExecutor.schedule(executions::incrementAndGet);
        Job.getJobManager().join((Object)this, null);
        Assert.assertEquals((long)1L, (long)executions.get());
        serialExecutor.schedule(executions::incrementAndGet);
        Job.getJobManager().join((Object)this, null);
        Assert.assertEquals((long)2L, (long)executions.get());
        serialExecutor.schedule(executions::incrementAndGet);
        serialExecutor.schedule(executions::incrementAndGet);
        Job.getJobManager().join((Object)this, null);
        Assert.assertEquals((long)4L, (long)executions.get());
    }

    @Test
    public void testSerialExecution() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", (Object)this);
        AtomicInteger executions = new AtomicInteger(0);
        AtomicInteger parallelExecutions = new AtomicInteger(0);
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        int RUNS = 20;
        int WAIT_MILLIS = 2;
        long start = System.nanoTime();
        int i = 0;
        while (i < RUNS) {
            serialExecutor.schedule(() -> {
                ReentrantReadWriteLock.WriteLock writeLock = rwl.writeLock();
                if (writeLock.tryLock()) {
                    try {
                        Thread.sleep(WAIT_MILLIS);
                        executions.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        parallelExecutions.incrementAndGet();
                    }
                    writeLock.unlock();
                } else {
                    parallelExecutions.incrementAndGet();
                }
                Job[] jobs = Job.getJobManager().find((Object)this);
                if (jobs.length != 1) {
                    parallelExecutions.incrementAndGet();
                }
            });
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Object[] jobs = Job.getJobManager().find((Object)this);
        Assertions.assertThat((Object[])jobs).isEmpty();
        long stop = System.nanoTime();
        long millis = (stop - start) / 1000000L;
        Assert.assertEquals((long)RUNS, (long)executions.get());
        Assert.assertEquals((long)0L, (long)parallelExecutions.get());
        long minimalMillis = RUNS * WAIT_MILLIS;
        Assert.assertTrue((String)("Test did finish too fast (" + millis + " ms)"), (millis >= minimalMillis ? 1 : 0) != 0);
    }

    @Test
    public void testSchedulingQueue() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", (Object)this);
        AtomicInteger executions = new AtomicInteger();
        int RUNS = 20;
        int WAIT_MILLIS = 2;
        int i = 0;
        while (i < RUNS) {
            serialExecutor.schedule(() -> {
                try {
                    Thread.sleep(WAIT_MILLIS);
                    executions.incrementAndGet();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Object[] jobs = Job.getJobManager().find((Object)this);
        Assertions.assertThat((Object[])jobs).isEmpty();
        Assert.assertEquals((long)RUNS, (long)executions.get());
    }

    @Test
    public void testHeavyScheduling() throws InterruptedException {
        SerialExecutor serialExecutor = new SerialExecutor("test", (Object)this);
        AtomicInteger executions = new AtomicInteger();
        int RUNS = 200;
        int i = 0;
        while (i < RUNS) {
            serialExecutor.schedule(executions::incrementAndGet);
            ++i;
        }
        Job.getJobManager().join((Object)this, null);
        Object[] jobs = Job.getJobManager().find((Object)this);
        Assertions.assertThat((Object[])jobs).isEmpty();
        Assert.assertEquals((long)RUNS, (long)executions.get());
    }

    @Test
    public void testJoin() throws InterruptedException {
        int run = 0;
        while (run < 100) {
            SerialExecutor serialExecutor = new SerialExecutor("test", (Object)this);
            AtomicInteger executions = new AtomicInteger();
            int RUNS = 20;
            int WAIT_MILLIS = 1;
            int i = 0;
            while (i < RUNS) {
                serialExecutor.schedule(() -> {
                    try {
                        Thread.sleep(WAIT_MILLIS);
                        executions.incrementAndGet();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
                ++i;
            }
            Job.getJobManager().join((Object)this, null);
            Object[] jobs = Job.getJobManager().find((Object)this);
            Assertions.assertThat((Object[])jobs).isEmpty();
            Assert.assertEquals((String)("failed on run " + run), (long)RUNS, (long)executions.get());
            ++run;
        }
    }
}

