/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.ui.internal.console.ConsoleDocumentAdapter;
import org.junit.Assert;
import org.junit.Test;

public class ConsoleDocumentAdapterTests
extends AbstractDebugTest {
    @Test
    public void testSetText() {
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(true, null);
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(-1);
        docAdapter.setDocument((IDocument)new Document());
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        String text = "123456";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.SET));
        docAdapter.setText("123456");
        ConsoleDocumentAdapterTests.assertContent((IDocumentAdapter)docAdapter, "123456");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, null);
        String[] stringArray = new String[2];
        stringArray[0] = "";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray2[n2];
            docAdapter.setText(s);
            ConsoleDocumentAdapterTests.assertContent((IDocumentAdapter)docAdapter, "");
            ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
            ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, null);
            ++n2;
        }
    }

    @Test
    public void testLineWrap() {
        Random rand = new Random(4L);
        int wrapWidth = 10;
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(10);
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(false, (IDocumentAdapter)docAdapter);
        Assert.assertEquals((String)"Failed to set width.", (long)10L, (long)docAdapter.getWidth());
        docAdapter.setDocument((IDocument)new Document());
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        String initText = "012345";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.SET));
        docAdapter.setText("012345");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "012345");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        String addText = "67";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "89AB";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "AB");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        int offset = 6;
        addText = "---";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "012345---6");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "789AB");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 3, 0, 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 3, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "AB");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "CDEFGHIJabcdefghijKL";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KL");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        String replaceText = "~~~";
        offset = 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, replaceText, replaceText.length(), replaceText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, replaceText.length(), replaceText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "012~~~6789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KL");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 3, 0, 3, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 3, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 3);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0126789ABC");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "DEFGHIJabc");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "defghijKL");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "345";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 2, 3));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KL");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "MNOPQRST";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        Assert.assertEquals((String)"Got wrong line index.", (long)3L, (long)docAdapter.getLineAtOffset(40));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "kl";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 5);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = ">";
        offset = docAdapter.getCharCount() - 2;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 5);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, ">kl");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 1, 0, 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 1, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 5);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "");
        Assert.assertEquals((String)"Got wrong line.", (long)4L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount() - 2));
        Assert.assertEquals((String)"Got wrong line.", (long)4L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount() - 1));
        Assert.assertEquals((String)"Got wrong line.", (long)5L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
        Assert.assertEquals((String)"Get wrong content.", (Object)"\n", (Object)docAdapter.getTextRange(42, 1));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "UVWXYZ.,:;";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UVWXYZ.,:;");
        Assert.assertEquals((String)"Got wrong line.", (long)5L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
        Assert.assertEquals((String)"Get wrong content.", (Object)"l\nU", (Object)docAdapter.getTextRange(41, 3));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(docAdapter.getLineCount() - 1) + 2;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 4, 0, 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 4, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UV.,:;");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        replaceText = "WXYZ.,:;";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, replaceText, 4, replaceText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 4, replaceText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UVWXYZ.,:;");
        Assert.assertEquals((String)"Got wrong line.", (long)5L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getCharCount() - 3;
        replaceText = "~~~";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, replaceText, replaceText.length(), replaceText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, replaceText.length(), replaceText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UVWXYZ.~~~");
        Assert.assertEquals((String)"Got wrong line.", (long)5L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = ",:;";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 7);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "kl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UVWXYZ.,:;");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 6, "~~~");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "mnopqrst";
        offset = 42;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        replaceText = "uvwxyz_-=|";
        offset = docAdapter.getCharCount() - 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, replaceText, 3, replaceText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 3, replaceText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 7);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcdefghij");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "klmnopqrst");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "UVWXYZ.,:;");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 6, "uvwxyz_-=|");
        Assert.assertEquals((String)"Got wrong line.", (long)4L, (long)docAdapter.getLineAtOffset(49));
        Assert.assertEquals((String)"Got wrong line.", (long)4L, (long)docAdapter.getLineAtOffset(50));
        Assert.assertEquals((String)"Got wrong line.", (long)5L, (long)docAdapter.getLineAtOffset(51));
        Assert.assertEquals((String)"Got wrong line.", (long)6L, (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(docAdapter.getLineCount() - 1);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 10, 0, 1, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 10, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        replaceText = "~~~";
        offset = 7;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, replaceText, replaceText.length(), replaceText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, replaceText.length(), replaceText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456~~~");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(4);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", 11, 0, 1, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 11, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 5);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "KLMNOPQRST");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "UVWXYZ.,:;");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        int remove = 3;
        offset = 7;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 4, 4));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 5);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456ABC");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "DEFGHIJabc");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "defghijKLM");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "NOPQRSTUVW");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "XYZ.,:;");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
        docAdapter.removeTextChangeListener((TextChangeListener)eventListener);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
    }

    @Test
    public void testMultilineInserts() {
        Random rand = new Random(4L);
        int wrapWidth = 10;
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(10);
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(false, (IDocumentAdapter)docAdapter);
        Assert.assertEquals((String)"Failed to set width.", (long)10L, (long)docAdapter.getWidth());
        docAdapter.setDocument((IDocument)new Document());
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        String addText = "012345\nABCDEFGHIJa\r\n\nklmnopqrst\r\nuv";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, addText, 0, addText.length(), 0, 5));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "012345");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "a");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 4, "klmnopqrst");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "uv");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 7);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "012345");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "9876543210?\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, addText, 0, addText.length(), 0, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 9);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "9876543210");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "?");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\r\nfoo";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, addText, 0, addText.length(), 1, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 10);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "foo9876543");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "210?");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = ".,:;\r\nbar";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, addText, 0, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 11);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, ".,:;");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "bar");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "foo9876543");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\r\n\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 13);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 10, "uv");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 11, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 12, "");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "BCDEFGHIJKbc\n\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 3));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 16);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 12, "BCDEFGHIJK");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 13, "bc");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 14, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 15, "");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\r\nLMNOPQR\nlmnopqrst";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 18);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 15, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 16, "LMNOPQR");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 17, "lmnopqrst");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "uVW\nvwxy\r\n1357902468";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, docAdapter.getCharCount(), addText, 0, addText.length(), 0, 3));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 21);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 17, "lmnopqrstu");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 18, "VW");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 19, "vwxy");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 20, "1357902468");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        int offset = docAdapter.getOffsetAtLine(17) + 8;
        addText = "\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 21);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 17, "lmnopqrs");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 18, "tuVW");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 19, "vwxy");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(19) + 2;
        addText = "\n[()]\r\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 0, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 23);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 19, "vw");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 20, "[()]");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 21, "xy");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(20);
        addText = "\r\nCDEFGHIJKLcdefghijklMNOPQR\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 0, 4));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 27);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 20, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 21, "CDEFGHIJKL");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 22, "cdefghijkl");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 23, "MNOPQR");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 24, "[()]");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = docAdapter.getOffsetAtLine(21) + 9;
        addText = "\n";
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, 0, addText.length(), 2, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, 0, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 27);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 21, "CDEFGHIJK");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 22, "Lcdefghijk");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 23, "lMNOPQR");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
        docAdapter.removeTextChangeListener((TextChangeListener)eventListener);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
    }

    @Test
    public void testMultilineRemove() {
        Random rand = new Random(4L);
        int wrapWidth = 10;
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(true, null);
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(10);
        Assert.assertEquals((String)"Failed to set width.", (long)10L, (long)docAdapter.getWidth());
        docAdapter.setDocument((IDocument)new Document());
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "0123456789");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "ABCDE");
        int offset = 8;
        int remove = 4;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567CD");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "E");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, 0, "", 0, 0, 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(0, 0, "");
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = 8;
        remove = 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 1, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "0123456789");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "ABCDEFGHIJ");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "abcde");
        offset = 8;
        remove = 14;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 2, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567cd");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "e");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        offset = 10;
        remove = 1;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 1, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567cd");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "01234567\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "ABCDEF");
        offset = 8;
        remove = 1;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234567AB");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "CDEF");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "01234567\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "ABCDEFGHIJ");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "abcdefghij");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "KLMN\r\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "klmno\n");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 5, "");
        offset = 5;
        remove = 36;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 5, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "01234");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "01234567\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "\r\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "\n");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, docAdapter.getLineDelimiter());
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6);
        offset = 10;
        remove = 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, "", remove, 0, 2, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, remove, "");
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
    }

    @Test
    public void testMultilineReplace() {
        Random rand = new Random(4L);
        int wrapWidth = 10;
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(true, null);
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(10);
        Assert.assertEquals((String)"Failed to set width.", (long)10L, (long)docAdapter.getWidth());
        docAdapter.setDocument((IDocument)new Document());
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        docAdapter.setText("0123~~~AB");
        String addText = "\n";
        int offset = 4;
        int length = 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, length, addText.length(), 0, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "AB");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "456789abc\r\n+";
        length = 2;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, length, addText.length(), 1, 2));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 3);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "abc");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "+B");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "<->\nABCDEFGHIJabc\n#";
        length = 12;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, length, addText.length(), 2, 3));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123<->");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abc");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "#B");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "\n>=<";
        offset = 18;
        length = 3;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, null, null, null, null, 1, 1));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "0123<->");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, ">=<");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "#B");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        addText = "*+";
        offset = docAdapter.getCharCount() - 2;
        length = 1;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, length, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 4);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, ">=<");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "*+B");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        docAdapter.setText("");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "0123456789");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "ABCDEFGHIJ");
        docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, "a");
        addText = "$b";
        offset = docAdapter.getCharCount() - 1;
        length = 1;
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGING, offset, addText, length, addText.length(), 0, 0));
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.CHANGED));
        docAdapter.replaceTextRange(offset, length, addText);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 3);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEFGHIJ");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "$b");
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
    }

    @Test
    public void testSetWidth() {
        Random rand = new Random(7L);
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(-1);
        docAdapter.setDocument((IDocument)new Document());
        String line0_0 = "#123456789";
        String line0_1 = "ABCDEF";
        String line0 = "#123456789ABCDEF";
        String line1 = "";
        String line2 = "abcd";
        String text = "#123456789ABCDEF\n\r\nabcd";
        docAdapter.setText("#123456789ABCDEF\n\r\nabcd");
        Assert.assertEquals((String)"Get text range failed.", (Object)"#", (Object)docAdapter.getTextRange(0, 1));
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "#123456789ABCDEF");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcd");
        Assert.assertEquals((String)"Adapter content length wrong.", (long)"#123456789ABCDEF\n\r\nabcd".length(), (long)docAdapter.getCharCount());
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        docAdapter.setWidth(10);
        docAdapter.setWidth(10);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "#123456789");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "ABCDEF");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 3, "abcd");
        Assert.assertEquals((String)"Adapter content length wrong.", (long)"#123456789ABCDEF\n\r\nabcd".length(), (long)docAdapter.getCharCount());
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        docAdapter.setWidth(-1);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "#123456789ABCDEF");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcd");
        Assert.assertEquals((String)"Adapter content length wrong.", (long)"#123456789ABCDEF\n\r\nabcd".length(), (long)docAdapter.getCharCount());
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        docAdapter.setWidth(80);
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 0, "#123456789ABCDEF");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 1, "");
        ConsoleDocumentAdapterTests.assertLine((IDocumentAdapter)docAdapter, 2, "abcd");
        Assert.assertEquals((String)"Adapter content length wrong.", (long)"#123456789ABCDEF\n\r\nabcd".length(), (long)docAdapter.getCharCount());
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        ExpectingTextChangeListener eventListener = new ExpectingTextChangeListener(false, (IDocumentAdapter)docAdapter);
        docAdapter.addTextChangeListener((TextChangeListener)eventListener);
        eventListener.addExpectation(new TextEventExpectation(TextChangeEventType.SET));
        docAdapter.setWidth(1);
        int expectedLines = Math.max("#123456789ABCDEF".length(), 1);
        expectedLines += Math.max("".length(), 1);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, expectedLines += Math.max("abcd".length(), 1));
        ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, rand);
        Assert.assertFalse((String)"Some expected change events were not received.", (boolean)eventListener.hasPendingExpections());
    }

    @Test
    public void testInterfaceContract() {
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(-1);
        docAdapter.setDocument((IDocument)new Document());
        Assert.assertNotNull((String)"Adapter has no legal line delimiter.", (Object)docAdapter.getLineDelimiter());
        int[] nArray = new int[]{-1, 80};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            docAdapter.setWidth(width);
            docAdapter.setText("\r\n\r\n");
            ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, null);
            Assert.assertEquals((String)"Wrong line for offset.", (long)0L, (long)docAdapter.getLineAtOffset(0));
            Assert.assertEquals((String)"Wrong line for offset.", (long)0L, (long)docAdapter.getLineAtOffset(1));
            Assert.assertEquals((String)"Wrong line for offset.", (long)1L, (long)docAdapter.getLineAtOffset(2));
            Assert.assertEquals((String)"Wrong line for offset.", (long)1L, (long)docAdapter.getLineAtOffset(3));
            Assert.assertEquals((String)"Wrong line for offset.", (long)2L, (long)docAdapter.getLineAtOffset(4));
            Assert.assertEquals((String)"Wrong line for offset.", (long)(docAdapter.getLineCount() - 1), (long)docAdapter.getLineAtOffset(docAdapter.getCharCount()));
            docAdapter.setText(null);
            ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
            docAdapter.setText("");
            ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 1);
            docAdapter.setText("a\n");
            ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 2);
            docAdapter.setText("\n\n");
            ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 3);
            docAdapter.setText("\r\ntest\r\n");
            ConsoleDocumentAdapterTests.checkLineMapping((IDocumentAdapter)docAdapter, null);
            Assert.assertEquals((String)"Wrong offset for line.", (long)0L, (long)docAdapter.getOffsetAtLine(0));
            Assert.assertEquals((String)"Wrong offset for line.", (long)2L, (long)docAdapter.getOffsetAtLine(1));
            Assert.assertEquals((String)"Wrong offset for line.", (long)8L, (long)docAdapter.getOffsetAtLine(2));
            docAdapter.setText("");
            Assert.assertEquals((String)"Wrong offset for line.", (long)0L, (long)docAdapter.getOffsetAtLine(0));
            ++n2;
        }
    }

    @Test
    public void testChangeDocument() {
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(-1);
        Document doc1 = new Document();
        Document doc2 = new Document();
        String text1 = "foo";
        String text2 = "bar";
        docAdapter.setDocument((IDocument)doc1);
        docAdapter.setText("foo");
        ConsoleDocumentAdapterTests.assertContent((IDocumentAdapter)docAdapter, "foo");
        String doc1Text = doc1.get();
        docAdapter.setDocument((IDocument)doc2);
        docAdapter.setText("bar");
        ConsoleDocumentAdapterTests.assertContent((IDocumentAdapter)docAdapter, "bar");
        Assert.assertEquals((String)"Document was changed after disconnect.", (Object)doc1Text, (Object)doc1.get());
        docAdapter.setDocument(null);
    }

    @Test
    public void testInvalidInvocations() {
        AtomicInteger expectedErrors = new AtomicInteger(0);
        ILogListener logListener = (status, plugin) -> {
            if (status.matches(4)) {
                expectedErrors.decrementAndGet();
            }
        };
        try {
            Platform.addLogListener((ILogListener)logListener);
            ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(-1);
            docAdapter.setDocument(null);
            docAdapter.setDocument((IDocument)new Document());
            try {
                docAdapter.addTextChangeListener(null);
                Assert.fail((String)"Exception not thrown.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                docAdapter.removeTextChangeListener(null);
                Assert.fail((String)"Exception not thrown.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int[] nArray = new int[]{-1, -2, 80};
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int width = nArray[n2];
                docAdapter.setWidth(width);
                if (width != -2) {
                    docAdapter.setText("?");
                } else {
                    docAdapter.replaceTextRange(0, docAdapter.getCharCount(), "?");
                }
                expectedErrors.set(3);
                docAdapter.getLine(Integer.MIN_VALUE);
                docAdapter.getLine(-1);
                docAdapter.getLine(Integer.MAX_VALUE);
                Assert.assertEquals((String)("Too much success with width: " + width), (long)0L, (long)expectedErrors.get());
                expectedErrors.set(4);
                docAdapter.getLineAtOffset(Integer.MIN_VALUE);
                docAdapter.getLineAtOffset(-1);
                docAdapter.getLineAtOffset(1);
                docAdapter.getLineAtOffset(2);
                docAdapter.getLineAtOffset(Integer.MAX_VALUE);
                Assert.assertEquals((String)("Too much success with width: " + width), (long)0L, (long)expectedErrors.get());
                expectedErrors.set(4);
                docAdapter.getOffsetAtLine(Integer.MIN_VALUE);
                docAdapter.getOffsetAtLine(-1);
                docAdapter.getOffsetAtLine(1);
                docAdapter.getOffsetAtLine(Integer.MAX_VALUE);
                Assert.assertEquals((String)("Too much success with width: " + width), (long)0L, (long)expectedErrors.get());
                expectedErrors.set(6);
                docAdapter.getTextRange(-1, 1);
                docAdapter.getTextRange(0, -1);
                docAdapter.getTextRange(1, -1);
                docAdapter.getTextRange(-1, 2);
                docAdapter.getTextRange(0, 2);
                docAdapter.getTextRange(0, 3);
                Assert.assertEquals((String)("Too much success with width: " + width), (long)0L, (long)expectedErrors.get());
                expectedErrors.set(10);
                docAdapter.replaceTextRange(2, 0, "");
                docAdapter.replaceTextRange(-1, 0, "");
                docAdapter.replaceTextRange(0, 2, "");
                docAdapter.replaceTextRange(0, -1, "");
                docAdapter.replaceTextRange(1, 1, "");
                docAdapter.replaceTextRange(0, 2, "foo");
                docAdapter.replaceTextRange(0, -1, "foo");
                docAdapter.replaceTextRange(1, 1, "foo");
                docAdapter.replaceTextRange(1, -1, "foo");
                docAdapter.replaceTextRange(2, 0, "foo");
                Assert.assertEquals((String)("Too much success with width: " + width), (long)0L, (long)expectedErrors.get());
                ++n2;
            }
        }
        finally {
            Platform.removeLogListener((ILogListener)logListener);
        }
    }

    @Test
    public void testManyLines() {
        ConsoleDocumentAdapter docAdapter = new ConsoleDocumentAdapter(80);
        docAdapter.setDocument((IDocument)new Document());
        String lineDelimiter = docAdapter.getLineDelimiter();
        int n = 6000;
        int i = 0;
        while (i < 6000) {
            docAdapter.replaceTextRange(docAdapter.getCharCount(), 0, lineDelimiter);
            ++i;
        }
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6001);
        docAdapter.setWidth(-1);
        ConsoleDocumentAdapterTests.assertNumberOfLines((IDocumentAdapter)docAdapter, 6001);
        ConsoleDocumentAdapterTests.clearDocument((IDocumentAdapter)docAdapter);
    }

    private static void assertContent(IDocumentAdapter docAdapter, String content) {
        Assert.assertEquals((String)"Adapter returned wrong content.", (Object)content, (Object)docAdapter.getTextRange(0, docAdapter.getCharCount()));
    }

    private static void assertNumberOfLines(IDocumentAdapter docAdapter, int expectedLines) {
        Assert.assertEquals((String)"Adapter has wrong line count.", (long)expectedLines, (long)docAdapter.getLineCount());
    }

    private static void assertLine(IDocumentAdapter docAdapter, int lineIndex, String expectedContent) {
        Assert.assertEquals((String)("Adapter returned wrong content for line " + lineIndex + "."), (Object)expectedContent, (Object)docAdapter.getLine(lineIndex));
    }

    private static void checkLineMapping(IDocumentAdapter docAdapter, Random rand) {
        int n = docAdapter.getLineCount();
        ArrayList<Integer> lines = new ArrayList<Integer>(n);
        int i = 0;
        while (i < n) {
            lines.add(i);
            ++i;
        }
        if (rand != null) {
            Collections.shuffle(lines, rand);
        }
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int lineLength;
            int lineIndex = (Integer)iterator.next();
            int offset = docAdapter.getOffsetAtLine(lineIndex);
            if (rand != null && (lineLength = docAdapter.getLine(lineIndex).length()) > 0) {
                offset += rand.nextInt(lineLength);
            }
            int testLineIndex = docAdapter.getLineAtOffset(offset);
            Assert.assertEquals((String)("Got wrong line with offset " + offset + "."), (long)lineIndex, (long)testLineIndex);
        }
    }

    private static void clearDocument(IDocumentAdapter docAdapter) {
        docAdapter.setText("");
        Assert.assertEquals((String)"Document not cleared.", (long)0L, (long)docAdapter.getCharCount());
        ConsoleDocumentAdapterTests.assertNumberOfLines(docAdapter, 1);
        ConsoleDocumentAdapterTests.assertLine(docAdapter, 0, "");
    }

    private static class ExpectingTextChangeListener
    implements TextChangeListener {
        final Queue<TextEventExpectation> expectations = new LinkedList<TextEventExpectation>();
        final boolean allowUnexpectedEvents;
        final IDocumentAdapter docAdapter;
        TextChangingEvent lastEvent;
        int eventLineBeforeChange = -1;
        int linesBeforeReplace = -1;
        int lengthBeforeReplace = -1;

        public ExpectingTextChangeListener(boolean allowUnexpectedEvents, IDocumentAdapter docAdapter) {
            this.allowUnexpectedEvents = allowUnexpectedEvents;
            this.docAdapter = docAdapter;
        }

        public void addExpectation(TextEventExpectation expectation) {
            this.expectations.add(expectation);
        }

        public void textChanging(TextChangingEvent event) {
            TextEventExpectation expectation = this.checkCommon(TextChangeEventType.CHANGING);
            if (expectation != null) {
                if (expectation.start != null) {
                    Assert.assertEquals((String)"event.start", (long)expectation.start.intValue(), (long)event.start);
                }
                if (expectation.newText != null) {
                    Assert.assertEquals((String)"event.newText", (Object)expectation.newText, (Object)event.newText);
                }
                if (expectation.replaceCharCount != null) {
                    Assert.assertEquals((String)"event.replaceCharCount", (long)expectation.replaceCharCount.intValue(), (long)event.replaceCharCount);
                }
                if (expectation.newCharCount != null) {
                    Assert.assertEquals((String)"event.newCharCount", (long)expectation.newCharCount.intValue(), (long)event.newCharCount);
                }
                if (expectation.replaceLineCount != null) {
                    Assert.assertEquals((String)"event.replaceLineCount", (long)expectation.replaceLineCount.intValue(), (long)event.replaceLineCount);
                }
                if (expectation.newLineCount != null) {
                    Assert.assertEquals((String)"event.newLineCount", (long)expectation.newLineCount.intValue(), (long)event.newLineCount);
                }
            }
            if (!this.allowUnexpectedEvents && this.docAdapter != null) {
                this.lastEvent = event;
                this.eventLineBeforeChange = this.docAdapter.getLineAtOffset(event.start);
                this.linesBeforeReplace = this.docAdapter.getLineCount();
                this.lengthBeforeReplace = this.docAdapter.getCharCount();
                int charactersBehindEventStart = this.docAdapter.getCharCount() - event.start;
                Assert.assertTrue((String)"Tried to remove more characters than available.", (event.replaceCharCount <= charactersBehindEventStart ? 1 : 0) != 0);
                int linesBehindEvent = this.docAdapter.getLineCount() - this.docAdapter.getLineAtOffset(event.start);
                Assert.assertTrue((String)"Tried to remove more lines than available.", (event.replaceLineCount <= linesBehindEvent ? 1 : 0) != 0);
            }
        }

        public void textChanged(TextChangedEvent event) {
            this.checkCommon(TextChangeEventType.CHANGED);
            if (this.docAdapter != null && this.lastEvent != null) {
                int lastEventOffset = this.lastEvent.start;
                int lastEventLineIndex = this.docAdapter.getLineAtOffset(lastEventOffset);
                Assert.assertTrue((String)("Line of event offset " + lastEventOffset + " has moved up."), (this.eventLineBeforeChange <= lastEventLineIndex ? 1 : 0) != 0);
                int predictedDocLength = this.lengthBeforeReplace - this.lastEvent.replaceCharCount + this.lastEvent.newCharCount;
                Assert.assertEquals((String)"New widget length not as announce by changing event.", (long)predictedDocLength, (long)this.docAdapter.getCharCount());
                int predictedDocLines = this.linesBeforeReplace - this.lastEvent.replaceLineCount + this.lastEvent.newLineCount;
                Assert.assertEquals((String)"New widget line number not as announce by changing event.", (long)predictedDocLines, (long)this.docAdapter.getLineCount());
                Assert.assertEquals((String)"Inserted text not found in document.", (Object)this.lastEvent.newText, (Object)this.docAdapter.getTextRange(this.lastEvent.start, this.lastEvent.newText.length()));
            }
        }

        public void textSet(TextChangedEvent event) {
            this.checkCommon(TextChangeEventType.SET);
        }

        public boolean hasPendingExpections() {
            return !this.expectations.isEmpty();
        }

        private TextEventExpectation checkCommon(TextChangeEventType eventType) {
            TextEventExpectation expectation = this.expectations.poll();
            if (expectation == null && this.allowUnexpectedEvents) {
                return null;
            }
            Assert.assertNotNull((String)"Unexpected event.", (Object)expectation);
            if (expectation.type != eventType && this.allowUnexpectedEvents) {
                return null;
            }
            Assert.assertEquals((String)"Wrong event type.", (Object)((Object)expectation.type), (Object)((Object)eventType));
            return expectation;
        }
    }

    public static enum TextChangeEventType {
        CHANGING,
        CHANGED,
        SET;

    }

    private static class TextEventExpectation {
        public final TextChangeEventType type;
        public final Integer start;
        public final String newText;
        public final Integer replaceCharCount;
        public final Integer newCharCount;
        public final Integer replaceLineCount;
        public final Integer newLineCount;

        public TextEventExpectation(TextChangeEventType type) {
            this(type, null, null, null, null, null, null);
        }

        public TextEventExpectation(TextChangeEventType type, Integer start, String newText, Integer replaceCharCount, Integer newCharCount, Integer replaceLineCount, Integer newLineCount) {
            this.type = type;
            this.start = start;
            this.newText = newText;
            this.replaceCharCount = replaceCharCount;
            this.newCharCount = newCharCount;
            this.replaceLineCount = replaceLineCount;
            this.newLineCount = newLineCount;
        }
    }
}

