/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsoleManagerTests
extends AbstractDebugTest {
    private ExecutorService executorService;
    private IConsoleManager manager;
    private int count;
    private CountDownLatch latch;
    private ConsoleMock[] consoles;
    ConsoleMock firstConsole;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Assert.assertNotNull((String)("Must run in UI thread, but was in: " + Thread.currentThread().getName()), (Object)Display.getCurrent());
        this.count = 20;
        this.latch = new CountDownLatch(this.count);
        this.executorService = Executors.newFixedThreadPool(this.count);
        this.manager = ConsolePlugin.getDefault().getConsoleManager();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TestUtil.processUIEvents(100L);
        this.consoles = new ConsoleMock[this.count];
        int i = 0;
        while (i < this.count) {
            ConsoleMock console;
            this.consoles[i] = console = new ConsoleMock(i + 1);
            ++i;
        }
        this.manager.addConsoles((IConsole[])this.consoles);
        IViewPart consoleView = activePage.showView("org.eclipse.ui.console.ConsoleView");
        activePage.activate((IWorkbenchPart)consoleView);
        TestUtil.processUIEvents(100L);
        this.firstConsole = new ConsoleMock(0);
        this.manager.addConsoles((IConsole[])new ConsoleMock[]{this.firstConsole});
        this.manager.showConsoleView((IConsole)this.firstConsole);
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        TestUtil.processUIEvents(100L);
        ConsoleMock.allShownConsoles.set(0);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
        this.manager.removeConsoles((IConsole[])this.consoles);
        this.manager.removeConsoles((IConsole[])new ConsoleMock[]{this.firstConsole});
        TestUtil.processUIEvents(100L);
        super.tearDown();
    }

    @Test
    public void testShowAllConsoles() throws Exception {
        ConsoleMock[] consoleMockArray = this.consoles;
        int n = this.consoles.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleMock console = consoleMockArray[n2];
            this.showConsole(console);
            ++n2;
        }
        System.out.println("All tasks scheduled, processing UI events now...");
        TestUtil.processUIEvents(1000L);
        System.out.println("Waiting on jobs now...");
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        System.out.println("Done with jobs, processing UI events again...");
        TestUtil.processUIEvents(3000L);
        this.executorService.shutdown();
        System.out.println("Waiting on execution service to finish...");
        boolean OK = this.waitForExecutorService();
        if (!OK) {
            System.out.println("Timed out...");
            TestUtil.processUIEvents(10000L);
            Assert.assertTrue((String)"Timeout occurred while waiting on console to be shown", (boolean)this.waitForExecutorService());
        } else {
            System.out.println("Done waiting on execution service to finish");
        }
        int shown = ConsoleMock.allShownConsoles.intValue();
        Assert.assertEquals((String)("Only " + shown + " consoles were shown from " + this.count), (long)this.count, (long)shown);
    }

    private boolean waitForExecutorService() throws Exception {
        int i = 0;
        while (i < 60) {
            if (this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                return true;
            }
            TestUtil.processUIEvents(100L);
            ++i;
        }
        return false;
    }

    private void showConsole(ConsoleMock console) {
        this.executorService.execute(() -> {
            this.latch.countDown();
            try {
                this.latch.await(1L, TimeUnit.MINUTES);
                System.out.println("Requesting to show: " + String.valueOf(console));
                this.manager.showConsoleView((IConsole)console);
                TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.interrupted();
            }
        });
    }

    static final class ConsoleMock
    implements IConsole {
        MessagePage page;
        final AtomicInteger showCalled;
        final int number;
        static final AtomicInteger allShownConsoles = new AtomicInteger();

        public ConsoleMock(int number) {
            this.number = number;
            this.showCalled = new AtomicInteger();
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
        }

        public String getType() {
            return null;
        }

        public String getName() {
            return this.toString();
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
        }

        public IPageBookViewPage createPage(IConsoleView view) {
            this.page = new MessagePage(){

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    this.getControl().addListener(22, event -> {
                        int count = showCalled.incrementAndGet();
                        if (count == 1) {
                            count = allShownConsoles.incrementAndGet();
                            System.out.println("Shown: " + String.valueOf(this) + ", overall: " + count);
                        }
                    });
                }
            };
            this.page.setMessage(this.toString());
            return this.page;
        }

        public String toString() {
            return "mock #" + this.number;
        }
    }
}

