/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.commands.Command;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.junit.Assert;
import org.junit.Test;

public class ConsoleTests
extends AbstractDebugTest {
    @Test
    public void testConsoleOutputStreamEncoding() throws IOException {
        String testString = "abc\u00e4\u00f6\u00fcdef";
        byte[] testStringBuffer = testString.getBytes(StandardCharsets.UTF_8);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])testStringBuffer).as("Test string \"" + testString + "\" should consist of 12 UTF-8 bytes", new Object[0])).hasSize(12);
        MessageConsole console = new MessageConsole("Test Console", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        Assert.assertEquals((String)"Document should be empty", (Object)"", (Object)document.get());
        Throwable throwable = null;
        Object var6_7 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write(testStringBuffer, 0, 6);
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
            Assert.assertEquals((String)"First 4 chars should be written", (Object)testString.substring(0, 4), (Object)document.get());
            outStream.write(testStringBuffer, 6, 6);
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
            Assert.assertEquals((String)"whole test string should be written", (Object)testString, (Object)document.get());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        Assert.assertEquals((String)"closing the stream should not alter the document", (Object)testString, (Object)document.get());
    }

    @Test
    public void testConsoleOutputStreamLastR() throws IOException {
        String testString = "a\r";
        byte[] testStringBuffer = testString.getBytes(StandardCharsets.UTF_8);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])testStringBuffer).as("Test string \"" + testString + "\" should consist of 2 UTF-8 bytes", new Object[0])).hasSize(2);
        MessageConsole console = new MessageConsole("Test Console 2", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        Assert.assertEquals((String)"Document should be empty", (Object)"", (Object)document.get());
        Throwable throwable = null;
        Object var6_7 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write(testStringBuffer);
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
            Assert.assertEquals((String)"First char should be written", (Object)testString.substring(0, 1), (Object)document.get());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 200L, 5000L);
        Assert.assertEquals((String)"closing the stream should write the pending \\r", (Object)testString, (Object)document.get());
    }

    @Test
    public void testConsoleOutputStreamDocumentClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 3", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("write1");
            document.getDocumentPartitioner().disconnect();
            try {
                outStream.write("write2");
                Assert.fail((String)"IOException with message \"Document is closed\" expected");
            }
            catch (IOException ioe) {
                Assert.assertEquals((Object)"Document is closed", (Object)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testConsoleOutputStreamClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 4", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("test1".getBytes(StandardCharsets.UTF_8));
            outStream.close();
            try {
                outStream.write("test2".getBytes(StandardCharsets.UTF_8));
                Assert.fail((String)"IOException with message \"Output Stream is closed\" expected");
            }
            catch (IOException ioe) {
                Assert.assertEquals((Object)"Output Stream is closed", (Object)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testConsoleOutputStreamDocumentStreamClosed() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 5", "org.eclipse.ui.MessageConsole", null, StandardCharsets.UTF_8.name(), true);
        IDocument document = console.getDocument();
        Throwable throwable = null;
        Object var4_5 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.write("write1");
            document.getDocumentPartitioner().disconnect();
            try {
                outStream.write("write2");
                Assert.fail((String)"IOException with message \"Document is closed\" expected");
            }
            catch (IOException ioe) {
                Assert.assertEquals((Object)"Document is closed", (Object)ioe.getMessage());
            }
            try {
                outStream.write("write3");
                Assert.fail((String)"IOException with message \"Output Stream is closed\" expected");
            }
            catch (IOException ioe) {
                Assert.assertEquals((Object)"Output Stream is closed", (Object)ioe.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSetNullEncoding() throws IOException {
        MessageConsole console = new MessageConsole("Test Console 6", null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream outStream = console.newOutputStream();){
            outStream.setEncoding(null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFindCommandsAreEnabledOnConsoleOpen() throws Exception {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart consoleView = activePage.showView("org.eclipse.ui.console.ConsoleView");
        IOConsole console = new IOConsole("Test Console 7", "org.eclipse.ui.MessageConsole", null, true);
        console.getDocument().set("some text");
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = new IConsole[]{console};
        try {
            consoleManager.addConsoles(consoles);
            consoleManager.showConsoleView((IConsole)console);
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 100L, 3000L);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command commandFindReplace = commandService.getCommand("org.eclipse.ui.edit.findReplace");
            Assert.assertTrue((String)"expected FindReplace command to be enabled after opening console", (boolean)commandFindReplace.isEnabled());
            Command commandFindNext = commandService.getCommand("org.eclipse.ui.edit.findNext");
            Assert.assertTrue((String)"expected FindNext command to be enabled after opening console", (boolean)commandFindNext.isEnabled());
            Command commandFindPrevious = commandService.getCommand("org.eclipse.ui.edit.findPrevious");
            Assert.assertTrue((String)"expected FindPrevious command to be enabled after opening console", (boolean)commandFindPrevious.isEnabled());
        }
        finally {
            consoleManager.removeConsoles(consoles);
            activePage.hideView(consoleView);
        }
    }

    @Test
    public void testIOConsoleAvailable() throws Exception {
        IOConsoleInputStream consoleInput;
        IOConsole console = new IOConsole("", null);
        Throwable throwable = null;
        Object var3_6 = null;
        try {
            consoleInput = console.getInputStream();
            try {
                consoleInput.available();
                consoleInput.available();
            }
            finally {
                if (consoleInput != null) {
                    consoleInput.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        console = new IOConsole("", null);
        throwable = null;
        var3_6 = null;
        try {
            consoleInput = console.getInputStream();
            try {
                consoleInput.available();
                new Thread(() -> ConsoleTests.lambda$0((InputStream)consoleInput)).start();
                Assert.assertEquals((String)"read() did not signal EOF.", (long)-1L, (long)consoleInput.read());
            }
            finally {
                if (consoleInput != null) {
                    consoleInput.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        console = new IOConsole("", null);
        throwable = null;
        var3_6 = null;
        try {
            consoleInput = console.getInputStream();
            try {
                consoleInput.close();
                consoleInput.available();
                consoleInput.available();
            }
            finally {
                if (consoleInput != null) {
                    consoleInput.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static /* synthetic */ void lambda$0(InputStream inputStream) {
        try {
            Thread.sleep(100L);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

