/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class FileLinkTests
extends AbstractDebugTest {
    private IProject testProject;
    private IFile testFile;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.testProject = workspace.getRoot().getProject("FileLinkTest-" + String.valueOf(UUID.randomUUID()));
        this.testProject.create(null);
        this.testProject.open(null);
        this.testFile = this.testProject.getFile("filelinktest.txt");
        this.setTestContent("Test file\nSecond line");
    }

    @Override
    public void tearDown() throws Exception {
        if (this.testProject.exists()) {
            this.testProject.delete(true, true, null);
        }
        super.tearDown();
    }

    private void setTestContent(String fileContent) throws UnsupportedEncodingException, CoreException {
        ByteArrayInputStream data = new ByteArrayInputStream(fileContent.getBytes(this.testFile.getCharset()));
        if (this.testFile.exists()) {
            this.testFile.setContents((InputStream)data, 1, null);
        } else {
            this.testFile.create((InputStream)data, 1, null);
        }
    }

    @Test
    public void testFileLink() throws Exception {
        FileLink link = new FileLink(this.testFile, null, -1, -1, -1);
        link.linkActivated();
        Assert.assertEquals((Object)this.testFile.getName(), (Object)this.getActiveEditorFilename());
    }

    @Test
    public void testFileLinkWithOffset() throws Exception {
        FileLink link = new FileLink(this.testFile, null, 4, 0, -1);
        link.linkActivated();
        Assert.assertEquals((Object)this.testFile.getName(), (Object)this.getActiveEditorFilename());
        ITextSelection selection = this.getCurrentTextSelection();
        Assert.assertNotNull((String)"No selection.", (Object)selection);
        Assert.assertEquals((long)4L, (long)selection.getOffset());
        Assert.assertEquals((long)0L, (long)selection.getLength());
        Assert.assertEquals((long)0L, (long)selection.getStartLine());
        Assert.assertEquals((long)0L, (long)selection.getEndLine());
    }

    @Test
    public void testFileLinkWithSelection() throws Exception {
        FileLink link = new FileLink(this.testFile, null, 7, 5, -1);
        link.linkActivated();
        Assert.assertEquals((Object)this.testFile.getName(), (Object)this.getActiveEditorFilename());
        ITextSelection selection = this.getCurrentTextSelection();
        Assert.assertNotNull((String)"No selection.", (Object)selection);
        Assert.assertEquals((long)7L, (long)selection.getOffset());
        Assert.assertEquals((long)5L, (long)selection.getLength());
        Assert.assertEquals((long)0L, (long)selection.getStartLine());
        Assert.assertEquals((long)1L, (long)selection.getEndLine());
        link = new FileLink(this.testFile, null, 7, 5, 1);
        link.linkActivated();
        Assert.assertEquals((Object)this.testFile.getName(), (Object)this.getActiveEditorFilename());
        selection = this.getCurrentTextSelection();
        Assert.assertNotNull((String)"No selection.", (Object)selection);
        Assert.assertEquals((long)7L, (long)selection.getOffset());
        Assert.assertEquals((long)5L, (long)selection.getLength());
        Assert.assertEquals((long)0L, (long)selection.getStartLine());
        Assert.assertEquals((long)1L, (long)selection.getEndLine());
    }

    @Test
    public void testFileLinkWithLine() throws Exception {
        FileLink link = new FileLink(this.testFile, null, -1, -1, 2);
        link.linkActivated();
        Assert.assertEquals((Object)this.testFile.getName(), (Object)this.getActiveEditorFilename());
        ITextSelection selection = this.getCurrentTextSelection();
        Assert.assertNotNull((String)"No selection.", (Object)selection);
        Assert.assertEquals((long)10L, (long)selection.getOffset());
        Assert.assertEquals((long)11L, (long)selection.getLength());
        Assert.assertEquals((long)1L, (long)selection.getStartLine());
        Assert.assertEquals((long)1L, (long)selection.getEndLine());
    }

    private String getActiveEditorFilename() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = window.getActivePage().getActiveEditor();
        return editor != null ? editor.getEditorInput().getName() : null;
    }

    private ITextSelection getCurrentTextSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }
}

