/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.junit.Assert;

public final class IOConsoleTestUtil {
    private final IOConsole console;
    private final IDocument doc;
    private final StyledText textPanel;
    private final IConsoleDocumentPartitioner partitioner;
    private final List<String> validPartionTypes;
    private final String name;
    private IOConsoleOutputStream defaultOut = null;
    private boolean ignoreFixedConsole = false;

    public IOConsoleTestUtil(IOConsole console, StyledText textPanel, String name) {
        this.console = console;
        Assert.assertNotNull((Object)this.console);
        this.doc = console.getDocument();
        Assert.assertNotNull((Object)this.doc);
        Class<IConsoleDocumentPartitioner> expectedInterface = IConsoleDocumentPartitioner.class;
        Assert.assertTrue((String)("Expected partitioner implements " + expectedInterface.getName() + ". Found: " + String.valueOf(this.doc.getDocumentPartitioner().getClass())), (boolean)expectedInterface.isAssignableFrom(this.doc.getDocumentPartitioner().getClass()));
        this.partitioner = (IConsoleDocumentPartitioner)this.doc.getDocumentPartitioner();
        this.validPartionTypes = Arrays.asList(this.partitioner.getLegalContentTypes());
        this.textPanel = textPanel;
        this.name = name;
    }

    public IOConsoleTestUtil clear() throws Exception {
        this.console.clearConsole();
        this.flush();
        Assert.assertEquals((String)"Console is not cleared.", (long)0L, (long)this.doc.getLength());
        return this;
    }

    public IOConsoleTestUtil writeFast(String s) throws IOException {
        return this.writeFast(s, this.getDefaultOutputStream());
    }

    public IOConsoleTestUtil write(String s) throws Exception {
        return this.write(s, this.getDefaultOutputStream());
    }

    public IOConsoleTestUtil writeAndVerify(String s) throws Exception {
        return this.writeAndVerify(s, this.getDefaultOutputStream());
    }

    public IOConsoleTestUtil writeFast(String s, IOConsoleOutputStream out) throws IOException {
        out.write(s);
        return this;
    }

    public IOConsoleTestUtil write(String s, IOConsoleOutputStream out) throws Exception {
        this.writeFast(s, out);
        this.flush();
        return this;
    }

    public IOConsoleTestUtil writeAndVerify(String s, IOConsoleOutputStream out) throws Exception {
        int oldLength = this.doc.getLength();
        this.write(s, out);
        Assert.assertEquals((String)"Console content length not as expected.", (long)(oldLength + s.length()), (long)this.doc.getLength());
        this.verifyContentByOffset(s, oldLength);
        this.verifyOutputPartitions(oldLength, s.length());
        return this;
    }

    public IOConsoleTestUtil insert(String content) {
        int oldCaretOffset = this.getCaretOffset();
        int oldSelectionLength = this.textPanel.getSelectionCount();
        Event e = new Event();
        e.start = oldCaretOffset - oldSelectionLength;
        e.end = oldCaretOffset;
        e.text = content;
        e.doit = true;
        this.textPanel.notifyListeners(25, e);
        if (e.doit) {
            this.textPanel.replaceTextRange(e.start, e.end - e.start, e.text);
            this.setCaretOffset(e.start + content.length());
        }
        TestUtil.waitForJobs(this.name, "CONSOLE_JOB_FAMILY", 0L, 1000L);
        return this;
    }

    public IOConsoleTestUtil insertAndVerify(String content) {
        int oldLength = this.doc.getLength();
        int oldSelectionLength = this.textPanel.getSelectionCount();
        int oldOffset = this.getCaretOffset() - oldSelectionLength;
        this.insert(content);
        Assert.assertEquals((String)"Console content length not as expected.", (long)(oldLength + content.length() - oldSelectionLength), (long)this.doc.getLength());
        Assert.assertEquals((String)"Caret not at expected position.", (long)(oldOffset + content.length()), (long)this.getCaretOffset());
        this.verifyContentByOffset(content, oldOffset);
        this.verifyInputPartitions(oldOffset, content.length());
        return this;
    }

    public IOConsoleTestUtil insertTyping(String content) {
        char[] cArray = content.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Event e = new Event();
            e.character = c;
            this.textPanel.notifyListeners(1, e);
            this.textPanel.notifyListeners(2, e);
            ++n2;
        }
        TestUtil.waitForJobs(this.name, "CONSOLE_JOB_FAMILY", 0L, 1000L);
        return this;
    }

    public IOConsoleTestUtil insertTypingAndVerify(String content) {
        int oldLength = this.doc.getLength();
        int oldSelectionLength = this.textPanel.getSelectionCount();
        int oldOffset = this.getCaretOffset() - oldSelectionLength;
        this.insertTyping(content);
        Assert.assertEquals((String)"Console content length not as expected.", (long)(oldLength + content.length() - oldSelectionLength), (long)this.doc.getLength());
        Assert.assertEquals((String)"Caret not at expected position.", (long)(oldOffset + content.length()), (long)this.getCaretOffset());
        this.verifyContentByOffset(content, oldOffset);
        this.verifyInputPartitions(oldOffset, content.length());
        return this;
    }

    public IOConsoleTestUtil backspace() {
        return this.backspace(1);
    }

    public IOConsoleTestUtil backspace(int repeat) {
        int i = 0;
        while (i < repeat) {
            if (this.ignoreFixedConsole) {
                Event e = new Event();
                e.doit = true;
                e.text = "";
                IRegion selection = this.getSelection();
                if (selection.getLength() == 0) {
                    int caretOffset = this.getCaretOffset();
                    e.start = caretOffset - 1;
                    e.end = caretOffset;
                    if (caretOffset <= 0) {
                        e.doit = false;
                    }
                } else {
                    e.start = selection.getOffset();
                    e.end = selection.getOffset() + selection.getLength();
                }
                if (e.doit) {
                    this.textPanel.notifyListeners(25, e);
                }
                if (e.doit) {
                    this.textPanel.replaceTextRange(e.start, e.end - e.start, e.text);
                    this.setCaretOffset(e.start);
                }
            } else {
                this.textPanel.invokeAction(8);
            }
            ++i;
        }
        return this;
    }

    public IOConsoleTestUtil enter() {
        this.insertTyping("\n");
        return this;
    }

    public int getCaretOffset() {
        return this.textPanel.getCaretOffset();
    }

    public IOConsoleTestUtil setCaretOffset(int offset) {
        this.textPanel.setCaretOffset(offset);
        return this;
    }

    public IOConsoleTestUtil setCaretLineRelative(int offset) {
        this.moveCaretToLineStart().moveCaret(offset);
        return this;
    }

    public IOConsoleTestUtil moveCaret(int amount) {
        this.setCaretOffset(this.getCaretOffset() + amount);
        return this;
    }

    public IOConsoleTestUtil moveCaretToStart() {
        this.textPanel.invokeAction(17039367);
        return this;
    }

    public IOConsoleTestUtil moveCaretToEnd() {
        this.textPanel.invokeAction(17039368);
        return this;
    }

    public IOConsoleTestUtil moveCaretToLineStart() {
        if (this.ignoreFixedConsole) {
            try {
                int currentOffset = this.getCaretOffset();
                int docLineStart = this.getDocument().getLineInformationOfOffset(currentOffset).getOffset();
                this.setCaretOffset(docLineStart);
            }
            catch (BadLocationException e) {
                TestUtil.log(4, this.name, "Failed to set caret to line start in wrapped line mode.", e);
            }
        } else {
            this.textPanel.invokeAction(0x1000007);
        }
        return this;
    }

    public IOConsoleTestUtil moveCaretToLineEnd() {
        if (this.ignoreFixedConsole) {
            try {
                int currentOffset = this.getCaretOffset();
                IRegion docLine = this.getDocument().getLineInformationOfOffset(currentOffset);
                this.setCaretOffset(docLine.getOffset() + docLine.getLength());
            }
            catch (BadLocationException e) {
                TestUtil.log(4, this.name, "Failed to set caret to line end in wrapped line mode.", e);
            }
        } else {
            this.textPanel.invokeAction(0x1000008);
        }
        return this;
    }

    public IRegion getSelection() {
        Point selection = this.textPanel.getSelection();
        return new Region(selection.x, selection.y - selection.x);
    }

    public IOConsoleTestUtil select(int offset, int length) {
        int o = offset < 0 ? this.doc.getLength() + offset : offset;
        this.setCaretOffset(o + length);
        this.textPanel.setSelectionRange(o, length);
        return this;
    }

    public IOConsoleTestUtil selectAll() {
        this.textPanel.selectAll();
        return this;
    }

    public IOConsoleTestUtil verifyContent(String expectedContent) {
        this.verifyContentByOffset(expectedContent, 0);
        Assert.assertEquals((String)"More or less content in console as expected.", (long)expectedContent.length(), (long)this.doc.getLength());
        return this;
    }

    public IOConsoleTestUtil verifyContentByLine(String expectedContent, int lineNum) {
        int l = lineNum < 0 ? this.doc.getNumberOfLines() + lineNum : lineNum;
        try {
            IRegion line = this.doc.getLineInformation(l);
            this.verifyContentByOffset(expectedContent, line.getOffset());
            Assert.assertEquals((String)("Line " + l + " has wrong length."), (long)expectedContent.length(), (long)line.getLength());
        }
        catch (BadLocationException e) {
            Assert.fail((String)("Expected line " + lineNum + " not found in console document. Bad location!"));
        }
        return this;
    }

    public IOConsoleTestUtil verifyContentByOffset(String expectedContent, int offset) {
        try {
            int o = offset < 0 ? this.doc.getLength() + offset : offset;
            int len = Math.min(this.doc.getLength() - o, expectedContent.length());
            Assert.assertEquals((String)"Expected string not found in console document.", (Object)expectedContent, (Object)this.doc.get(o, len));
        }
        catch (BadLocationException ex) {
            Assert.fail((String)("Expected string '" + expectedContent + "' not found in console document. Bad location!"));
        }
        return this;
    }

    public IOConsoleTestUtil verifyOutputPartitions(int offset, int length) {
        return this.verifyPartitions(offset, length, IOConsoleTestUtil.outputPartitionType(), false, false, 0);
    }

    public IOConsoleTestUtil verifyInputPartitions(int offset, int length) {
        return this.verifyPartitions(offset, length, IOConsoleTestUtil.inputPartitionType(), false, false, 0);
    }

    public IOConsoleTestUtil verifyPartitions() {
        return this.verifyPartitions(0);
    }

    public IOConsoleTestUtil verifyPartitions(int minPartitionNumber) {
        return this.verifyPartitions(0, this.doc.getLength(), null, true, false, minPartitionNumber);
    }

    public IOConsoleTestUtil verifyPartitions(int offset, int length, String expectedType, boolean allowMixedTypes, boolean allowGaps, int minPartitionNumber) {
        Object partition;
        Object[] partitions = this.getPartitioner().computePartitioning(offset, length);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])partitions).as("number of partitions", new Object[0])).hasSizeGreaterThanOrEqualTo(minPartitionNumber);
        int lastEnd = -1;
        Object lastPartition = null;
        String partitionType = expectedType;
        Object[] objectArray = partitions;
        int n = partitions.length;
        int n2 = 0;
        while (n2 < n) {
            partition = objectArray[n2];
            Assert.assertNotSame((String)"Got same partition twice.", lastPartition, (Object)partition);
            Assert.assertTrue((String)"Partition overlapping. (or not sorted as expected)", (partition.getOffset() >= lastEnd ? 1 : 0) != 0);
            if (!allowGaps && lastEnd != -1) {
                Assert.assertTrue((String)"Partitioning gap.", (partition.getOffset() == lastEnd ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"Not a valid partition type.", (boolean)this.validPartionTypes.contains(partition.getType()));
            Assert.assertTrue((String)"Wrong partition type.", (partitionType == null || partitionType.equals(partition.getType()) || allowMixedTypes ? 1 : 0) != 0);
            if (partitionType == null && !allowMixedTypes) {
                partitionType = partition.getType();
            }
            lastEnd = partition.getOffset() + partition.getLength();
            lastPartition = partition;
            ++n2;
        }
        int pos = offset;
        int end = offset + length;
        lastPartition = null;
        partitionType = expectedType;
        while (pos < end) {
            partition = this.getPartitioner().getPartition(pos);
            if (partition == null) {
                Assert.assertTrue((String)"Did not expect 'null' partition.", (boolean)allowGaps);
                ++pos;
                continue;
            }
            Assert.assertNotSame((String)"Got same partition again.", lastPartition, (Object)partition);
            Assert.assertFalse((String)"Did not expected and cannot handle empty partition.", (partition.getLength() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Got not the requested partition.", (partition.getOffset() <= pos && partition.getOffset() + partition.getLength() > pos ? 1 : 0) != 0);
            Assert.assertTrue((String)"Not a valid partition type.", (boolean)this.validPartionTypes.contains(partition.getType()));
            lastPartition = partition;
            if (partitionType != null && !partitionType.equals(partition.getType())) {
                Assert.assertTrue((String)"Wrong partition type.", (boolean)allowMixedTypes);
                pos += partition.getLength();
                end += partition.getLength();
                continue;
            }
            if (partitionType == null && !allowMixedTypes) {
                partitionType = partition.getType();
            }
            pos = partition.getOffset() + partition.getLength();
        }
        return this;
    }

    public IOConsoleTestUtil waitForScheduledJobs() {
        TestUtil.waitForJobs(this.name, ProcessConsoleManager.class, 25L, 10000L);
        TestUtil.waitForJobs(this.name, "CONSOLE_JOB_FAMILY", 25L, 10000L);
        return this;
    }

    public IOConsoleTestUtil flush() {
        this.waitForScheduledJobs();
        return this;
    }

    public void closeOutputStream() {
        if (this.defaultOut != null) {
            try {
                this.defaultOut.close();
            }
            catch (IOException e) {
                Assert.fail((String)"Failed to close output stream.");
            }
        }
    }

    public int getContentLength() {
        return this.getDocument().getLength();
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public IOConsoleOutputStream getDefaultOutputStream() {
        if (this.defaultOut == null) {
            this.defaultOut = this.console.newOutputStream();
        }
        return this.defaultOut;
    }

    public boolean isIgnoreFixedConsole() {
        return this.ignoreFixedConsole;
    }

    public void setIgnoreFixedConsole(boolean ignoreWrappeding) {
        this.ignoreFixedConsole = ignoreWrappeding;
    }

    public static String outputPartitionType() {
        return IOConsolePartition.OUTPUT_PARTITION_TYPE;
    }

    public static String inputPartitionType() {
        return IOConsolePartition.INPUT_PARTITION_TYPE;
    }
}

