/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.console.IOConsoleTestUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleDocumentPartitionerExtension;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.ConsoleView;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IOConsoleTests
extends AbstractDebugTest {
    private ConsoleView consoleView;
    private final AtomicBoolean consoleFinished = new AtomicBoolean(false);
    private final Queue<IStatus> loggedErrors = new ConcurrentLinkedQueue<IStatus>();
    private final ILogListener errorLogListener = (status, plugin) -> {
        if (status.matches(4)) {
            this.loggedErrors.add(status);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        ConsoleView castConsoleView;
        super.setUp();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Assert.assertNotNull((Object)window);
        IWorkbenchPage activePage = window.getActivePage();
        Assert.assertNotNull((Object)activePage);
        IViewPart viewPart = activePage.findView("org.eclipse.ui.console.ConsoleView");
        if (viewPart == null) {
            viewPart = activePage.showView("org.eclipse.ui.console.ConsoleView", null, 3);
        }
        this.consoleView = castConsoleView = (ConsoleView)viewPart;
        activePage.activate((IWorkbenchPart)this.consoleView);
        this.loggedErrors.clear();
        Platform.addLogListener((ILogListener)this.errorLogListener);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Platform.removeLogListener((ILogListener)this.errorLogListener);
        super.tearDown();
        this.assertNoError();
    }

    private void assertNoError() {
        String allErrors = this.loggedErrors.stream().map(Object::toString).collect(Collectors.joining(", "));
        AssertionError assertionError = new AssertionError((Object)("Test triggered errors in IOConsole: " + allErrors));
        this.loggedErrors.forEach(status -> {
            Throwable throwable = status.getException();
            if (throwable instanceof Throwable) {
                Throwable e = throwable;
                ((Throwable)((Object)assertionError)).addSuppressed(e);
            }
        });
        if (((Throwable)((Object)assertionError)).getSuppressed().length > 0) {
            throw assertionError;
        }
        Assert.assertTrue((String)("Test triggered errors in IOConsole: " + allErrors), (boolean)this.loggedErrors.isEmpty());
    }

    protected IOConsoleTestUtil getTestUtil(String title) {
        IOConsole console = new IOConsole(title, "", null, StandardCharsets.UTF_8.name(), true);
        this.consoleFinished.set(false);
        console.addPropertyChangeListener(event -> {
            if (event.getSource() == console && IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE.equals(event.getProperty())) {
                this.consoleFinished.set(true);
            }
        });
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.addConsoles(new IConsole[]{console});
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 25L, 10000L);
        consoleManager.showConsoleView((IConsole)console);
        IOConsolePage page = (IOConsolePage)this.consoleView.getCurrentPage();
        StyledText textPanel = (StyledText)page.getControl();
        return new IOConsoleTestUtil(console, textPanel, this.name.getMethodName());
    }

    protected void closeConsole(IOConsoleTestUtil c, String ... expectedInputLines) throws IOException {
        block21: {
            if (this.consoleFinished.get()) {
                TestUtil.log(2, "org.eclipse.debug.tests", "Console was finished before streams where explicit closed.", new Throwable[0]);
            }
            c.closeOutputStream();
            Throwable throwable = null;
            Object var4_5 = null;
            try (IOConsoleInputStream consoleIn = c.getConsole().getInputStream();){
                if (expectedInputLines.length <= 0) break block21;
                Assert.assertNotNull((Object)consoleIn);
                Assert.assertTrue((String)"InputStream is empty.", (consoleIn.available() > 0 ? 1 : 0) != 0);
                ArrayList<String> inputLines = new ArrayList<String>();
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)consoleIn, c.getConsole().getCharset()));){
                    String line;
                    while (reader.ready() && (line = reader.readLine()) != null) {
                        inputLines.add(line);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                Assert.assertEquals((String)"Input contains to many/few lines.", (long)expectedInputLines.length, (long)inputLines.size());
                int i = 0;
                while (i < expectedInputLines.length) {
                    Assert.assertEquals((String)("Content of input line " + i + " not as expected."), (Object)expectedInputLines[i], inputLines.get(i));
                    ++i;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        c.waitForScheduledJobs();
        Assert.assertTrue((String)"Console close was not signaled.", (boolean)this.consoleFinished.get());
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.removeConsoles(new IConsole[]{c.getConsole()});
    }

    @Test
    public void testConsoleClear() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test clear");
        c.writeAndVerify("Hello World!");
        c.getDocument().replace(0, c.getContentLength(), "");
        c.flush();
        c.verifyContent("").verifyPartitions();
        c.writeAndVerify("New console content.");
        c.clear();
        Assert.assertEquals((String)"Unexpected partition type.", (Object)IOConsoleTestUtil.inputPartitionType(), (Object)c.getPartitioner().getContentType(0));
        c.insertAndVerify("wrong").write("out").verifyContent("wrongout").verifyPartitions(2);
        c.clear().insertTypingAndVerify("i").write("ooo").verifyContent("iooo").verifyPartitions();
        c.enter().clear();
        c.insertAndVerify("gnorw").write("tuo").verifyContent("gnorwtuo").verifyPartitions(2);
        c.clear().insertTypingAndVerify("I").write("O").verifyContent("IO").verifyPartitions();
        c.insert("\r\n").clear();
        c.insertTypingAndVerify("some user input").selectAll().backspace();
        c.verifyContent("").verifyPartitions();
        c.writeFast("to be removed").clear().verifyPartitions();
        c.getConsole().clearConsole();
        c.writeAndVerify("do not remove this").verifyPartitions().clear();
        String longString = String.join((CharSequence)"", Collections.nCopies(1000, "012345678\n"));
        c.getConsole().clearConsole();
        c.writeAndVerify(longString).verifyPartitions().clear();
        String veryLongString = String.join((CharSequence)"", Collections.nCopies(20000, "abcdefghi\n"));
        c.getConsole().clearConsole();
        c.writeAndVerify(veryLongString).verifyPartitions().clear();
        this.closeConsole(c, "i", "I");
    }

    @Test
    public void testWrites() throws Exception {
        CharSequence[] strings;
        IOConsoleTestUtil c = this.getTestUtil("Test writes");
        CharSequence[] charSequenceArray = strings = new String[]{"Hello ", "World", "foo-", "bar", "123 456"};
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = charSequenceArray[n2];
            c.writeAndVerify(s);
            ++n2;
        }
        c.write("\n");
        String longString = String.join((CharSequence)"", Collections.nCopies(1000, "0123456789"));
        c.writeAndVerify(longString);
        c.verifyContentByOffset(strings[1], strings[0].length());
        c.verifyContentByLine(String.join((CharSequence)"", strings), 0);
        c.verifyPartitions();
        this.closeConsole(c, new String[0]);
    }

    @Test
    public void testUserInput() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test input");
        ArrayList<String> expectedInput = new ArrayList<String>();
        c.insertAndVerify("RR").backspace(3).verifyContent("").verifyPartitions();
        c.insertAndVerify("remove").select(0, c.getContentLength()).verifyPartitions();
        c.insertTypingAndVerify("abc").insertAndVerify("123").verifyContent("abc123");
        c.moveCaret(-3).insertAndVerify("foo").insertTypingAndVerify("bar").verifyContentByOffset("123", c.getCaretOffset());
        c.moveCaretToLineEnd().backspace(2).verifyContent("abcfoobar1").verifyPartitions();
        c.insert("\r\n").backspace(5);
        expectedInput.add("abcfoobar1");
        int pos = c.getCaretOffset();
        c.insertTypingAndVerify("NewLine").moveCaret(-4).enter();
        expectedInput.add("NewLine");
        Assert.assertEquals((String)"Expected newline entered inside line does not break this line.", (long)c.getContentLength(), (long)c.getCaretOffset());
        c.verifyPartitions().verifyContentByOffset("NewLine", pos);
        c.backspace().insertAndVerify("--").select(0, c.getContentLength()).insertTyping("<~>");
        c.verifyContentByLine("<~>", 2).verifyPartitions();
        c.select(-2, 1).insertAndVerify("-=-").verifyContentByLine("<-=->", 2).verifyPartitions();
        c.clear().insertTyping("=").insert("foo\n><");
        expectedInput.add("=foo");
        c.moveCaretToEnd().moveCaret(-1);
        c.insert("abc\r\n123\n456");
        expectedInput.add(">abc<");
        expectedInput.add("123");
        c.enter().clear();
        expectedInput.add("456");
        this.closeConsole(c, expectedInput.toArray(new String[0]));
    }

    @Test
    public void testInputFile() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test input file");
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream defaultOutputStream = c.getDefaultOutputStream();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);){
                Throwable throwable3 = null;
                Object var9_13 = null;
                try {
                    IOConsoleInputStream defaultIn = c.getConsole().getInputStream();
                    if (defaultIn != null) {
                        defaultIn.close();
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                c.getConsole().setInputStream((InputStream)in);
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            this.closeConsole(c, new String[0]);
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        this.assertNoError();
    }

    @Test
    public void testMixedWriteAndInput() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test input output mix");
        ArrayList<String> expectedInput = new ArrayList<String>();
        c.writeAndVerify("foo");
        c.insertTyping("~~~");
        c.writeAndVerify("bar");
        c.insertTyping("input.");
        c.verifyContent("foo~~~input.bar").verifyPartitions(3);
        c.enter().clear();
        expectedInput.add("~~~input.");
        c.insert("fixed\n");
        expectedInput.add("fixed");
        c.setCaretOffset(2);
        c.insertTyping("+");
        c.writeAndVerify("out");
        c.moveCaretToEnd().moveCaret(-1);
        c.insert("more input");
        c.select(0, c.getContentLength()).backspace();
        c.insert("~~p#t").select(c.getContentLength() - 5, 2).insert("in");
        c.select(c.getContentLength() - 2, 1).insertTyping("u");
        c.enter().clear();
        expectedInput.add("input");
        c.writeAndVerify("foo");
        c.insertTyping("><--input-partition--").setCaretOffset(4);
        c.writeAndVerify("bar");
        c.insertTypingAndVerify("short");
        c.verifyContent("foo>short<--input-partition--bar").verifyPartitions(3);
        c.enter().clear();
        expectedInput.add(">short<--input-partition--");
        c.writeAndVerify("Hello");
        c.insertTyping("><").moveCaret(-1);
        c.writeAndVerify("World");
        c.insertTypingAndVerify("user input");
        c.verifyContent("Hello>user input<World").verifyPartitions(3);
        c.enter().clear();
        expectedInput.add(">user input<");
        c.writeAndVerify("oooo");
        c.insertTyping("input");
        c.writeAndVerify("output");
        c.verifyContent("ooooinputoutput").verifyPartitions(3);
        c.select(4, 5).insertAndVerify("iiii");
        c.verifyContent("ooooiiiioutput").verifyPartitions(3);
        c.select(4, 4).backspace();
        c.verifyContent("oooooutput").verifyPartitions(2);
        c.enter().clear();
        expectedInput.add("");
        c.insertTypingAndVerify("ac").writeAndVerify("ooo");
        c.setCaretOffset(1).insertTypingAndVerify("b");
        c.moveCaretToEnd().insertTypingAndVerify("123");
        c.verifyContent("abcooo123").verifyPartitions(3);
        c.enter().clear();
        expectedInput.add("abc123");
        c.insertTypingAndVerify("abc").writeAndVerify("ooo");
        c.moveCaretToEnd().insertTypingAndVerify("13").writeAndVerify("OOO");
        c.moveCaret(-1).insertTyping("2");
        c.moveCaretToStart().insertTyping("ABC");
        c.verifyContent("ABCabcooo123OOO").verifyPartitions(4);
        c.enter().clear();
        expectedInput.add("ABCabc123");
        c.writeAndVerify("###").insertTyping("def").writeAndVerify("###");
        c.setCaretOffset(6).insertAndVerify("ghi");
        c.setCaretOffset(3).insertTypingAndVerify("abc");
        c.moveCaretToLineStart().insertTyping(":");
        c.enter().clear();
        expectedInput.add(":abcdefghi");
        c.writeAndVerify("o\u00f6O").insertTyping("\u00efiI").writeAndVerify("\u00d6\u00d8\u00f8");
        c.verifyContent("o\u00f6O\u00efiI\u00d6\u00d8\u00f8").verifyPartitions(2);
        c.select(4, 4).backspace();
        c.verifyContent("o\u00f6O\u00ef\u00d6\u00d8\u00f8").verifyPartitions(2);
        c.enter().clear();
        expectedInput.add("\u00ef");
        this.closeConsole(c, expectedInput.toArray(new String[0]));
    }

    @Test
    public void testControlCharacterSettings() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test options");
        c.getConsole().setHandleControlCharacters(false);
        c.getConsole().setCarriageReturnAsControlCharacter(false);
        c.write("\r..");
        Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
        c.getConsole().setCarriageReturnAsControlCharacter(true);
        c.write("\r..");
        Assert.assertEquals((String)"Wrong number of lines.", (long)3L, (long)c.getDocument().getNumberOfLines());
        c.getConsole().setHandleControlCharacters(true);
        c.getConsole().setCarriageReturnAsControlCharacter(false);
        c.write("\r..");
        Assert.assertEquals((String)"Wrong number of lines.", (long)4L, (long)c.getDocument().getNumberOfLines());
        c.getConsole().setCarriageReturnAsControlCharacter(true);
        c.write("\r..");
        Assert.assertEquals((String)"Wrong number of lines.", (long)4L, (long)c.getDocument().getNumberOfLines());
        this.closeConsole(c, new String[0]);
        this.assertNoError();
    }

    @Test
    public void testBackspaceControlCharacter() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test \\b");
        c.getConsole().setCarriageReturnAsControlCharacter(false);
        c.getConsole().setHandleControlCharacters(true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream err = c.getConsole().newOutputStream();){
            c.write("\b").write("|").verifyContent("|").verifyPartitions();
            c.writeFast("\b").write("/").verifyContent("/").verifyPartitions();
            c.writeFast("\b\b\b").write("-\b").verifyContent("-").verifyPartitions();
            c.writeFast("\b1\b2\b3\b").write("\\").verifyContent("\\").verifyPartitions();
            c.clear();
            c.writeFast("out").write("err", err).verifyContent("outerr").verifyPartitions(2);
            c.writeFast("\b\b\b\b\b\b\b\b\b\b\b\b\b");
            c.writeFast("err", err).write("out").verifyContent("errout").verifyPartitions(2);
            c.writeFast("\b\b\b\b\b\b\b\b\b\b\b\b\b");
            c.writeFast("12", err).writeFast("345").write("6789", err).verifyContent("123456789").verifyPartitions(3);
            c.clear();
            c.writeFast("First line\n").writeFast("\b\b", err).writeFast("Zecond line");
            c.writeFast("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
            c.write("S", err).verifyContentByLine("First line", 0).verifyContentByLine("Second line", 1).verifyPartitions(2);
            c.clear();
            c.writeAndVerify("out").insertTyping("input").writeAndVerify("err", err).verifyContent("outinputerr").verifyPartitions(3);
            c.setCaretOffset(6).backspace().backspace().writeAndVerify("~~~").verifyContentByOffset("~~~", -3).verifyPartitions(3);
            c.verifyContent("outiuterr~~~");
            c.writeFast("\b\b\b\b\b\b\b\b\b\b\b\b\b");
            c.write("output").verifyContent("outiutput~~~").verifyPartitions(3);
            c.setCaretOffset(4).insertTyping("np").verifyContent("outinputput~~~").verifyPartitions(3);
            c.write("+++++", err).verifyContent("outinputput+++++").verifyPartitions(3);
            c.writeFast(String.join((CharSequence)"", Collections.nCopies(11, "\b")));
            c.write("err", err).verifyContent("errinputput+++++").verifyPartitions(3);
            c.clear();
            c.writeAndVerify("ooooo").insertTyping("iii").write("eeee", err).moveCaretToEnd().insertTyping("i").write("oo");
            c.verifyContent("oooooiiieeeeioo").verifyPartitions(3);
            c.writeFast(String.join((CharSequence)"", Collections.nCopies(7, "\b")));
            c.write("xx").verifyContent("ooooxiiixeeeioo").verifyPartitions(3);
            c.clear();
            c.insert("iiii").writeFast("\b").write("o").verifyContent("iiiio").verifyPartitions(2);
            c.write("\b\bee", err).verifyContentByOffset("iiiiee", 0).verifyPartitions(2);
            c.writeFast("\b\b\b\b\b\b\b\b", err).write("o").verifyContent("iiiioe").verifyPartitions(3);
            c.clear();
            c.writeAndVerify("1", err).insertTyping("input").enter().write("2");
            c.verifyContentByLine("1input", 0).verifyContentByLine("2", 1).verifyPartitions(3);
            c.writeFast("\b\b\b\b\b\b\b\b\b\b\b\b\b", err);
            c.write("???").verifyContentByLine("?input", 0).verifyContentByLine("??", 1).verifyPartitions(3);
            c.writeFast("\b\b").writeFast("\b", err).write("><~");
            c.verifyContentByLine(">input", 0).verifyContentByLine("<~", 1).verifyPartitions(3);
            c.clear();
            c.writeAndVerify("abc", err).insert("<>").write("def").verifyContent("abc<>def").verifyPartitions(3);
            c.write("\b\b").setCaretOffset(4).insertTypingAndVerify("-=-").verifyContent("abc<-=->def").verifyPartitions(3);
            c.moveCaret(-1).backspace().verifyContent("abc<-->def").verifyPartitions(3);
            c.write("e\b\b\b\b", err).insertTyping("++").verifyContent("abc<-++->def").verifyPartitions(3);
            c.select(0, c.getDocument().getLength()).backspace().write("b").verifyContent("abcdef").verifyPartitions(3);
            c.clear();
            c.writeFast("1.2.").writeFast("\b\b").write("\n");
            c.verifyContentByLine("1.", 0).verifyContentByLine(".", 1).verifyPartitions();
            c.writeFast("\b\b\b\b").write("2.");
            c.verifyContentByLine("1.", 0).verifyContentByLine("2.", 1).verifyPartitions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.closeConsole(c, new String[0]);
        this.assertNoError();
    }

    @Test
    public void testCarriageReturnControlCharacter() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test \\r");
        c.getConsole().setCarriageReturnAsControlCharacter(true);
        c.getConsole().setHandleControlCharacters(true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream err = c.getConsole().newOutputStream();){
            c.write("\r");
            Assert.assertEquals((String)"Wrong number of lines.", (long)1L, (long)c.getDocument().getNumberOfLines());
            c.writeFast("bad", err).write("\rgood").verifyContent("good").verifyPartitions(1);
            Assert.assertEquals((String)"Wrong number of lines.", (long)1L, (long)c.getDocument().getNumberOfLines());
            c.clear();
            c.writeFast("First line\r\n").write("Zecond line", err);
            c.verifyContentByLine("First line", 0).verifyContentByLine("Zecond line", 1).verifyPartitions(2);
            Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
            c.writeFast("\r").write("3.    ").verifyContentByLine("3.     line", 1).verifyPartitions(2);
            Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
            c.writeFast("\r\r\r", err).write("Second").verifyContentByLine("Second line", 1).verifyPartitions(2);
            Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
            c.clear();
            c.insertTypingAndVerify("input").writeFast("out\r").write("err", err);
            c.verifyContent("inputerr").verifyPartitions(2);
            c.enter().write("\rout").verifyContentByLine("inputout", 0).verifyPartitions(2);
            c.write("err", err).verifyContentByLine("err", 1).verifyPartitions(3);
            c.write("\roooooo").verifyContentByLine("inputooo", 0).verifyContentByLine("ooo", 1).verifyPartitions(2);
            c.clear();
            c.write("\r\n");
            Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
            c.writeFast("err", err).writeFast("\r\r\r\r\r\r\r\r\n\n").write("out");
            Assert.assertEquals((String)"Wrong number of lines.", (long)4L, (long)c.getDocument().getNumberOfLines());
            c.verifyContentByLine("out", -1).verifyPartitions();
            Assert.assertTrue((String)"Line breaks did not overwrite text.", (!c.getDocument().get().contains("err") ? 1 : 0) != 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.closeConsole(c, new String[0]);
        this.assertNoError();
    }

    @Test
    public void testFormFeedControlCharacter() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test \\f");
        c.getConsole().setHandleControlCharacters(true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream err = c.getConsole().newOutputStream();){
            c.write("\f");
            Assert.assertEquals((String)"Wrong number of lines.", (long)2L, (long)c.getDocument().getNumberOfLines());
            c.verifyContentByLine("", 0).verifyContentByLine("", 1);
            c.writeAndVerify("output").writeFast("\f").write("more");
            c.verifyContentByLine("output", 1);
            c.verifyContentByLine("      more", 2);
            c.clear();
            c.writeFast("\f\f").writeFast("\f", err).write("\fend").verifyPartitions(2);
            Assert.assertEquals((String)"Wrong number of lines.", (long)5L, (long)c.getDocument().getNumberOfLines());
            c.verifyContentByLine("end", 4);
            c.clear();
            c.write("1st\f2nd\f3rd").verifyPartitions();
            c.verifyContentByLine("1st", 0);
            c.verifyContentByLine("   2nd", 1);
            c.verifyContentByLine("      3rd", 2);
            c.clear();
            c.write("first\f\b\bsecond");
            c.verifyContentByLine("first", 0);
            c.verifyContentByLine("   second", 1);
            c.clear();
            c.writeFast("><\b").writeFast("\f", err).write("abc").verifyPartitions(2);
            c.verifyContentByLine("><", 0);
            c.verifyContentByLine(" abc", 1);
            c.clear();
            c.writeAndVerify("foo").insertTyping("input").writeFast("bar").write("\f.", err).verifyPartitions(2);
            c.verifyContentByLine("fooinputbar", 0);
            c.verifyContentByLine("           .", 1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.closeConsole(c, new String[0]);
    }

    @Test
    public void testNullByte() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test \\0");
        c.getConsole().setHandleControlCharacters(true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream err = c.getConsole().newOutputStream();){
            c.write("\u0000").verifyContent("");
            c.write("abc\u0000123").verifyContent("abc123");
            c.writeFast("\u0000", err).writeAndVerify("output");
            c.write("\n\u0000x\u0000y\u0000z\u0000\u0000\u0000987", err).verifyContentByLine("xyz987", 1).verifyPartitions();
            Assert.assertFalse((boolean)c.getDocument().get().contains("\u0000"));
            c.clear();
            c.writeFast("123").writeFast("\b\b\b").write("+\u0000+").verifyContent("++3").verifyPartitions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.closeConsole(c, new String[0]);
    }

    @Test
    public void testManyPartitions() throws IOException {
        IOConsoleTestUtil c = this.getTestUtil("Test many partitions");
        ArrayList<String> expectedInput = new ArrayList<String>();
        StringBuilder input = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try (IOConsoleOutputStream otherOut = c.getConsole().newOutputStream();){
            Random rand = new Random(12L);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < 80) {
                    sb.setLength(0);
                    int k = rand.nextInt(15) + 1;
                    while (k > 0) {
                        sb.append((char)(rand.nextInt(95) + 32));
                        --k;
                    }
                    switch (rand.nextInt(5)) {
                        case 0: {
                            c.insert(sb.toString());
                            input.append((CharSequence)sb);
                            break;
                        }
                        case 1: 
                        case 2: {
                            c.writeFast(sb.toString(), otherOut);
                            break;
                        }
                        default: {
                            c.writeFast(sb.toString());
                        }
                    }
                    j += sb.length();
                }
                c.enter().verifyPartitions();
                expectedInput.add(input.toString());
                input.setLength(0);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.closeConsole(c, expectedInput.toArray(new String[0]));
    }

    @Test
    public void testTrim() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test trim");
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream defaultOut = c.getDefaultOutputStream();){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (IOConsoleOutputStream otherOut = c.getConsole().newOutputStream();){
                c.writeFast("first\n");
                int i = 0;
                while (i < 20) {
                    c.writeFast("0123456789\n", (i & 1) == 0 ? defaultOut : otherOut);
                    ++i;
                }
                c.write("last\n");
                c.verifyContentByLine("first", 0).verifyContentByLine("last", -2);
                Assert.assertTrue((String)"Document not filled.", (c.getDocument().getNumberOfLines() > 15 ? 1 : 0) != 0);
                c.getConsole().setWaterMarks(50, 100);
                c.waitForScheduledJobs();
                c.verifyContentByOffset("0123456789", 0);
                Assert.assertTrue((String)"Document not trimmed.", (c.getDocument().getNumberOfLines() < 15 ? 1 : 0) != 0);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.closeConsole(c, new String[0]);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testIOPartitioner() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test partitioner");
        c.writeAndVerify("output");
        c.getDocument().replace(2, 1, ":::");
        c.verifyPartitions();
        c.clear().insertAndVerify("input").enter();
        c.getDocument().replace(3, 0, "()");
        c.verifyInputPartitions(0, c.getContentLength());
        c.clear().writeAndVerify("><");
        c.getDocument().replace(1, 0, "a\nb\r\nc");
        c.verifyContent(">a\nb\r\nc<").verifyPartitions();
        c.clear().writeAndVerify(")");
        c.getDocument().replace(0, 0, "(");
        c.verifyContent("()").verifyPartitions();
        this.closeConsole(c, new String[0]);
        this.assertNoError();
    }

    @Test
    public void testIConsoleDocumentPartitioner() throws Exception {
        IOConsoleTestUtil c = this.getTestUtil("Test IConsoleDocumentPartitioner");
        Throwable throwable = null;
        Object var3_4 = null;
        try (IOConsoleOutputStream otherOut = c.getConsole().newOutputStream();){
            Object[] styles = c.getPartitioner().getStyleRanges(0, 1);
            Assertions.assertThat((Object[])styles).satisfiesAnyOf(new ThrowingConsumer[]{it -> Assertions.assertThat((Object[])it).isNull(), it -> {
                AbstractObjectArrayAssert abstractObjectArrayAssert = Assertions.assertThat((Object[])it).hasSize(0);
            }});
            c.insertAndVerify("#\n");
            c.insertTyping("L");
            c.writeFast("orem ipsum dolor sit amet, consetetur sadipscing elitr,\n");
            c.writeFast("sed diam nonumy eirmod tempor invidunt ut labore et dolore\n", otherOut);
            c.writeFast("magna aliquyam erat, sed diam voluptua. At vero eos et accusam\n");
            c.writeFast("et justo duo dolores et ea rebum. Stet clita kasd gubergren,\n", otherOut);
            c.write("no sea takimata sanctus est Lorem ipsum dolor sit amet.\n");
            int loremEnd = c.getContentLength();
            c.moveCaretToEnd().insertTypingAndVerify("--").writeAndVerify("ooo");
            c.setCaretLineRelative(1).insertTypingAndVerify("-");
            c.verifyContentByLine("---ooo", -1);
            styles = c.getPartitioner().getStyleRanges(0, c.getContentLength());
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSizeGreaterThanOrEqualTo(3);
            styles = c.getPartitioner().getStyleRanges(5, 20);
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSize(1);
            styles = c.getPartitioner().getStyleRanges(loremEnd + 1, 1);
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSize(1);
            styles = c.getPartitioner().getStyleRanges(loremEnd, c.getContentLength() - loremEnd);
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSize(2);
            styles = c.getPartitioner().getStyleRanges(loremEnd - 3, 5);
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSize(2);
            styles = c.getPartitioner().getStyleRanges(loremEnd - 3, 8);
            this.checkOverlapping((StyleRange[])styles);
            Assert.assertNotNull((String)"Partitioner provided no styles.", (Object)styles);
            Assertions.assertThat((Object[])styles).hasSize(3);
            Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(0));
            Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(1));
            Assert.assertFalse((String)"Offset should be writable.", (boolean)c.getPartitioner().isReadOnly(2));
            int i = 3;
            while (i < loremEnd) {
                Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(i));
                ++i;
            }
            Assert.assertFalse((String)"Offset should be writable.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 0));
            Assert.assertFalse((String)"Offset should be writable.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 1));
            Assert.assertFalse((String)"Offset should be writable.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 2));
            Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 3));
            Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 4));
            Assert.assertTrue((String)"Offset should be read-only.", (boolean)c.getPartitioner().isReadOnly(loremEnd + 5));
            if (c.getPartitioner() instanceof IConsoleDocumentPartitionerExtension) {
                IConsoleDocumentPartitionerExtension extension = (IConsoleDocumentPartitionerExtension)c.getPartitioner();
                Assert.assertFalse((String)"Writable parts not recognized.", (boolean)extension.isReadOnly(0, c.getContentLength()));
                Assert.assertTrue((String)"Read-only parts not recognized.", (boolean)extension.containsReadOnly(0, c.getContentLength()));
                Assert.assertFalse((String)"Writable parts not recognized.", (boolean)extension.isReadOnly(0, 3));
                Assert.assertTrue((String)"Read-only parts not recognized.", (boolean)extension.containsReadOnly(0, 3));
                Assert.assertFalse((String)"Area should be writable.", (boolean)extension.isReadOnly(loremEnd, 3));
                Assert.assertFalse((String)"Area should be writable.", (boolean)extension.containsReadOnly(loremEnd, 3));
                Assert.assertTrue((String)"Area should be read-only.", (boolean)extension.isReadOnly(6, 105));
                Assert.assertTrue((String)"Area should be read-only.", (boolean)extension.containsReadOnly(8, 111));
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeReadOnlyPartitions()).as("has read-only parts", new Object[0])).hasSizeGreaterThan(0);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeWritablePartitions()).as("has writable parts", new Object[0])).hasSizeGreaterThan(0);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeReadOnlyPartitions(loremEnd - 5, 7)).as("has read-only parts", new Object[0])).hasSizeGreaterThan(0);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeWritablePartitions(loremEnd - 5, 7)).as("has writable parts", new Object[0])).hasSizeGreaterThan(0);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeReadOnlyPartitions(5, 100)).as("area is readable", new Object[0])).hasSizeGreaterThan(0);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeWritablePartitions(5, 100)).as("area is read-only", new Object[0])).isEmpty();
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeReadOnlyPartitions(loremEnd, 2)).as("area is not read-only", new Object[0])).isEmpty();
                ((ObjectArrayAssert)Assertions.assertThat((Object[])extension.computeWritablePartitions(loremEnd, 2)).as("area is writable", new Object[0])).hasSizeGreaterThan(0);
                Assert.assertEquals((String)"Got wrong offset.", (long)0L, (long)extension.getNextOffsetByState(0, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)2L, (long)extension.getNextOffsetByState(0, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)0L, (long)extension.getPreviousOffsetByState(0, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)-1L, (long)extension.getPreviousOffsetByState(0, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)1L, (long)extension.getNextOffsetByState(1, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)2L, (long)extension.getNextOffsetByState(1, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)1L, (long)extension.getPreviousOffsetByState(1, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)-1L, (long)extension.getPreviousOffsetByState(1, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)3L, (long)extension.getNextOffsetByState(2, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)2L, (long)extension.getNextOffsetByState(2, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)1L, (long)extension.getPreviousOffsetByState(2, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)2L, (long)extension.getPreviousOffsetByState(2, true));
                int i2 = 3;
                while (i2 < loremEnd) {
                    Assert.assertEquals((String)"Got wrong offset.", (long)i2, (long)extension.getNextOffsetByState(i2, false));
                    Assert.assertEquals((String)"Got wrong offset.", (long)loremEnd, (long)extension.getNextOffsetByState(i2, true));
                    Assert.assertEquals((String)"Got wrong offset.", (long)i2, (long)extension.getPreviousOffsetByState(i2, false));
                    Assert.assertEquals((String)"Got wrong offset.", (long)2L, (long)extension.getPreviousOffsetByState(i2, true));
                    ++i2;
                }
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd + 3), (long)extension.getNextOffsetByState(loremEnd, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)loremEnd, (long)extension.getNextOffsetByState(loremEnd, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd - 1), (long)extension.getPreviousOffsetByState(loremEnd, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)loremEnd, (long)extension.getPreviousOffsetByState(loremEnd, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd + 3), (long)extension.getNextOffsetByState(loremEnd + 2, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd + 2), (long)extension.getNextOffsetByState(loremEnd + 2, true));
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd - 1), (long)extension.getPreviousOffsetByState(loremEnd + 2, false));
                Assert.assertEquals((String)"Got wrong offset.", (long)(loremEnd + 2), (long)extension.getPreviousOffsetByState(loremEnd + 2, true));
            } else {
                TestUtil.log(1, "org.eclipse.debug.tests", "IOConsole partitioner does not implement " + IConsoleDocumentPartitionerExtension.class.getName() + ". Skip those tests.", new Throwable[0]);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        c.verifyPartitions();
        this.closeConsole(c, "#");
        this.assertNoError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBug421303_StreamProcessingDeadlock() throws Exception {
        final IOConsoleTestUtil c = this.getTestUtil("Test Bug 421303 Stream processing deadlock");
        final String veryLongString = String.join((CharSequence)"", Collections.nCopies(20000, "0123456789"));
        final Exception[] jobException = new Exception[1];
        AtomicBoolean deadlocked = new AtomicBoolean(false);
        Job job = new Job("Async out"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                IOConsoleTestUtil iOConsoleTestUtil = c;
                synchronized (iOConsoleTestUtil) {
                    c.notifyAll();
                }
                try {
                    c.writeFast(veryLongString);
                }
                catch (IOException e) {
                    jobException[0] = e;
                }
                return Status.OK_STATUS;
            }
        };
        Thread watchdog = new Thread(() -> {
            try {
                Thread.sleep(this.testTimeout);
                IOConsoleTestUtil iOConsoleTestUtil2 = c;
                synchronized (iOConsoleTestUtil2) {
                    c.notifyAll();
                }
                if (job.getThread() != null && job.getThread().isAlive()) {
                    deadlocked.set(true);
                    job.getThread().interrupt();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, "Watchdog");
        watchdog.setDaemon(true);
        watchdog.start();
        IOConsoleTestUtil iOConsoleTestUtil = c;
        synchronized (iOConsoleTestUtil) {
            job.schedule();
            c.wait();
        }
        Thread.yield();
        Thread.sleep(50L);
        c.writeFast(veryLongString);
        watchdog.interrupt();
        watchdog.join(1000L);
        if (jobException[0] != null) {
            throw jobException[0];
        }
        Assert.assertFalse((String)"Deadlock in stream processing.", (boolean)deadlocked.get());
        this.closeConsole(c, new String[0]);
    }

    private void checkOverlapping(StyleRange[] styles) {
        if (styles == null || styles.length <= 1) {
            return;
        }
        Arrays.sort(styles, (a, b) -> Integer.compare(a.start, b.start));
        int lastEnd = Integer.MIN_VALUE;
        StyleRange[] styleRangeArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange s = styleRangeArray[n2];
            Assert.assertTrue((String)"Styles overlap.", (lastEnd <= s.start ? 1 : 0) != 0);
            lastEnd = s.start + s.length;
            ++n2;
        }
    }

    @Test
    public void testIsAnsiEscapeEnabled() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        boolean initial = IOConsole.isAnsiConsoleEnabled();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        String ANSI_ENABLE_DISABLE_COMMAND_ID = "AnsiConsole.command.enable_disable";
        Command command = service.getCommand("AnsiConsole.command.enable_disable");
        ExecutionEvent execEvent = new ExecutionEvent(command, Map.of(), null, null);
        command.executeWithChecks(execEvent);
        boolean changed = IOConsole.isAnsiConsoleEnabled();
        Assert.assertNotEquals((Object)initial, (Object)changed);
        command.executeWithChecks(execEvent);
        boolean changedBack = IOConsole.isAnsiConsoleEnabled();
        Assert.assertEquals((Object)initial, (Object)changedBack);
    }
}

