/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Set;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.ILog;
import org.eclipse.debug.internal.core.InputStreamMonitor;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.TestsPlugin;
import org.junit.Test;

public class InputStreamMonitorTests
extends AbstractDebugTest {
    private static int CONDITION_TIMEOUT_IN_MILLIS = 1000;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testInputStreamMonitor() throws Exception {
        try (InputStreamMonitor monitor = null;){
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                PipedInputStream sysin = new PipedInputStream();
                try {
                    try (PipedOutputStream outputFromSysin = new PipedOutputStream(sysin);){
                        monitor = new InputStreamMonitor((OutputStream)outputFromSysin);
                        byte[] originalContent = new byte[100];
                        int i = 0;
                        while (i < originalContent.length) {
                            originalContent[i] = (byte)(i % 255);
                            ++i;
                        }
                        int half = originalContent.length / 2;
                        monitor.write(originalContent, 0, half);
                        monitor.startMonitoring();
                        monitor.write(originalContent, half, originalContent.length - half);
                        this.waitForElementsInStream(sysin, originalContent.length);
                        byte[] contentWrittenByMonitor = new byte[originalContent.length];
                        sysin.read(contentWrittenByMonitor);
                        int additionalBytesWritten = sysin.available();
                        Assertions.assertThat((int)additionalBytesWritten).isZero();
                        Assertions.assertThat((byte[])contentWrittenByMonitor).isEqualTo((Object)originalContent);
                    }
                    if (sysin == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (sysin == null) throw throwable;
                    sysin.close();
                    throw throwable;
                }
                sysin.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private void waitForElementsInStream(PipedInputStream sysin, int numberOfElements) throws Exception {
        TestUtil.waitWhile(() -> {
            try {
                if (sysin.available() < numberOfElements) {
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                return true;
            }
        }, CONDITION_TIMEOUT_IN_MILLIS);
        Assertions.assertThat((int)sysin.available()).isEqualTo(numberOfElements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNullCharset() throws Exception {
        try (InputStreamMonitor monitor = null;){
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                PipedInputStream sysin = new PipedInputStream();
                try {
                    try (PipedOutputStream outputFromSysin = new PipedOutputStream(sysin);){
                        monitor = new InputStreamMonitor((OutputStream)outputFromSysin);
                        String text = "o\u00f6O\u00efiI\u00d6\u00d8\u00f8";
                        monitor.startMonitoring();
                        monitor.write(text);
                        this.waitForElementsInStream(sysin, text.getBytes().length);
                        byte[] readBack = new byte[1000];
                        int len = sysin.read(readBack);
                        String readContent = new String(readBack, 0, len);
                        Assertions.assertThat((String)readContent).isEqualTo(text);
                    }
                    if (sysin == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (sysin == null) throw throwable;
                    sysin.close();
                    throw throwable;
                }
                sysin.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    @Test
    public void testClose() throws Exception {
        String threadName = "MAGICtestClose";
        Supplier<Long> getInputStreamMonitorThreads = () -> {
            Set<Thread> allThreads = Thread.getAllStackTraces().keySet();
            long numMonitorThreads = allThreads.stream().filter(t -> t.getName().contains(threadName)).count();
            return numMonitorThreads;
        };
        long alreadyLeakedThreads = getInputStreamMonitorThreads.get();
        if (alreadyLeakedThreads > 0L) {
            ILog.of(TestsPlugin.class).warn("Test started with " + alreadyLeakedThreads + " leaked monitor threads.");
        }
        ClosableTestOutputStream testStream = new ClosableTestOutputStream();
        InputStreamMonitor monitor = new InputStreamMonitor((OutputStream)testStream);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).withFailMessage("stream closed too early", new Object[0])).isZero();
        monitor.closeInputStream();
        TestUtil.waitWhile(() -> closableTestOutputStream.numClosed == 0, CONDITION_TIMEOUT_IN_MILLIS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).withFailMessage("stream not closed", new Object[0])).isNotZero();
        testStream = new ClosableTestOutputStream();
        monitor = new InputStreamMonitor((OutputStream)testStream);
        monitor.startMonitoring(threadName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).withFailMessage("stream closed too early", new Object[0])).isZero();
        monitor.close();
        TestUtil.waitWhile(() -> closableTestOutputStream.numClosed == 0, CONDITION_TIMEOUT_IN_MILLIS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).withFailMessage("stream not closed", new Object[0])).isNotZero();
        testStream = new ClosableTestOutputStream();
        monitor = new InputStreamMonitor((OutputStream)testStream);
        monitor.startMonitoring(threadName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).withFailMessage("stream closed too early", new Object[0])).isZero();
        monitor.closeInputStream();
        monitor.close();
        monitor.close();
        TestUtil.waitWhile(() -> closableTestOutputStream.numClosed == 0, CONDITION_TIMEOUT_IN_MILLIS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)testStream.numClosed).as("stream should be closed once", new Object[0])).isEqualTo(1);
        TestUtil.waitWhile(() -> (Long)getInputStreamMonitorThreads.get() > 0L, CONDITION_TIMEOUT_IN_MILLIS);
        ((AbstractLongAssert)Assertions.assertThat((Long)getInputStreamMonitorThreads.get()).as("leaked monitor threads", new Object[0])).isZero();
    }

    public static class ClosableTestOutputStream
    extends OutputStream {
        public volatile int numClosed = 0;

        @Override
        public void close() throws IOException {
            ++this.numClosed;
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

