/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.tests.console.MockProcessHandle;

public class MockProcess
extends Process {
    public static final int RUN_FOREVER = -1;
    private final ByteArrayOutputStream stdin = new ByteArrayOutputStream();
    private final InputStream stdout;
    private final InputStream stderr;
    private final Object waitForTerminationLock = new Object();
    private final AtomicInteger receivedInput = new AtomicInteger(0);
    private long endTime;
    private int exitCode = 0;
    private Optional<MockProcessHandle> handle = Optional.of(new MockProcessHandle(this));
    private int terminationDelay = 0;
    private volatile ProcessState processState = ProcessState.RUNNING;

    public MockProcess(long runTimeMs) {
        this(null, null, runTimeMs);
    }

    public MockProcess(InputStream stdout, InputStream stderr, long runTimeMs) {
        this.stdout = stdout != null ? stdout : new ByteArrayInputStream(new byte[0]);
        this.stderr = stderr != null ? stderr : new ByteArrayInputStream(new byte[0]);
        this.endTime = runTimeMs < 0L ? -1L : System.currentTimeMillis() + runTimeMs;
    }

    public MockProcess(int expectedInputSize, long timeoutMs) {
        this.stdout = new ByteArrayInputStream(new byte[0]);
        this.stderr = new ByteArrayInputStream(new byte[0]);
        this.endTime = timeoutMs > 0L ? System.currentTimeMillis() + timeoutMs : -1L;
        Thread inputMonitor = new Thread(() -> {
            while (!this.isTerminated()) {
                Object object = this.waitForTerminationLock;
                synchronized (object) {
                    if (this.receivedInput.get() + this.stdin.size() >= expectedInputSize) {
                        this.endTime = System.currentTimeMillis();
                        this.waitForTerminationLock.notifyAll();
                        break;
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }, "Mockup Process Input Monitor");
        inputMonitor.setDaemon(true);
        inputMonitor.start();
    }

    public MockProcess() {
        this.stderr = new ByteArrayInputStream(new byte[0]);
        this.endTime = -1L;
        this.stdout = new InputStream(){

            @Override
            public int read() throws IOException {
                if (MockProcess.this.processState == ProcessState.LASTREAD) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MockProcess.this.processState = ProcessState.TERMINATED;
                    return ProcessState.LASTREAD.getCode();
                }
                return MockProcess.this.processState.getCode();
            }
        };
    }

    public synchronized byte[] getReceivedInput() {
        byte[] content = this.stdin.toByteArray();
        this.stdin.reset();
        this.receivedInput.addAndGet(content.length);
        return content;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public ProcessHandle toHandle() {
        if (this.handle.isPresent()) {
            return this.handle.get();
        }
        return super.toHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Object object = this.waitForTerminationLock;
        synchronized (object) {
            while (!this.isTerminated()) {
                if (this.endTime == -1L) {
                    this.waitForTerminationLock.wait();
                    continue;
                }
                long waitTime = this.endTime - System.currentTimeMillis();
                if (waitTime <= 0L) continue;
                this.waitForTerminationLock.wait(waitTime);
            }
        }
        this.setTerminated();
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingMs = unit.toMillis(timeout);
        long timeoutMs = System.currentTimeMillis() + remainingMs;
        Object object = this.waitForTerminationLock;
        synchronized (object) {
            while (!this.isTerminated() && remainingMs > 0L) {
                long waitTime = this.endTime == -1L ? Long.MAX_VALUE : this.endTime - System.currentTimeMillis();
                if ((waitTime = Math.min(waitTime, remainingMs)) > 0L) {
                    this.waitForTerminationLock.wait(waitTime);
                }
                remainingMs = timeoutMs - System.currentTimeMillis();
            }
        }
        if (this.isTerminated()) {
            this.setTerminated();
        }
        return this.isTerminated();
    }

    @Override
    public int exitValue() {
        if (!this.isTerminated()) {
            String end = this.endTime == -1L ? "never." : "in " + (this.endTime - System.currentTimeMillis()) + " ms.";
            throw new IllegalThreadStateException("Mockup process terminates " + end);
        }
        return this.exitCode;
    }

    @Override
    public void destroy() {
        this.destroy(this.terminationDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(int delay) {
        this.processState = ProcessState.DESTROYING;
        Object object = this.waitForTerminationLock;
        synchronized (object) {
            this.endTime = System.currentTimeMillis() + (long)delay;
            this.waitForTerminationLock.notifyAll();
            if (delay <= 0) {
                this.setTerminated();
            }
        }
    }

    private boolean isTerminated() {
        return this.endTime != -1L && System.currentTimeMillis() >= this.endTime;
    }

    public void setExitValue(int exitCode) {
        this.exitCode = exitCode;
    }

    public void setHandle(MockProcessHandle handle) {
        this.handle = Optional.ofNullable(handle);
    }

    public void setTerminationDelay(int delay) {
        this.terminationDelay = delay;
    }

    public RuntimeProcess toRuntimeProcess() {
        return this.toRuntimeProcess("MockProcess");
    }

    public RuntimeProcess toRuntimeProcess(String name) {
        return (RuntimeProcess)DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)this, (String)name);
    }

    public RuntimeProcess toRuntimeProcess(String name, Map<String, Object> launchConfigAttributes) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchType = launchManager.getLaunchConfigurationType("org.eclipse.debug.tests.launch.type");
        ILaunchConfigurationWorkingCopy launchConfiguration = launchType.newInstance(null, name);
        if (launchConfigAttributes != null) {
            launchConfiguration.setAttributes(launchConfigAttributes);
        }
        return (RuntimeProcess)DebugPlugin.newProcess((ILaunch)new Launch((ILaunchConfiguration)launchConfiguration, "run", null), (Process)this, (String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTerminated() {
        MockProcess mockProcess = this;
        synchronized (mockProcess) {
            if (this.processState != ProcessState.TERMINATED) {
                this.processState = ProcessState.LASTREAD;
            }
        }
        this.handle.ifPresent(MockProcessHandle::setTerminated);
    }

    public static enum ProcessState {
        RUNNING(82),
        DESTROYING(68),
        LASTREAD(76),
        TERMINATED(-1);

        private final int code;

        private ProcessState(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }
    }
}

