/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.debug.tests.console.MockProcess;

public class MockProcessHandle
implements ProcessHandle {
    private final MockProcess process;
    private final Collection<ProcessHandle> children;
    private final CompletableFuture<ProcessHandle> onExit = new CompletableFuture();

    public MockProcessHandle(MockProcess process) {
        this(process, Collections.emptyList());
    }

    public MockProcessHandle(MockProcess process, Collection<Process> children) {
        this.process = process;
        this.children = children.stream().map(Process::toHandle).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Stream<ProcessHandle> children() {
        return this.children.stream();
    }

    @Override
    public Stream<ProcessHandle> descendants() {
        return Stream.concat(this.children(), this.children().flatMap(ProcessHandle::descendants));
    }

    @Override
    public CompletableFuture<ProcessHandle> onExit() {
        return this.onExit;
    }

    @Override
    public boolean supportsNormalTermination() {
        return true;
    }

    @Override
    public boolean destroy() {
        this.process.destroy();
        return true;
    }

    @Override
    public boolean destroyForcibly() {
        return this.destroy();
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int compareTo(ProcessHandle other) {
        return Long.compare(this.pid(), ((MockProcessHandle)other).pid());
    }

    void setTerminated() {
        this.onExit.complete(this);
    }

    @Override
    public long pid() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Optional<ProcessHandle> parent() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public ProcessHandle.Info info() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

