/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.debug.core.IBinaryStreamListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.OutputStreamMonitor;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OutputStreamMonitorTests
extends AbstractDebugTest {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    TestOutputStreamMonitor monitor;
    PipedOutputStream sysout;
    PipedInputStream inputFromSysout;

    @Before
    public void setupStreams() throws IOException {
        this.sysout = new PipedOutputStream();
        this.inputFromSysout = new PipedInputStream(this.sysout);
        this.monitor = new TestOutputStreamMonitor(this.inputFromSysout, StandardCharsets.UTF_8);
    }

    @After
    public void closeStreams() throws IOException {
        this.inputFromSysout.close();
        this.sysout.close();
        this.monitor.close();
    }

    @Test
    public void testBufferedOutputStreamMonitor() throws Exception {
        String input = "o\u00f6O";
        byte[] byteInput = input.getBytes(StandardCharsets.UTF_8);
        BinaryListener binaryListener = new BinaryListener();
        StreamListener streamListener = new StreamListener();
        this.monitor.addBinaryListener(binaryListener);
        this.monitor.addListener(streamListener);
        this.sysout.write(byteInput, 0, 2);
        this.sysout.flush();
        this.monitor.startMonitoring();
        binaryListener.waitForBytes(2);
        streamListener.waitForBytes(1);
        String monitorContents = this.monitor.getContents();
        Assertions.assertThat((String)monitorContents).isEqualTo(input.substring(0, 1));
        Assertions.assertThat((String)streamListener.getRecordedChars()).isEqualTo(monitorContents);
        String monitorContentsOnSecondAccess = this.monitor.getContents();
        Assertions.assertThat((String)monitorContentsOnSecondAccess).isEqualTo(monitorContents);
        byte[] binaryMonitorData = this.monitor.getData();
        byte[] expectedBinaryData = new byte[2];
        System.arraycopy(byteInput, 0, expectedBinaryData, 0, 2);
        Assertions.assertThat((byte[])binaryMonitorData).isEqualTo((Object)expectedBinaryData);
        Assertions.assertThat((byte[])binaryListener.getRecordedBytes()).isEqualTo((Object)binaryMonitorData);
        byte[] binaryMonitorDataOnSecondAccess = this.monitor.getData();
        Assertions.assertThat((byte[])binaryMonitorDataOnSecondAccess).isEqualTo((Object)binaryMonitorData);
        this.monitor.flushContents();
        this.sysout.write(byteInput, 2, byteInput.length - 2);
        this.sysout.flush();
        binaryListener.waitForBytes(byteInput.length);
        streamListener.waitForBytes(new String(byteInput).length());
        monitorContents = this.monitor.getContents();
        Assertions.assertThat((String)monitorContents).isEqualTo(input.substring(1));
        monitorContentsOnSecondAccess = this.monitor.getContents();
        Assertions.assertThat((String)monitorContentsOnSecondAccess).isEqualTo(monitorContents);
        Assertions.assertThat((String)streamListener.getRecordedChars()).isEqualTo(input);
        binaryMonitorData = this.monitor.getData();
        expectedBinaryData = new byte[byteInput.length - 2];
        System.arraycopy(byteInput, 2, expectedBinaryData, 0, expectedBinaryData.length);
        Assertions.assertThat((byte[])binaryMonitorData).isEqualTo((Object)expectedBinaryData);
        binaryMonitorDataOnSecondAccess = this.monitor.getData();
        Assertions.assertThat((byte[])binaryMonitorDataOnSecondAccess).isEqualTo((Object)binaryMonitorData);
        Assertions.assertThat((byte[])binaryListener.getRecordedBytes()).isEqualTo((Object)byteInput);
        binaryListener.assertNoExceptions();
    }

    @Test
    public void testUnbufferedOutputStreamMonitor() throws Exception {
        String input = "o\u00f6O";
        byte[] byteInput = input.getBytes(StandardCharsets.UTF_8);
        BinaryListener binaryListener = new BinaryListener();
        StreamListener streamListener = new StreamListener();
        this.monitor.addBinaryListener(binaryListener);
        this.monitor.addListener(streamListener);
        this.sysout.write(byteInput, 0, 2);
        this.sysout.flush();
        this.monitor.setBuffered(false);
        this.monitor.startMonitoring();
        binaryListener.waitForBytes(2);
        streamListener.waitForBytes(1);
        Assertions.assertThat((String)streamListener.getRecordedChars()).isEqualTo(input.substring(0, 1));
        byte[] expected = new byte[2];
        System.arraycopy(byteInput, 0, expected, 0, 2);
        Assertions.assertThat((byte[])binaryListener.getRecordedBytes()).isEqualTo((Object)expected);
        this.monitor.flushContents();
        this.sysout.write(byteInput, 2, byteInput.length - 2);
        this.sysout.flush();
        binaryListener.waitForBytes(byteInput.length);
        streamListener.waitForBytes(new String(byteInput).length());
        Assertions.assertThat((String)streamListener.getRecordedChars()).isEqualTo(input);
        expected = new byte[byteInput.length - 2];
        System.arraycopy(byteInput, 2, expected, 0, expected.length);
        Assertions.assertThat((byte[])binaryListener.getRecordedBytes()).isEqualTo((Object)byteInput);
        binaryListener.assertNoExceptions();
    }

    @Test
    public void testNullCharset() throws Exception {
        String input = "o\u00f6O\u00efiI\u00d6\u00d8\u00f8";
        this.sysout.close();
        this.sysout = new PipedOutputStream();
        this.monitor.close();
        this.monitor = new TestOutputStreamMonitor(new PipedInputStream(this.sysout), null);
        StreamListener streamListener = new StreamListener();
        this.monitor.addListener(streamListener);
        this.monitor.startMonitoring();
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintStream out = new PrintStream(this.sysout);){
            out.print(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.sysout.flush();
        streamListener.waitForBytes(input.length());
        Assertions.assertThat((String)streamListener.getRecordedChars()).isEqualTo(input);
    }

    private class BinaryListener
    implements IBinaryStreamListener {
        private volatile ByteArrayOutputStream recordedBytes = new ByteArrayOutputStream();
        private final List<IOException> exceptions = Collections.synchronizedList(new ArrayList());

        private BinaryListener() {
        }

        public void streamAppended(byte[] data, IBinaryStreamMonitor mon) {
            if (OutputStreamMonitorTests.this.monitor == mon) {
                try {
                    this.recordedBytes.write(data);
                }
                catch (IOException e) {
                    this.exceptions.add(e);
                }
            }
        }

        public void waitForBytes(int numberOfBytes) throws Exception {
            TestUtil.waitWhile(() -> this.recordedBytes.size() < numberOfBytes, TIMEOUT.toMillis());
        }

        public byte[] getRecordedBytes() {
            return this.recordedBytes.toByteArray();
        }

        public void assertNoExceptions() {
            Assertions.assertThat(this.exceptions).isEmpty();
        }
    }

    private class StreamListener
    implements IStreamListener {
        private volatile StringBuilder recordedChars = new StringBuilder();

        private StreamListener() {
        }

        public void streamAppended(String text, IStreamMonitor mon) {
            if (OutputStreamMonitorTests.this.monitor == mon) {
                this.recordedChars.append(text);
            }
        }

        public void waitForBytes(int numberOfChars) throws Exception {
            TestUtil.waitWhile(() -> this.recordedChars.length() < numberOfChars, TIMEOUT.toMillis());
        }

        public String getRecordedChars() {
            return this.recordedChars.toString();
        }
    }

    private static class TestOutputStreamMonitor
    extends OutputStreamMonitor {
        public TestOutputStreamMonitor(InputStream stream, Charset charset) {
            super(stream, charset);
        }

        public void startMonitoring() {
            super.startMonitoring("");
        }

        public void close() {
            super.close();
        }
    }
}

