/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.console.MockProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.junit.Assert;
import org.junit.Test;

public class ProcessConsoleManagerTests
extends AbstractDebugTest {
    @Test
    public void testProcessConsoleLifecycle() throws Exception {
        DebugUIPlugin.getDefault();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        int existingNumConsoles = consoleManager.getConsoles().length;
        if (existingNumConsoles > 0) {
            TestUtil.log(1, this.name.getMethodName(), "Found " + existingNumConsoles + " existing consoles on test start.", new Throwable[0]);
        }
        ILaunch launch = null;
        MockProcess mockProcess = new MockProcess(-1L);
        try {
            RuntimeProcess process = mockProcess.toRuntimeProcess();
            launch = process.getLaunch();
            launchManager.addLaunch(launch);
            TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsoleManager.class, 0L, 10000L, ProcessConsole.class);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])consoleManager.getConsoles()).as("console has been added", new Object[0])).hasSize(1);
        }
        finally {
            mockProcess.destroy();
        }
        if (launch != null) {
            launchManager.removeLaunch(launch);
            TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsoleManager.class, 0L, 10000L);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])consoleManager.getConsoles()).as("console has been removed", new Object[0])).isEmpty();
        }
    }

    @Test
    public void testBug546710_ConsoleCreationRaceCondition() throws Exception {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch existingLaunch = iLaunchArray[n2];
            Assert.assertTrue((String)"Found existing not terminated launch. This should not happen and can interfere this test. Check for leakages in previous run tests.", (boolean)existingLaunch.isTerminated());
            launchManager.removeLaunch(existingLaunch);
            ++n2;
        }
        MockProcess mockProcess1 = new MockProcess(0L);
        RuntimeProcess process1 = mockProcess1.toRuntimeProcess("FirstMockProcess");
        MockProcess mockProcess2 = new MockProcess(0L);
        RuntimeProcess process2 = mockProcess2.toRuntimeProcess("SecondMockProcess");
        try {
            this.setPreference(DebugUIPlugin.getDefault().getPreferenceStore(), "org.eclipse.debug.ui.auto_remove_old_launches", true);
            TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsoleManager.class, 0L, 10000L);
            Job.getJobManager().suspend();
            launchManager.addLaunch(process1.getLaunch());
            launchManager.addLaunch(process2.getLaunch());
        }
        finally {
            Job.getJobManager().resume();
        }
        TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsoleManager.class, 0L, 10000L);
        ProcessConsoleManager processConsoleManager = DebugUIPlugin.getDefault().getProcessConsoleManager();
        ILaunch[] launches = launchManager.getLaunches();
        HashSet<IConsole> openConsoles = new HashSet<IConsole>();
        if (processConsoleManager.getConsole((IProcess)process1) != null) {
            openConsoles.add(processConsoleManager.getConsole((IProcess)process1));
        }
        if (processConsoleManager.getConsole((IProcess)process2) != null) {
            openConsoles.add(processConsoleManager.getConsole((IProcess)process2));
        }
        String launchesString = Stream.of(launches).map(launch -> Stream.of(launch.getProcesses()).map(IProcess::getLabel).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining());
        String consolesString = openConsoles.stream().map(IConsole::getName).collect(Collectors.joining());
        String failureMessage = String.format("ProcessConsoleManager and LaunchManager got out of sync.\nLaunches: %s\nConsoles: %s", launchesString, consolesString);
        ((AbstractCollectionAssert)Assertions.assertThat(openConsoles).as(failureMessage, new Object[0])).hasSameSizeAs((Object)launches);
        ConsoleRemoveAllTerminatedAction removeAction = new ConsoleRemoveAllTerminatedAction();
        if (launchManager.getLaunches().length != 0) {
            Assertions.assertThat((Object)removeAction).matches(Action::isEnabled, "is enabled");
        }
        removeAction.run();
        TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsoleManager.class, 0L, 10000L);
        Assert.assertNull((String)"First console not removed.", (Object)processConsoleManager.getConsole((IProcess)process1));
        Assert.assertNull((String)"Second console not removed.", (Object)processConsoleManager.getConsole((IProcess)process1));
    }
}

