/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.console.MockProcess;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessConsoleTests
extends AbstractDebugTest {
    private final List<IStatus> loggedErrors = Collections.synchronizedList(new ArrayList());
    private final ILogListener errorLogListener = (status, plugin) -> {
        if (status.matches(4)) {
            this.loggedErrors.add(status);
        }
    };
    private final ArrayList<File> tmpFiles = new ArrayList();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.loggedErrors.clear();
        Platform.addLogListener((ILogListener)this.errorLogListener);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Platform.removeLogListener((ILogListener)this.errorLogListener);
        for (File tmpFile : this.tmpFiles) {
            tmpFile.delete();
        }
        this.tmpFiles.clear();
        super.tearDown();
        ((ListAssert)Assertions.assertThat(this.errorsToStrings()).as("logged errors", new Object[0])).isEmpty();
    }

    private Stream<String> errorsToStrings() {
        return this.loggedErrors.stream().map(status -> status.toString() + ProcessConsoleTests.throwableToString(status.getException()));
    }

    private static String throwableToString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return System.lineSeparator() + "Stack trace: " + Stream.of(throwable.getStackTrace()).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    private File createTmpFile(String filename) throws IOException {
        File file = DebugUIPlugin.getDefault().getStateLocation().addTrailingSeparator().append(filename).toFile();
        boolean fileCreated = file.createNewFile();
        Assert.assertTrue((String)"Failed to prepare temporary test file.", (boolean)fileCreated);
        this.tmpFiles.add(file);
        return file;
    }

    @Test
    public void testUTF8InputEven() throws Exception {
        this.processConsoleUTF8Input("", 5000);
    }

    @Test
    public void testUTF8InputOdd() throws Exception {
        this.processConsoleUTF8Input("+", 5000);
    }

    public void processConsoleUTF8Input(String prefix, int numTwoByteCharacters) throws Exception {
        String input = prefix + String.join((CharSequence)"", Collections.nCopies(numTwoByteCharacters, "\u00f8"));
        MockProcess mockProcess = new MockProcess(input.getBytes(StandardCharsets.UTF_8).length, this.testTimeout);
        try {
            Launch launch = new Launch(null, "run", null);
            launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", StandardCharsets.UTF_8.toString());
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)mockProcess, (String)"testUtf8Input");
            ProcessConsole console = new ProcessConsole(process, (IConsoleColorProvider)new ConsoleColorProvider(), StandardCharsets.UTF_8.toString());
            try {
                console.initialize();
                IOConsoleInputStream consoleIn = console.getInputStream();
                consoleIn.appendData(input);
                mockProcess.waitFor(this.testTimeout, TimeUnit.MILLISECONDS);
            }
            finally {
                console.destroy();
            }
        }
        finally {
            mockProcess.destroy();
        }
        String receivedInput = new String(mockProcess.getReceivedInput(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)input, (Object)receivedInput);
    }

    @Test
    public void testInputReadJobCancel() throws Exception {
        MockProcess mockProcess = new MockProcess(-1L);
        try {
            RuntimeProcess process = mockProcess.toRuntimeProcess("testInputReadJobCancel");
            ProcessConsole console = new ProcessConsole((IProcess)process, (IConsoleColorProvider)new ConsoleColorProvider());
            try {
                console.initialize();
                Class<ProcessConsole> jobFamily = ProcessConsole.class;
                ((ObjectArrayAssert)Assertions.assertThat((Object[])Job.getJobManager().find(jobFamily)).as("check input read job started", new Object[0])).hasSizeGreaterThan(0);
                Job.getJobManager().cancel(jobFamily);
                TestUtil.waitForJobs(this.name.getMethodName(), ProcessConsole.class, 0L, 1000L);
                ((ObjectArrayAssert)Assertions.assertThat((Object[])Job.getJobManager().find(jobFamily)).as("check input read job is canceled", new Object[0])).isEmpty();
            }
            finally {
                console.destroy();
            }
        }
        finally {
            mockProcess.destroy();
        }
    }

    @Test
    public void testProcessTerminationNotification() throws Exception {
        TestUtil.log(1, this.name.getMethodName(), "Process terminates after Console is initialized.", new Throwable[0]);
        this.processTerminationTest(null, false);
        TestUtil.log(1, this.name.getMethodName(), "Process terminates before Console is initialized.", new Throwable[0]);
        this.processTerminationTest(null, true);
    }

    @Test
    public void testProcessTerminationNotificationWithInputFile() throws Exception {
        File inFile = DebugUIPlugin.getDefault().getStateLocation().addTrailingSeparator().append("testStdin.txt").toFile();
        boolean fileCreated = inFile.createNewFile();
        Assert.assertTrue((String)"Failed to prepare input file.", (boolean)fileCreated);
        try {
            ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.debug.tests.launch.type");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchType.newInstance(null, this.name.getMethodName());
            launchConfiguration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_STDIN_FILE", inFile.getAbsolutePath());
            TestUtil.log(1, this.name.getMethodName(), "Process terminates after Console is initialized.", new Throwable[0]);
            this.processTerminationTest((ILaunchConfiguration)launchConfiguration, false);
            TestUtil.log(1, this.name.getMethodName(), "Process terminates before Console is initialized.", new Throwable[0]);
            this.processTerminationTest((ILaunchConfiguration)launchConfiguration, true);
        }
        finally {
            inFile.delete();
        }
    }

    public void processTerminationTest(ILaunchConfiguration launchConfig, boolean terminateBeforeConsoleInitialization) throws Exception {
        AtomicBoolean terminationSignaled = new AtomicBoolean(false);
        MockProcess mockProcess = new MockProcess(null, null, terminateBeforeConsoleInitialization ? 0 : -1);
        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(launchConfig, "run", null), (Process)mockProcess, (String)this.name.getMethodName());
        ProcessConsole console = new ProcessConsole(process, (IConsoleColorProvider)new ConsoleColorProvider());
        console.addPropertyChangeListener(event -> {
            if (event.getSource() == console && IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE.equals(event.getProperty())) {
                terminationSignaled.set(true);
            }
        });
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        try {
            consoleManager.addConsoles(new IConsole[]{console});
            if (mockProcess.isAlive()) {
                ((Process)mockProcess).destroy();
            }
            this.waitWhile(__ -> !terminationSignaled.get(), 10000L, __ -> "No console complete notification received.");
        }
        catch (Throwable throwable) {
            consoleManager.removeConsoles(new IConsole[]{console});
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 0L, 10000L);
            throw throwable;
        }
        consoleManager.removeConsoles(new IConsole[]{console});
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 0L, 10000L);
    }

    @Test
    public void testRedirectOutputToFile() throws Exception {
        String testContent = "Hello World!";
        File outFile = this.createTmpFile("test.out");
        HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        this.doConsoleOutputTest("Hello World!".getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly("Hello World!".getBytes());
    }

    @Test
    public void testAppendOutputToFile() throws Exception {
        String testContent = "Hello World!";
        File outFile = this.createTmpFile("test-append.out");
        HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", true);
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true);
        this.doConsoleOutputTest("Hello World!".getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly("Hello World!".getBytes());
        String appendedContent = "append";
        this.doConsoleOutputTest(appendedContent.getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly(("Hello World!" + appendedContent).getBytes());
    }

    @Test
    public void testBug333239_regexSpecialCharactersInOutputFilename() throws Exception {
        String testContent = "1.\n2.\n3.\n";
        File outFile = this.createTmpFile("test.[out]");
        HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        IOConsole console = this.doConsoleOutputTest("1.\n2.\n3.\n".getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly("1.\n2.\n3.\n".getBytes());
        Assert.assertEquals((String)"Output in console.", (long)2L, (long)console.getDocument().getNumberOfLines());
        outFile = this.createTmpFile("exhaustive[128-32].out");
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
        console = this.doConsoleOutputTest("1.\n2.\n3.\n".getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly("1.\n2.\n3.\n".getBytes());
        Assert.assertEquals((String)"Output in console.", (long)2L, (long)console.getDocument().getNumberOfLines());
        outFile = this.createTmpFile("ug(ly.out");
        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
        console = this.doConsoleOutputTest("1.\n2.\n3.\n".getBytes(), launchConfigAttributes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])Files.readAllBytes(outFile.toPath())).as("content redirected to file", new Object[0])).containsExactly("1.\n2.\n3.\n".getBytes());
        Assert.assertEquals((String)"Output in console.", (long)2L, (long)console.getDocument().getNumberOfLines());
    }

    private IOConsole doConsoleOutputTest(byte[] testContent, Map<String, Object> launchConfigAttributes) throws Exception {
        ProcessConsole processConsole;
        MockProcess mockProcess = new MockProcess(new ByteArrayInputStream(testContent), null, -1L);
        RuntimeProcess process = mockProcess.toRuntimeProcess("Output Redirect", launchConfigAttributes);
        String encoding = launchConfigAttributes != null ? (String)launchConfigAttributes.get("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING") : null;
        AtomicBoolean consoleFinished = new AtomicBoolean(false);
        ProcessConsole console = new ProcessConsole((IProcess)process, (IConsoleColorProvider)new ConsoleColorProvider(), encoding);
        console.addPropertyChangeListener(event -> {
            if (event.getSource() == console && IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE.equals(event.getProperty())) {
                consoleFinished.set(true);
            }
        });
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        try {
            consoleManager.addConsoles(new IConsole[]{console});
            mockProcess.destroy();
            this.waitWhile(c -> !consoleFinished.get(), this.testTimeout, c -> "Console did not finished.");
            Object value = launchConfigAttributes != null ? launchConfigAttributes.get("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE") : null;
            File outFile = value != null ? new File((String)value) : null;
            value = launchConfigAttributes != null ? launchConfigAttributes.get("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON") : null;
            boolean checkOutput = value != null ? (Boolean)value : true;
            IDocument doc = console.getDocument();
            if (outFile != null) {
                String expectedPathMsg = MessageFormat.format(ConsoleMessages.ProcessConsole_1, outFile.getAbsolutePath());
                Assert.assertEquals((String)"No or wrong output of redirect file path in console.", (Object)expectedPathMsg, (Object)doc.get(doc.getLineOffset(0), doc.getLineLength(0)));
                ((ObjectArrayAssert)Assertions.assertThat((Object[])console.getHyperlinks()).as("check redirect file path is linked", new Object[0])).hasSize(1);
            }
            if (checkOutput) {
                Assert.assertEquals((String)"Output not found in console.", (Object)new String(testContent), (Object)doc.get(doc.getLineOffset(1), doc.getLineLength(1)));
            }
            processConsole = console;
        }
        catch (Throwable throwable) {
            if (!process.isTerminated()) {
                process.terminate();
            }
            consoleManager.removeConsoles(new IConsole[]{console});
            TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 0L, 1000L);
            throw throwable;
        }
        if (!process.isTerminated()) {
            process.terminate();
        }
        consoleManager.removeConsoles(new IConsole[]{console});
        TestUtil.waitForJobs(this.name.getMethodName(), "CONSOLE_JOB_FAMILY", 0L, 1000L);
        return processConsole;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testOutput() throws Exception {
        String[] lines = new String[]{"'Native' process started.", "'Eclipse' process started. Stream proxying started.", "Console created.", "Console initialized.", "Stopping mock process."};
        String consoleEncoding = StandardCharsets.UTF_8.name();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            PipedOutputStream procOut = new PipedOutputStream();
            try {
                try (PrintStream sysout = new PrintStream((OutputStream)procOut, true, consoleEncoding);){
                    MockProcess mockProcess = new MockProcess(new PipedInputStream(procOut), null, -1L);
                    sysout.println(lines[0]);
                    try {
                        HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
                        launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", consoleEncoding);
                        RuntimeProcess process = mockProcess.toRuntimeProcess("simpleOutput", launchConfigAttributes);
                        sysout.println(lines[1]);
                        ProcessConsole console = new ProcessConsole((IProcess)process, (IConsoleColorProvider)new ConsoleColorProvider(), consoleEncoding);
                        sysout.println(lines[2]);
                        try {
                            console.initialize();
                            sysout.println(lines[3]);
                            sysout.println(lines[4]);
                            mockProcess.destroy();
                            sysout.close();
                            Predicate<AbstractDebugTest> waitForLastLineWritten = __ -> {
                                try {
                                    TestUtil.processUIEvents(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return console.getDocument().getNumberOfLines() < lines.length;
                            };
                            Function<AbstractDebugTest, String> errorMessageProvider = __ -> {
                                String expected = String.join((CharSequence)System.lineSeparator(), lines);
                                String actual = console.getDocument().get();
                                return "Not all lines have been written, expected: " + expected + ", was: " + actual;
                            };
                            this.waitWhile(waitForLastLineWritten, this.testTimeout, errorMessageProvider);
                            int i = 0;
                            while (i < lines.length) {
                                IRegion lineInfo = console.getDocument().getLineInformation(i);
                                String line = console.getDocument().get(lineInfo.getOffset(), lineInfo.getLength());
                                Assert.assertEquals((String)("Wrong content in line " + i), (Object)lines[i], (Object)line);
                                ++i;
                            }
                        }
                        finally {
                            console.destroy();
                        }
                    }
                    finally {
                        mockProcess.destroy();
                    }
                }
                if (procOut == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (procOut == null) throw throwable;
                procOut.close();
                throw throwable;
            }
            procOut.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testBinaryOutputToFile() throws Exception {
        byte[] output = new byte[]{-84};
        String consoleEncoding = StandardCharsets.UTF_8.name();
        File outFile = this.createTmpFile("testoutput.bin");
        MockProcess mockProcess = new MockProcess(new ByteArrayInputStream(output), null, -1L);
        try {
            HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", consoleEncoding);
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", outFile.getCanonicalPath());
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            RuntimeProcess process = mockProcess.toRuntimeProcess("redirectBinaryOutput", launchConfigAttributes);
            ProcessConsole console = new ProcessConsole((IProcess)process, (IConsoleColorProvider)new ConsoleColorProvider(), consoleEncoding);
            try {
                console.initialize();
                Predicate<AbstractDebugTest> waitForFileWritten = __ -> {
                    try {
                        TestUtil.processUIEvents(20L);
                        return Files.readAllBytes(outFile.toPath()).length < output.length;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                };
                Function<AbstractDebugTest, String> errorMessageProvider = __ -> {
                    byte[] actualOutput = new byte[]{};
                    try {
                        actualOutput = Files.readAllBytes(outFile.toPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return "File has not been written, expected: " + Arrays.toString(output) + ", was: " + Arrays.toString(actualOutput);
                };
                this.waitWhile(waitForFileWritten, this.testTimeout, errorMessageProvider);
                mockProcess.destroy();
            }
            finally {
                console.destroy();
            }
        }
        finally {
            mockProcess.destroy();
        }
        byte[] receivedOutput = Files.readAllBytes(outFile.toPath());
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])receivedOutput).as("received output", new Object[0])).isEqualTo((Object)output);
    }

    @Test
    public void testBinaryInputFromFile() throws Exception {
        byte[] input = new byte[]{-84};
        String consoleEncoding = StandardCharsets.UTF_8.name();
        File inFile = this.createTmpFile("testinput.bin");
        Files.write(inFile.toPath(), input, new OpenOption[0]);
        MockProcess mockProcess = new MockProcess(input.length, this.testTimeout);
        try {
            HashMap<String, Object> launchConfigAttributes = new HashMap<String, Object>();
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", consoleEncoding);
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CAPTURE_STDIN_FILE", inFile.getCanonicalPath());
            launchConfigAttributes.put("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            RuntimeProcess process = mockProcess.toRuntimeProcess("redirectBinaryInput", launchConfigAttributes);
            ProcessConsole console = new ProcessConsole((IProcess)process, (IConsoleColorProvider)new ConsoleColorProvider(), consoleEncoding);
            try {
                console.initialize();
                mockProcess.waitFor(this.testTimeout, TimeUnit.MILLISECONDS);
            }
            finally {
                console.destroy();
            }
        }
        finally {
            mockProcess.destroy();
        }
        byte[] receivedInput = mockProcess.getReceivedInput();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])receivedInput).as("received input", new Object[0])).isEqualTo((Object)input);
    }
}

