/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.console.MockProcess;
import org.eclipse.debug.tests.console.MockProcessHandle;
import org.eclipse.debug.tests.sourcelookup.TestLaunch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RuntimeProcessTests
extends AbstractDebugTest {
    @Test
    public void testProcessTerminated() throws Exception {
        AtomicInteger processTerminateEvents = new AtomicInteger();
        DebugPlugin.getDefault().addDebugEventListener(events -> {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 8) {
                    processTerminateEvents.incrementAndGet();
                }
                ++n2;
            }
        });
        MockProcess mockProcess = new MockProcess(-1L);
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        Assert.assertFalse((String)"RuntimeProcess already terminated.", (boolean)runtimeProcess.isTerminated());
        Assert.assertTrue((boolean)runtimeProcess.canTerminate());
        mockProcess.setExitValue(1);
        mockProcess.destroy();
        TestUtil.waitWhile(p -> !p.isTerminated(), runtimeProcess, this.testTimeout, p -> "RuntimeProcess not terminated.");
        TestUtil.waitForJobs(this.name.getMethodName(), 25L, this.testTimeout, new Object[0]);
        Assert.assertEquals((String)"Wrong number of terminate events.", (long)1L, (long)processTerminateEvents.get());
        Assert.assertEquals((String)"RuntimeProcess reported wrong exit code.", (long)1L, (long)runtimeProcess.getExitValue());
    }

    @Test
    public void testTerminateProcess() throws Exception {
        AtomicInteger processTerminateEvents = new AtomicInteger();
        DebugPlugin.getDefault().addDebugEventListener(events -> {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                if (event.getKind() == 8) {
                    processTerminateEvents.incrementAndGet();
                }
                ++n2;
            }
        });
        MockProcess mockProcess = new MockProcess(-1L);
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        Assert.assertFalse((String)"RuntimeProcess already terminated.", (boolean)runtimeProcess.isTerminated());
        Assert.assertTrue((boolean)runtimeProcess.canTerminate());
        mockProcess.setExitValue(1);
        runtimeProcess.terminate();
        Assert.assertFalse((String)"RuntimeProcess failed to terminate wrapped process.", (boolean)mockProcess.isAlive());
        TestUtil.waitWhile(p -> !p.isTerminated(), runtimeProcess, this.testTimeout, p -> "RuntimeProcess not terminated.");
        TestUtil.waitForJobs(this.name.getMethodName(), 25L, this.testTimeout, new Object[0]);
        Assert.assertEquals((String)"Wrong number of terminate events.", (long)1L, (long)processTerminateEvents.get());
        Assert.assertEquals((String)"RuntimeProcess reported wrong exit code.", (long)1L, (long)runtimeProcess.getExitValue());
    }

    @Test
    public void testTerminateProcessWithSubProcesses() throws Exception {
        MockProcess grandChildProcess = new MockProcess(-1L);
        MockProcess childProcess1 = new MockProcess(-1L);
        childProcess1.setHandle(new MockProcessHandle(childProcess1, List.of(grandChildProcess)));
        MockProcess childProcess2 = new MockProcess(-1L);
        MockProcess mockProcess = new MockProcess(-1L);
        mockProcess.setHandle(new MockProcessHandle(childProcess1, List.of(childProcess1, childProcess2)));
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        Assert.assertTrue((String)"RuntimeProcess already terminated.", (boolean)grandChildProcess.isAlive());
        Assert.assertTrue((String)"RuntimeProcess already terminated.", (boolean)childProcess1.isAlive());
        Assert.assertTrue((String)"RuntimeProcess already terminated.", (boolean)childProcess2.isAlive());
        Assert.assertFalse((String)"RuntimeProcess already terminated.", (boolean)runtimeProcess.isTerminated());
        runtimeProcess.terminate();
        Assert.assertFalse((String)"RuntimeProcess failed to terminate wrapped process.", (boolean)mockProcess.isAlive());
        Assert.assertFalse((String)"RuntimeProcess failed to terminate child of wrapped process.", (boolean)childProcess1.isAlive());
        Assert.assertFalse((String)"RuntimeProcess failed to terminate child of wrapped process.", (boolean)childProcess2.isAlive());
        Assert.assertFalse((String)"RuntimeProcess failed to terminate descendant of wrapped process.", (boolean)grandChildProcess.isAlive());
        TestUtil.waitWhile(p -> !p.isTerminated(), runtimeProcess, this.testTimeout, p -> "RuntimeProcess not terminated.");
    }

    @Test
    public void testTerminateProcessWithoutTerminatingDescendents() throws Exception {
        MockProcess childProcess = new MockProcess(-1L);
        MockProcess mockProcess = new MockProcess(-1L);
        mockProcess.setHandle(new MockProcessHandle(mockProcess, List.of(childProcess)));
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess("MockProcess", Map.of("org.eclipse.debug.core.TERMINATE_DESCENDANTS", false));
        Assert.assertTrue((String)"RuntimeProcess already terminated.", (boolean)childProcess.isAlive());
        Assert.assertFalse((String)"RuntimeProcess already terminated.", (boolean)runtimeProcess.isTerminated());
        runtimeProcess.terminate();
        Assert.assertFalse((String)"RuntimeProcess failed to terminate wrapped process.", (boolean)mockProcess.isAlive());
        Assert.assertTrue((String)"RuntimeProcess terminated child of wrapped process, unlike configured.", (boolean)childProcess.isAlive());
        TestUtil.waitWhile(p -> !p.isTerminated(), runtimeProcess, this.testTimeout, p -> "RuntimeProcess not terminated.");
    }

    @Test
    public void testTerminateProcessNotSupportingProcessToHandle() throws Exception {
        MockProcess mockProcess = new MockProcess(-1L);
        mockProcess.setHandle(null);
        Assert.assertThrows(UnsupportedOperationException.class, mockProcess::toHandle);
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        runtimeProcess.terminate();
        TestUtil.waitWhile(p -> !p.isTerminated(), runtimeProcess, this.testTimeout, p -> "RuntimeProcess not terminated.");
    }

    @Test
    public void testTerminateProcessWithTimeoutExeedingTermination() {
        MockProcess mockProcess = new MockProcess(-1L);
        mockProcess.setTerminationDelay(6000);
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        DebugException timeoutException = (DebugException)Assert.assertThrows(DebugException.class, () -> ((RuntimeProcess)runtimeProcess).terminate());
        Assert.assertEquals((Object)DebugCoreMessages.RuntimeProcess_terminate_failed, (Object)timeoutException.getMessage());
    }

    @Test
    public void testTerminateProcessWithDescendentExceedingTimeoutForTermination() {
        MockProcess childProcess = new MockProcess(-1L);
        childProcess.setTerminationDelay(6000);
        MockProcess mockProcess = new MockProcess(-1L);
        mockProcess.setHandle(new MockProcessHandle(mockProcess, List.of(childProcess)));
        RuntimeProcess runtimeProcess = mockProcess.toRuntimeProcess();
        DebugException timeoutException = (DebugException)Assert.assertThrows(DebugException.class, () -> ((RuntimeProcess)runtimeProcess).terminate());
        Assert.assertEquals((Object)DebugCoreMessages.RuntimeProcess_terminate_failed, (Object)timeoutException.getMessage());
    }

    @Test
    @Ignore(value="See https://bugs.eclipse.org/bugs/show_bug.cgi?id=577189")
    public void testOutputAfterDestroy() throws Exception {
        MockProcess proc = new MockProcess();
        RuntimeProcess iProc = new RuntimeProcess((ILaunch)new TestLaunch(), (Process)proc, "foo", Collections.emptyMap());
        iProc.terminate();
        String str = iProc.getStreamsProxy().getOutputStreamMonitor().getContents();
        TestUtil.log(1, this.name.getMethodName(), "Stream result: ", new Throwable[0]);
        int i = 0;
        while (i < str.length()) {
            TestUtil.log(1, this.name.getMethodName(), str.substring(i, Math.min(i + 100, str.length())), new Throwable[0]);
            i += 100;
        }
        TestUtil.log(1, this.name.getMethodName(), "Stream done.", new Throwable[0]);
        InputStream inputStream = proc.getInputStream();
        Assert.assertEquals((long)-1L, (long)inputStream.read());
        Assert.assertTrue((boolean)str.endsWith(String.valueOf((char)MockProcess.ProcessState.LASTREAD.getCode())));
    }
}

