/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.console.MockProcess;
import org.junit.Assert;
import org.junit.Test;

public class StreamsProxyTests
extends AbstractDebugTest {
    @Test
    public void testReceiveUTF8Even() throws Exception {
        this.receiveUTF8Test("", 4500);
    }

    @Test
    public void testReceiveUTF8Odd() throws Exception {
        this.receiveUTF8Test("+", 4500);
    }

    private void receiveUTF8Test(String prefix, int numTwoByteCharacters) throws Exception {
        String s = prefix + String.join((CharSequence)"", Collections.nCopies(numTwoByteCharacters, "\u00f8"));
        ByteArrayInputStream stdout = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        MockProcess mockProcess = new MockProcess(stdout, null, 0L);
        StreamsProxy streamProxy = new StreamsProxy((Process)mockProcess, StandardCharsets.UTF_8, "");
        streamProxy.close();
        String readContent = streamProxy.getOutputStreamMonitor().getContents();
        Assert.assertEquals((String)"Process output got corrupted.", (Object)s, (Object)readContent);
    }
}

