/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.console;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.TextConsoleViewer;
import org.junit.Assert;
import org.junit.Test;

public class TextConsoleViewerTest
extends AbstractDebugTest {
    @Test
    public void testStyleOverride() throws Throwable {
        Color colorR = null;
        Color colorG = null;
        Color colorB = null;
        Color colorK = null;
        Color colorW = null;
        try {
            Method method = TextConsoleViewer.class.getDeclaredMethod("overrideStyleRange", List.class, StyleRange.class);
            method.setAccessible(true);
            Assert.assertTrue((String)("Required method <" + String.valueOf(method) + "> is not static."), (boolean)Modifier.isStatic(method.getModifiers()));
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
            colorR = new Color(null, 255, 0, 0);
            colorG = new Color(null, 0, 255, 0);
            colorB = new Color(null, 0, 0, 255);
            colorK = new Color(null, 0, 0, 0);
            colorW = new Color(null, 255, 255, 255);
            method.invoke(null, styles, new StyleRange(5, 5, colorR, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 2, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 13, null);
            method.invoke(null, styles, new StyleRange(0, 3, colorG, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 3, colorG);
            TextConsoleViewerTest.assertStyle(styles, 3, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 13, null);
            method.invoke(null, styles, new StyleRange(15, 5, colorB, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 3, colorG);
            TextConsoleViewerTest.assertStyle(styles, 3, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, null);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            method.invoke(null, styles, new StyleRange(0, 3, colorK, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 3, colorK);
            TextConsoleViewerTest.assertStyle(styles, 3, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, null);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            method.invoke(null, styles, new StyleRange(0, 4, colorW, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 4, colorW);
            TextConsoleViewerTest.assertStyle(styles, 4, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, null);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            method.invoke(null, styles, new StyleRange(0, 2, colorK, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 2, colorK);
            TextConsoleViewerTest.assertStyle(styles, 2, 4, colorW);
            TextConsoleViewerTest.assertStyle(styles, 4, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, null);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            method.invoke(null, styles, new StyleRange(13, 7, colorW, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 2, colorK);
            TextConsoleViewerTest.assertStyle(styles, 2, 4, colorW);
            TextConsoleViewerTest.assertStyle(styles, 4, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 13, null);
            TextConsoleViewerTest.assertStyle(styles, 13, 20, colorW);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            method.invoke(null, styles, new StyleRange(15, 5, colorK, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 2, colorK);
            TextConsoleViewerTest.assertStyle(styles, 2, 4, colorW);
            TextConsoleViewerTest.assertStyle(styles, 4, 5, null);
            TextConsoleViewerTest.assertStyle(styles, 5, 10, colorR);
            TextConsoleViewerTest.assertStyle(styles, 10, 13, null);
            TextConsoleViewerTest.assertStyle(styles, 13, 15, colorW);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorK);
            TextConsoleViewerTest.assertStyle(styles, 20, 23, null);
            styles.clear();
            method.invoke(null, styles, new StyleRange(10, 10, colorW, null));
            TextConsoleViewerTest.assertStyle(styles, 10, 20, colorW);
            method.invoke(null, styles, new StyleRange(10, 10, colorK, null));
            TextConsoleViewerTest.assertStyle(styles, 10, 20, colorK);
            Assert.assertEquals((String)"Wrong number of styles.", (long)1L, (long)styles.size());
            method.invoke(null, styles, new StyleRange(5, 15, colorR, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 5, 20, colorR);
            method.invoke(null, styles, new StyleRange(0, 10, colorG, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 10, colorG);
            TextConsoleViewerTest.assertStyle(styles, 10, 20, colorR);
            method.invoke(null, styles, new StyleRange(15, 10, colorB, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 10, colorG);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, colorR);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            method.invoke(null, styles, new StyleRange(6, 1, colorW, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 6, colorG);
            TextConsoleViewerTest.assertStyle(styles, 6, 7, colorW);
            TextConsoleViewerTest.assertStyle(styles, 7, 10, colorG);
            TextConsoleViewerTest.assertStyle(styles, 10, 15, colorR);
            TextConsoleViewerTest.assertStyle(styles, 15, 20, colorB);
            method.invoke(null, styles, new StyleRange(0, 25, colorK, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 25, colorK);
            TextConsoleViewerTest.assertStyle(styles, 25, 30, null);
            styles.clear();
            styles.add(new StyleRange(0, 10, colorR, null));
            styles.add(new StyleRange(15, 5, colorG, null));
            method.invoke(null, styles, new StyleRange(7, 11, colorB, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 7, colorR);
            TextConsoleViewerTest.assertStyle(styles, 7, 18, colorB);
            TextConsoleViewerTest.assertStyle(styles, 18, 20, colorG);
            TextConsoleViewerTest.assertStyle(styles, 20, 25, null);
            styles.clear();
            styles.add(new StyleRange(0, 10, colorR, null));
            styles.add(new StyleRange(15, 5, colorG, null));
            method.invoke(null, styles, new StyleRange(7, 15, colorB, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 7, colorR);
            TextConsoleViewerTest.assertStyle(styles, 7, 22, colorB);
            TextConsoleViewerTest.assertStyle(styles, 22, 25, null);
            styles.clear();
            styles.add(new StyleRange(5, 5, colorR, null));
            styles.add(new StyleRange(15, 5, colorG, null));
            method.invoke(null, styles, new StyleRange(2, 15, colorB, null));
            TextConsoleViewerTest.checkOverlapping(styles);
            TextConsoleViewerTest.assertStyle(styles, 0, 2, null);
            TextConsoleViewerTest.assertStyle(styles, 2, 17, colorB);
            TextConsoleViewerTest.assertStyle(styles, 17, 20, colorG);
            TextConsoleViewerTest.assertStyle(styles, 20, 25, null);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static void assertStyle(List<StyleRange> styles, int offset, int end, Color foregroundColor) {
        int o = offset;
        while (o < end) {
            StyleRange expected = foregroundColor != null ? new StyleRange(0, 0, foregroundColor, null) : null;
            StyleRange actual = TextConsoleViewerTest.getStyleAtOffset(styles, o);
            Assert.assertEquals((String)("Got wrong style at offset " + o), (Object)TextConsoleViewerTest.generalizeStyle(expected), (Object)TextConsoleViewerTest.generalizeStyle(actual));
            int step = actual != null ? actual.length : 1;
            o += Math.min(step, 1);
        }
    }

    private static StyleRange getStyleAtOffset(List<StyleRange> styles, int offset) {
        if (styles != null) {
            for (StyleRange style : styles) {
                if (style.start > offset || style.start + style.length < offset + 1) continue;
                return style;
            }
        }
        return null;
    }

    private static StyleRange generalizeStyle(StyleRange style) {
        if (style == null) {
            return new StyleRange();
        }
        StyleRange copy = (StyleRange)style.clone();
        copy.length = 0;
        copy.start = 0;
        return copy;
    }

    private static void checkOverlapping(List<StyleRange> styles) {
        if (styles == null || styles.size() <= 1) {
            return;
        }
        int lastEnd = Integer.MIN_VALUE;
        for (StyleRange s : styles) {
            Assert.assertTrue((String)"Styles overlap or not sorted.", (lastEnd <= s.start ? 1 : 0) != 0);
            Assert.assertTrue((String)"Empty style.", (s.length > 0 ? 1 : 0) != 0);
            lastEnd = s.start + s.length;
        }
    }
}

