/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.IExpressionsListener2;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionManagerTests
extends AbstractDebugTest {
    protected IExpressionManager getManager() {
        return DebugPlugin.getDefault().getExpressionManager();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getManager().removeExpressions(this.getManager().getExpressions());
        super.tearDown();
    }

    @Test
    public void testAddExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp2, exp3});
            Assert.assertEquals((long)single.addedCallbacks, (long)3L);
            Assert.assertEquals((long)3L, (long)single.added.size());
            Assert.assertEquals((long)0L, (long)single.added.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)single.added.indexOf(exp2));
            Assert.assertEquals((long)2L, (long)single.added.indexOf(exp3));
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)1L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    @Test
    public void testRemoveExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            manager.removeExpressions(new IExpression[]{exp1, exp3});
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp2});
            Assert.assertEquals((long)single.addedCallbacks, (long)3L);
            Assert.assertEquals((long)3L, (long)single.added.size());
            Assert.assertEquals((long)0L, (long)single.added.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)single.added.indexOf(exp2));
            Assert.assertEquals((long)2L, (long)single.added.indexOf(exp3));
            Assert.assertEquals((long)2L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.removed.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)single.removed.indexOf(exp3));
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)1L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)1L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.removed.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)multi.removed.indexOf(exp3));
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    @Test
    public void testChangeExpressions() {
        IExpressionManager manager = this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        manager.addExpressionListener((IExpressionListener)single);
        manager.addExpressionListener((IExpressionsListener)multi);
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            Object[] expressions = manager.getExpressions();
            exp1.setEnabled(false);
            exp2.setExpressionText("exp2changed");
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp2, exp3});
            Assert.assertEquals((long)single.addedCallbacks, (long)3L);
            Assert.assertEquals((long)3L, (long)single.added.size());
            Assert.assertEquals((long)0L, (long)single.added.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)single.added.indexOf(exp2));
            Assert.assertEquals((long)2L, (long)single.added.indexOf(exp3));
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)2L, (long)single.changedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changed.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)single.changed.indexOf(exp2));
            Assert.assertEquals((long)1L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)2L, (long)multi.changedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changed.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)multi.changed.indexOf(exp2));
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
        }
    }

    @Test
    public void testInsertBeforeExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp2, exp3});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.insertExpressions(new IExpression[]{exp4, exp5}, (IExpression)exp2, true);
            Assert.assertEquals((long)2L, (long)single.addedCallbacks);
            Assert.assertEquals((long)2L, (long)single.added.size());
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)1L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)2L, (long)multi.added.size());
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
            Assert.assertEquals((long)1L, (long)insert.insertedCallbacks);
            Assert.assertEquals((long)1L, (long)insert.insertIndex);
            Assert.assertEquals((long)0L, (long)insert.movedCallbacks);
            Assert.assertEquals((long)2L, (long)insert.inserted.size());
            Assert.assertEquals((long)0L, (long)insert.inserted.indexOf(exp4));
            Assert.assertEquals((long)1L, (long)insert.inserted.indexOf(exp5));
            expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp4, exp5, exp2, exp3});
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    @Test
    public void testInsertAfterExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3});
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp2, exp3});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.insertExpressions(new IExpression[]{exp4, exp5}, (IExpression)exp2, false);
            Assert.assertEquals((long)2L, (long)single.addedCallbacks);
            Assert.assertEquals((long)2L, (long)single.added.size());
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)1L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)2L, (long)multi.added.size());
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
            Assert.assertEquals((long)1L, (long)insert.insertedCallbacks);
            Assert.assertEquals((long)2L, (long)insert.insertIndex);
            Assert.assertEquals((long)0L, (long)insert.movedCallbacks);
            Assert.assertEquals((long)2L, (long)insert.inserted.size());
            Assert.assertEquals((long)0L, (long)insert.inserted.indexOf(exp4));
            Assert.assertEquals((long)1L, (long)insert.inserted.indexOf(exp5));
            expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp1, exp2, exp4, exp5, exp3});
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    @Test
    public void testMoveBeforeExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.moveExpressions(new IExpression[]{exp1, exp2}, (IExpression)exp5, true);
            Assert.assertEquals((long)0L, (long)single.addedCallbacks);
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
            Assert.assertEquals((long)0L, (long)insert.insertedCallbacks);
            Assert.assertEquals((long)1L, (long)insert.movedCallbacks);
            Assert.assertEquals((long)2L, (long)insert.moved.size());
            Assert.assertEquals((long)0L, (long)insert.moved.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)insert.moved.indexOf(exp2));
            Assert.assertEquals((long)2L, (long)insert.insertIndex);
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp3, exp4, exp1, exp2, exp5});
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    @Test
    public void testMoveAfterExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        SinlgeListener single = new SinlgeListener();
        MultiListener multi = new MultiListener();
        InsertMoveListener insert = new InsertMoveListener();
        try {
            IWatchExpression exp1 = manager.newWatchExpression("exp1");
            IWatchExpression exp2 = manager.newWatchExpression("exp2");
            IWatchExpression exp3 = manager.newWatchExpression("exp3");
            IWatchExpression exp4 = manager.newWatchExpression("exp4");
            IWatchExpression exp5 = manager.newWatchExpression("exp5");
            manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
            manager.addExpressionListener((IExpressionListener)single);
            manager.addExpressionListener((IExpressionsListener)multi);
            manager.addExpressionListener((IExpressionsListener)insert);
            manager.moveExpressions(new IExpression[]{exp1, exp2}, (IExpression)exp3, false);
            Assert.assertEquals((long)0L, (long)single.addedCallbacks);
            Assert.assertEquals((long)0L, (long)single.removedCallbacks);
            Assert.assertEquals((long)0L, (long)single.changedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.addedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.removedCallbacks);
            Assert.assertEquals((long)0L, (long)multi.changedCallbacks);
            Assert.assertEquals((long)0L, (long)insert.insertedCallbacks);
            Assert.assertEquals((long)1L, (long)insert.movedCallbacks);
            Assert.assertEquals((long)2L, (long)insert.moved.size());
            Assert.assertEquals((long)0L, (long)insert.moved.indexOf(exp1));
            Assert.assertEquals((long)1L, (long)insert.moved.indexOf(exp2));
            Assert.assertEquals((long)1L, (long)insert.insertIndex);
            Object[] expressions = manager.getExpressions();
            Assertions.assertThat((Object[])expressions).containsExactly((Object[])new IExpression[]{exp3, exp1, exp2, exp4, exp5});
        }
        finally {
            manager.removeExpressionListener((IExpressionListener)single);
            manager.removeExpressionListener((IExpressionsListener)multi);
            manager.removeExpressionListener((IExpressionsListener)insert);
        }
    }

    @Test
    public void testPersistExpressions() {
        ExpressionManager manager = (ExpressionManager)this.getManager();
        IWatchExpression exp1 = manager.newWatchExpression("exp1");
        IWatchExpression exp2 = manager.newWatchExpression("exp2");
        IWatchExpression exp3 = manager.newWatchExpression("exp3");
        IWatchExpression exp4 = manager.newWatchExpression("exp4");
        IWatchExpression exp5 = manager.newWatchExpression("exp5");
        manager.addExpressions(new IExpression[]{exp1, exp2, exp3, exp4, exp5});
        manager.storeWatchExpressions();
        ExpressionManager manager2 = new ExpressionManager();
        Object[] expressions = manager2.getExpressions();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])expressions).hasSize(5)).extracting(IExpression::getExpressionText).containsExactly((Object[])new String[]{"exp1", "exp2", "exp3", "exp4", "exp5"});
    }

    @Test
    public void testConcurrentAccess() throws InterruptedException {
        boolean[] done = new boolean[1];
        Exception[] ex = new Exception[1];
        Runnable add = () -> {
            try {
                int i = 0;
                while (i < 1000) {
                    this.getManager().addExpression((IExpression)this.getManager().newWatchExpression(Integer.toHexString(i)));
                    ++i;
                }
                blArray[0] = true;
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        };
        Runnable remove = () -> {
            try {
                do {
                    this.getManager().removeExpressions(this.getManager().getExpressions());
                } while (!done[0] || this.getManager().getExpressions().length > 0);
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        };
        Thread t1 = new Thread(add);
        Thread t2 = new Thread(remove);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assertions.assertThat((Object[])this.getManager().getExpressions()).isEmpty();
        Assert.assertNull((Object)ex[0]);
    }

    static class InsertMoveListener
    extends MultiListener
    implements IExpressionsListener2 {
        List<IExpression> moved = new ArrayList<IExpression>();
        List<IExpression> inserted = new ArrayList<IExpression>();
        int insertIndex = -1;
        int movedCallbacks = 0;
        int insertedCallbacks = 0;

        InsertMoveListener() {
        }

        public void expressionsMoved(IExpression[] expressions, int index) {
            Collections.addAll(this.moved, expressions);
            ++this.movedCallbacks;
            this.insertIndex = index;
        }

        public void expressionsInserted(IExpression[] expressions, int index) {
            Collections.addAll(this.inserted, expressions);
            ++this.insertedCallbacks;
            this.insertIndex = index;
        }
    }

    static class MultiListener
    implements IExpressionsListener {
        List<IExpression> added = new ArrayList<IExpression>();
        List<IExpression> removed = new ArrayList<IExpression>();
        List<IExpression> changed = new ArrayList<IExpression>();
        int addedCallbacks = 0;
        int removedCallbacks = 0;
        int changedCallbacks = 0;

        MultiListener() {
        }

        public void expressionsAdded(IExpression[] expressions) {
            Collections.addAll(this.added, expressions);
            ++this.addedCallbacks;
        }

        public void expressionsRemoved(IExpression[] expressions) {
            Collections.addAll(this.removed, expressions);
            ++this.removedCallbacks;
        }

        public void expressionsChanged(IExpression[] expressions) {
            Collections.addAll(this.changed, expressions);
            ++this.changedCallbacks;
        }
    }

    static class SinlgeListener
    implements IExpressionListener {
        List<IExpression> added = new ArrayList<IExpression>();
        List<IExpression> removed = new ArrayList<IExpression>();
        List<IExpression> changed = new ArrayList<IExpression>();
        int addedCallbacks = 0;
        int removedCallbacks = 0;
        int changedCallbacks = 0;

        SinlgeListener() {
        }

        public void expressionAdded(IExpression expression) {
            this.added.add(expression);
            ++this.addedCallbacks;
        }

        public void expressionRemoved(IExpression expression) {
            this.removed.add(expression);
            ++this.removedCallbacks;
        }

        public void expressionChanged(IExpression expression) {
            this.changed.add(expression);
            ++this.changedCallbacks;
        }
    }
}

