/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.launching.ArgumentsPrinter;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentParsingTests
extends AbstractDebugTest {
    private void execute1Arg(String cmdLine) throws Exception {
        this.execute1Arg(cmdLine, cmdLine);
    }

    private void execute1Arg(String cmdLine, String argParsed) throws Exception {
        this.execute1Arg(cmdLine, argParsed, cmdLine);
    }

    private void execute1Arg(String cmdLine, String argParsed, String rendered) throws Exception {
        ArgumentParsingTests.execute("a " + cmdLine + " b", new String[]{"a", argParsed, "b"}, "a " + rendered + " b");
    }

    private static void execute(String commandLine, String[] expectedArgs) throws Exception {
        ArgumentParsingTests.execute(commandLine, expectedArgs, commandLine);
    }

    private static void execute(String commandLine, String[] expectedArgs, String expectedRendered) throws Exception {
        String[] arguments = DebugPlugin.parseArguments((String)commandLine);
        Assert.assertEquals((String)"unexpected parseArguments result;", (Object)Arrays.asList(expectedArgs).toString(), (Object)Arrays.asList(arguments).toString());
        ArgumentParsingTests.runCommandLine(commandLine, arguments);
        String rendered = DebugPlugin.renderArguments((String[])arguments, null);
        Assert.assertEquals((String)"unexpected renderArguments result;", (Object)expectedRendered, (Object)rendered);
        if (!commandLine.equals(rendered)) {
            String[] arguments2 = DebugPlugin.parseArguments((String)rendered);
            Assert.assertEquals((String)"parsing rendered command line doesn't yield original arguments;", (Object)Arrays.asList(expectedArgs).toString(), (Object)Arrays.asList(arguments2).toString());
        }
        Object[] splitArguments = DebugPlugin.splitArguments((String)commandLine);
        Assertions.assertThat((Object[])splitArguments).hasSameSizeAs((Object)expectedArgs);
        String sb = String.join((CharSequence)" ", (CharSequence[])splitArguments);
        Assert.assertEquals((Object)commandLine, (Object)sb);
    }

    private static void runCommandLine(String commandLine, String[] arguments) throws IOException, URISyntaxException, CoreException {
        URL classPathUrl = ArgumentsPrinter.class.getResource("/");
        classPathUrl = FileLocator.toFileURL((URL)classPathUrl);
        File classPathFile = URIUtil.toFile((URI)URIUtil.toURI((URL)classPathUrl));
        String[] execArgs = new String[arguments.length + 4];
        execArgs[0] = IPath.fromOSString((String)System.getProperty("java.home")).append("bin/java").toOSString();
        execArgs[1] = "-cp";
        execArgs[2] = classPathFile.getAbsolutePath();
        execArgs[3] = ArgumentsPrinter.class.getName();
        System.arraycopy(arguments, 0, execArgs, 4, arguments.length);
        ArrayList<String> resultArgs = ArgumentParsingTests.runCommandLine(execArgs);
        Assert.assertEquals((String)"unexpected exec result;", (Object)Arrays.asList(arguments).toString(), (Object)resultArgs.toString());
        if (!Platform.getOS().equals("win32")) {
            execArgs = new String[]{"sh", "-c", execArgs[0] + " " + execArgs[1] + " " + execArgs[2] + " " + execArgs[3] + " " + commandLine};
            resultArgs = ArgumentParsingTests.runCommandLine(execArgs);
            Assert.assertEquals((String)"unexpected sh exec result;", (Object)Arrays.asList(arguments).toString(), (Object)resultArgs.toString());
        }
    }

    private static ArrayList<String> runCommandLine(String[] execArgs) throws CoreException, IOException {
        String procArg;
        String[] systemDependentExecArgs = ArgumentParsingTests.quoteWindowsArgs(execArgs);
        Process process = DebugPlugin.exec((String[])systemDependentExecArgs, null);
        BufferedReader procOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<String> procArgs = new ArrayList<String>();
        while ((procArg = procOut.readLine()) != null) {
            procArgs.add(procArg);
        }
        return procArgs;
    }

    private static String[] quoteWindowsArgs(String[] cmdLine) {
        String[] systemDependentCmdLine = cmdLine;
        if (Platform.getOS().equals("win32")) {
            String[] winCmdLine = new String[cmdLine.length];
            int i = 0;
            while (i < cmdLine.length) {
                winCmdLine[i] = ArgumentParsingTests.winQuote(cmdLine[i]);
                ++i;
            }
            systemDependentCmdLine = winCmdLine;
        }
        return systemDependentCmdLine;
    }

    private static boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String winQuote(String s) {
        if (!ArgumentParsingTests.needsQuoting(s)) {
            return s;
        }
        return "\"" + s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"").replaceAll("([\\\\]*)\\z", "$1$1") + "\"";
    }

    @Test
    public void testEmpty() throws Exception {
        ArgumentParsingTests.execute("", new String[0]);
    }

    @Test
    public void test1arg() throws Exception {
        ArgumentParsingTests.execute("a", new String[]{"a"});
    }

    @Test
    public void test2arg() throws Exception {
        ArgumentParsingTests.execute("a b", new String[]{"a", "b"});
    }

    @Test
    public void test100arg() throws Exception {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < 100) {
            buf.append("a ");
            ++i;
        }
        buf.deleteCharAt(buf.length() - 1);
        Object[] args = new String[100];
        Arrays.fill(args, "a");
        ArgumentParsingTests.execute(buf.toString(), (String[])args, buf.toString().trim());
    }

    @Test
    public void testEscape() throws Exception {
        if (Platform.getOS().equals("win32")) {
            this.execute1Arg("\\1");
        } else {
            this.execute1Arg("\\1", "1", "1");
        }
    }

    @Test
    public void testRenderWindowsBackslash() throws Exception {
        String[] arguments = new String[]{"-Dfoo=\"abc\\def\\ghi\""};
        String rendered = DebugPlugin.renderArguments((String[])arguments, null);
        if (Platform.getOS().equals("win32")) {
            Assert.assertEquals((String)"unexpected renderArguments result;", (Object)"-Dfoo=\\\"abc\\def\\ghi\\\"", (Object)rendered);
        } else {
            Assert.assertEquals((String)"unexpected renderArguments result;", (Object)"-Dfoo=\\\"abc\\\\def\\\\ghi\\\"", (Object)rendered);
        }
    }

    @Test
    public void testEscapeDoubleQuote1() throws Exception {
        this.execute1Arg("\\\"", "\"", "\\\"");
    }

    @Test
    public void testEscapeDoubleQuote2() throws Exception {
        this.execute1Arg("arg=\\\"bla\\\"", "arg=\"bla\"", "arg=\\\"bla\\\"");
    }

    @Test
    public void testDoubleQuoted1() throws Exception {
        this.execute1Arg("\"1 2\"", "1 2");
    }

    @Test
    public void testDoubleQuoted2() throws Exception {
        this.execute1Arg("\"1\"", "1", "1");
    }

    @Test
    public void testDoubleQuoted3() throws Exception {
        if (Platform.getOS().equals("win32")) {
            this.execute1Arg("\"\"");
        } else {
            this.execute1Arg("\"\"", "", "\"\"");
        }
    }

    @Test
    public void testDoubleQuoted4() throws Exception {
        if (Platform.getOS().equals("win32")) {
            this.execute1Arg("\"\"\"\"", "\"", "\\\"");
        } else {
            this.execute1Arg("\"\"\"\"", "", "\"\"");
        }
    }

    @Test
    public void testDoubleQuoted5() throws Exception {
        this.execute1Arg("ab\"cd\"ef\"gh\"", "abcdefgh", "abcdefgh");
    }

    @Test
    public void testDoubleQuotedWithSpace1() throws Exception {
        if (Platform.getOS().equals("win32")) {
            this.execute1Arg("\"\"\"1\"\" 2\"", "\"1\" 2", "\"\\\"1\\\" 2\"");
        } else {
            this.execute1Arg("\"\"\"1\"\" 2\"", "1 2", "\"1 2\"");
        }
    }

    @Test
    public void testDoubleQuotedWithSpace2() throws Exception {
        this.execute1Arg("\"\\\"1\\\" 2\"", "\"1\" 2");
    }

    @Test
    public void testSingleQuoted1() throws Exception {
        if (Platform.getOS().equals("win32")) {
            ArgumentParsingTests.execute("'1 2'", new String[]{"'1", "2'"});
        } else {
            ArgumentParsingTests.execute("'1 2'", new String[]{"1 2"}, "\"1 2\"");
        }
    }

    @Test
    public void testSingleQuoted2() throws Exception {
        if (Platform.getOS().equals("win32")) {
            this.execute1Arg("'1'", "'1'", "'1'");
        } else {
            this.execute1Arg("'1'", "1", "1");
        }
    }

    @Test
    public void testWindows1() throws Exception {
        ArgumentParsingTests.execute("\"a b c\" d e", new String[]{"a b c", "d", "e"});
    }

    @Test
    public void testWindows2() throws Exception {
        if (Platform.getOS().equals("win32")) {
            ArgumentParsingTests.execute("\"ab\\\"c\" \"\\\\\" d", new String[]{"ab\"c", "\\", "d"}, "ab\\\"c \\ d");
        } else {
            ArgumentParsingTests.execute("\"ab\\\"c\" \"\\\\\" d", new String[]{"ab\"c", "\\", "d"}, "ab\\\"c \\\\ d");
        }
    }

    @Test
    public void testWindows3() throws Exception {
        if (Platform.getOS().equals("win32")) {
            ArgumentParsingTests.execute("a\\\\\\b d\"e f\"g h", new String[]{"a\\\\\\b", "de fg", "h"}, "a\\\\\\b \"de fg\" h");
        } else {
            ArgumentParsingTests.execute("a\\\\\\b d\"e f\"g h", new String[]{"a\\b", "de fg", "h"}, "a\\\\b \"de fg\" h");
        }
    }

    @Test
    public void testWindows4() throws Exception {
        ArgumentParsingTests.execute("a\\\\\\\"b c d", new String[]{"a\\\"b", "c", "d"});
    }

    @Test
    public void testWindows5() throws Exception {
        if (Platform.getOS().equals("win32")) {
            ArgumentParsingTests.execute("a\\\\\\\\\"b c\" d e", new String[]{"a\\\\b c", "d", "e"}, "\"a\\\\b c\" d e");
        } else {
            ArgumentParsingTests.execute("a\\\\\\\\\"b c\" d e", new String[]{"a\\\\b c", "d", "e"}, "\"a\\\\\\\\b c\" d e");
        }
    }

    @Test
    public void testAllInOne() throws Exception {
        if (Platform.getOS().equals("win32")) {
            ArgumentParsingTests.execute("1 \"\" 2 \" \" 3 \\\" 4 \"a b\" 5 \\\"bla\\\" 6 \"ab\"cd 7 ef\"gh\" 8 i\"\"j 9 \"x\\\"y\\\\\" 10 z\\\\z 11 \"two-quotes:\"\"\"\"\" 12 \"g\"\"h\" 13 \"\"\"a\"\" b\"", new String[]{"1", "\"\"", "2", " ", "3", "\"", "4", "a b", "5", "\"bla\"", "6", "abcd", "7", "efgh", "8", "ij", "9", "x\"y\\", "10", "z\\\\z", "11", "two-quotes:\"\"", "12", "g\"h", "13", "\"a\" b"}, "1 \"\" 2 \" \" 3 \\\" 4 \"a b\" 5 \\\"bla\\\" 6 abcd 7 efgh 8 ij 9 x\\\"y\\ 10 z\\\\z 11 two-quotes:\\\"\\\" 12 g\\\"h 13 \"\\\"a\\\" b\"");
        } else {
            ArgumentParsingTests.execute("1 \"\" 2 \" \" 3 \\\" 4 \"a b\" 5 \\\"bla\\\" 6 \"ab\"cd 7 ef\"gh\" 8 i\"\"j 9 \"x\\\"y\\\\\" 10 z\\\\z 11 \"two-quotes:\"\"\"\"\" 12 \"g\"\"h\" 13 \"\"\"a\"\" b\"", new String[]{"1", "", "2", " ", "3", "\"", "4", "a b", "5", "\"bla\"", "6", "abcd", "7", "efgh", "8", "ij", "9", "x\"y\\", "10", "z\\z", "11", "two-quotes:", "12", "gh", "13", "a b"}, "1 \"\" 2 \" \" 3 \\\" 4 \"a b\" 5 \\\"bla\\\" 6 abcd 7 efgh 8 ij 9 x\\\"y\\\\ 10 z\\\\z 11 two-quotes: 12 gh 13 \"a b\"");
        }
    }
}

