/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.tests.launching.DebugFileStore;

public class DebugFileSystem
extends FileSystem {
    public static final byte[] DIRECTORY_BYTES = new byte[]{1, 2, 3, 4};
    private static DebugFileSystem system;
    private final Map<URI, byte[]> files = new HashMap<URI, byte[]>();

    public DebugFileSystem() {
        system = this;
        try {
            this.setContents(new URI("debug", IPath.ROOT.toString(), null), DIRECTORY_BYTES);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    static DebugFileSystem getDefault() {
        return system;
    }

    public IFileStore getStore(URI uri) {
        return new DebugFileStore(uri);
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public byte[] getContents(URI uri) {
        return this.files.get(uri);
    }

    public void delete(URI uri) {
        this.files.remove(uri);
    }

    public void setContents(URI uri, byte[] bytes) {
        this.files.put(uri, bytes);
    }

    public URI[] getFileURIs() {
        return this.files.keySet().toArray(new URI[this.files.size()]);
    }
}

