/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.tests.TestsPlugin;
import org.eclipse.debug.tests.console.MockProcess;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.debug.tests.launching.TestLaunchDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class LaunchConfigurationTests
extends AbstractLaunchTest
implements ILaunchConfigurationListener {
    public static final String ID_TEST_LAUNCH_TYPE = "org.eclipse.debug.tests.launch.type";
    protected ILaunchConfiguration fFrom;
    protected ILaunchConfiguration fTo;
    protected Object fLock = new Object();
    protected ILaunchConfiguration fAdded;
    protected ILaunchConfiguration fRemoved;

    public static char[] getInputStreamAsCharArray(InputStream stream) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = LaunchConfigurationTests.getInputStreamAsByteArray(stream, -1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).array();
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    protected IProject getProject() throws CoreException {
        return TestsPlugin.createProject("LaunchConfigurationTests");
    }

    protected ILaunchConfigurationWorkingCopy newConfiguration(IContainer container, String configurationName) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        Assert.assertTrue((String)"Should support debug mode", (boolean)type.supportsMode("debug"));
        Assert.assertTrue((String)"Should support run mode", (boolean)type.supportsMode("run"));
        ILaunchConfigurationWorkingCopy wc = type.newInstance(container, configurationName);
        wc.setAttribute("String1", "String1");
        wc.setAttribute("Int1", 1);
        wc.setAttribute("Boolean1", true);
        wc.setAttribute("Boolean2", false);
        Assert.assertTrue((String)"Should need saving", (boolean)wc.isDirty());
        return wc;
    }

    protected ILaunchConfigurationWorkingCopy newEmptyConfiguration(IContainer container, String configurationName) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(container, configurationName);
        Assert.assertEquals((String)"Should have no attributes", (long)0L, (long)wc.getAttributes().size());
        return wc;
    }

    protected ILaunchConfigurationWorkingCopy newPrototype(IContainer container, String configurationName) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        Assert.assertTrue((String)"Should support debug mode", (boolean)type.supportsMode("debug"));
        Assert.assertTrue((String)"Should support run mode", (boolean)type.supportsMode("run"));
        ILaunchConfigurationWorkingCopy wc = type.newPrototypeInstance(container, configurationName);
        wc.setAttribute("String1", "String1");
        wc.setAttribute("Int1", 1);
        wc.setAttribute("Boolean1", true);
        wc.setAttribute("Boolean2", false);
        Assert.assertTrue((String)"Should need saving", (boolean)wc.isDirty());
        return wc;
    }

    protected ILaunchConfigurationWorkingCopy newEmptyPrototype(IContainer container, String configurationName) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType(ID_TEST_LAUNCH_TYPE);
        ILaunchConfigurationWorkingCopy wc = type.newPrototypeInstance(container, configurationName);
        Assert.assertEquals((String)"Should have no attributes", (long)0L, (long)wc.getAttributes().size());
        return wc;
    }

    protected boolean existsIn(ILaunchConfiguration[] configs, ILaunchConfiguration config) {
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            if (c.equals(config)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Test
    public void testCreateLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertEquals((String)"String1 should be String1", (Object)handle.getAttribute("String1", "Missing"), (Object)"String1");
        Assert.assertEquals((String)"Int1 should be 1", (long)handle.getAttribute("Int1", 0), (long)1L);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testLocalName() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "localName");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertEquals((String)"Wrong name", (Object)handle.getName(), (Object)"localName");
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSharedName() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "sharedName");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertEquals((String)"Wrong name", (Object)handle.getName(), (Object)"sharedName");
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testGetAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        Assert.assertEquals((String)"String1 should be String1", (Object)"String1", attributes.get("String1"));
        Assert.assertEquals((String)"Int1 should be 1", (Object)1, attributes.get("Int1"));
        Assert.assertEquals((String)"Boolean1 should be true", (Object)Boolean.TRUE, attributes.get("Boolean1"));
        Assert.assertEquals((String)"Boolean2 should be false", (Object)Boolean.FALSE, attributes.get("Boolean2"));
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSetAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ATTR1", "ONE");
        map.put("ATTR2", "TWO");
        wc.setAttributes(map);
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        Assert.assertEquals((String)"should have two attributes", (long)2L, (long)attributes.size());
        Assert.assertEquals((String)"ATTR1 should be ONE", (Object)"ONE", attributes.get("ATTR1"));
        Assert.assertEquals((String)"ATTR2 should be TWO", (Object)"TWO", attributes.get("ATTR2"));
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSetNullAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config1");
        wc.setAttributes(null);
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Map attributes = handle.getAttributes();
        Assert.assertEquals((String)"should have no attributes", (long)0L, (long)attributes.size());
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testLocalCopy() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "configToCopy");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        ILaunchConfigurationWorkingCopy softCopy = handle.copy("CopyOf" + handle.getName());
        Assert.assertNull((String)"Original in copy should be null", (Object)softCopy.getOriginal());
        ILaunchConfiguration hardCopy = softCopy.doSave();
        Assert.assertTrue((String)"String1 should be String1", (boolean)hardCopy.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (hardCopy.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)hardCopy.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!hardCopy.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Original should still exist", (boolean)handle.exists());
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
        hardCopy.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!hardCopy.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleSave() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "configDoubleSave");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        String configurationName = wc.getName();
        wc.rename("newName");
        wc.rename(configurationName);
        Assert.assertTrue((String)"Should be dirty", (boolean)wc.isDirty());
        wc.doSave();
        Object[] newConfigs = this.getLaunchManager().getLaunchConfigurations();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])newConfigs).as("compare number of configs", new Object[0])).hasSameSizeAs((Object)configs);
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2delete");
        ILaunchConfiguration handle = wc.doSave();
        File file = wc.getLocation().toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should not exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
    }

    @Test
    public void testRenameLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2rename");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.rename("config-2-rename");
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        Assert.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        Assert.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        Assert.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testMoveLocalToSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config2share");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.setContainer((IContainer)this.getProject());
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        Assert.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        Assert.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        Assert.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testMoveSharedToLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2local");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.setContainer(null);
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        Assert.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        Assert.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        Assert.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSharedConfigurationLineDelimiters() throws CoreException {
        String systemSeparator = System.lineSeparator();
        String nonSystemSeparator = "\n".equals(systemSeparator) ? "\r\n" : "\n";
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "shared");
        ILaunchConfiguration inWorkspaceMetadataHandle = wc.doSave();
        IEclipsePreferences workspacePrefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.runtime");
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences projectNode = rootNode.node("project").node(this.getProject().getName());
        workspacePrefs.remove("line.separator");
        projectNode.node("org.eclipse.core.runtime").remove("line.separator");
        wc = inWorkspaceMetadataHandle.getWorkingCopy();
        wc.setContainer((IContainer)this.getProject());
        ILaunchConfiguration sharedHandle = wc.doSave();
        Assert.assertEquals((Object)systemSeparator, (Object)sharedHandle.getFile().getLineSeparator(false));
        sharedHandle.delete();
        Assert.assertTrue((String)"Shared config should not exist after deletion", (!sharedHandle.exists() ? 1 : 0) != 0);
        workspacePrefs.put("line.separator", nonSystemSeparator);
        sharedHandle = wc.doSave();
        Assert.assertEquals((Object)nonSystemSeparator, (Object)sharedHandle.getFile().getLineSeparator(false));
        sharedHandle.delete();
        Assert.assertTrue((String)"Shared config should not exist after deletion", (!sharedHandle.exists() ? 1 : 0) != 0);
        workspacePrefs.put("line.separator", systemSeparator);
        projectNode.node("org.eclipse.core.runtime").put("line.separator", nonSystemSeparator);
        sharedHandle = wc.doSave();
        Assert.assertEquals((Object)nonSystemSeparator, (Object)sharedHandle.getFile().getLineSeparator(false));
        sharedHandle.delete();
        Assert.assertTrue((String)"Shared config should not exist after deletion", (!sharedHandle.exists() ? 1 : 0) != 0);
        sharedHandle = null;
        workspacePrefs.remove("line.separator");
        projectNode.node("org.eclipse.core.runtime").remove("line.separator");
        ILaunchConfiguration systemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)systemSeparator, (Object)systemNewlineHandle.getFile().getLineSeparator(false));
        workspacePrefs.put("line.separator", nonSystemSeparator);
        systemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)systemSeparator, (Object)systemNewlineHandle.getFile().getLineSeparator(false));
        projectNode.node("org.eclipse.core.runtime").put("line.separator", nonSystemSeparator);
        systemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)systemSeparator, (Object)systemNewlineHandle.getFile().getLineSeparator(false));
        systemNewlineHandle.delete();
        Assert.assertTrue((String)"Shared config should not exist after deletion", (!systemNewlineHandle.exists() ? 1 : 0) != 0);
        systemNewlineHandle = null;
        ILaunchConfiguration nonSystemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)nonSystemSeparator, (Object)nonSystemNewlineHandle.getFile().getLineSeparator(false));
        workspacePrefs.put("line.separator", systemSeparator);
        nonSystemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)nonSystemSeparator, (Object)nonSystemNewlineHandle.getFile().getLineSeparator(false));
        projectNode.node("org.eclipse.core.runtime").put("line.separator", systemSeparator);
        nonSystemNewlineHandle = wc.doSave();
        Assert.assertEquals((Object)nonSystemSeparator, (Object)nonSystemNewlineHandle.getFile().getLineSeparator(false));
        nonSystemNewlineHandle.delete();
        Assert.assertTrue((String)"Shared config 2 should not exist after deletion", (!nonSystemNewlineHandle.exists() ? 1 : 0) != 0);
        nonSystemNewlineHandle = null;
        workspacePrefs.remove("line.separator");
        projectNode.node("org.eclipse.core.runtime").remove("line.separator");
        inWorkspaceMetadataHandle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!inWorkspaceMetadataHandle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testSharedCopy() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "config2Copy");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        ILaunchConfigurationWorkingCopy softCopy = handle.copy("CopyOf" + handle.getName());
        ILaunchConfiguration hardCopy = softCopy.doSave();
        Assert.assertTrue((String)"String1 should be String1", (boolean)hardCopy.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (hardCopy.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)hardCopy.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!hardCopy.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Original should still exist", (boolean)handle.exists());
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
        hardCopy.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!hardCopy.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "shared2delete");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should not exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
    }

    @Test
    public void testRenameSharedConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "shared2rename");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        wc = handle.getWorkingCopy();
        wc.rename("shared-2-rename");
        this.addConfigListener();
        ILaunchConfiguration newHandle = wc.doSave();
        this.removeConfigListener();
        Assert.assertTrue((String)"Config should no longer exist", (!handle.exists() ? 1 : 0) != 0);
        Assert.assertEquals((String)"From should be original", (Object)handle, (Object)this.fFrom);
        Assert.assertEquals((String)"To should be new handle", (Object)newHandle, (Object)this.fTo);
        Assert.assertTrue((String)"String1 should be String1", (boolean)newHandle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (newHandle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)newHandle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!newHandle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Renamed configuration should exist in project index", (boolean)this.existsIn(configs, newHandle));
        Assert.assertTrue((String)"Original configuration should NOT exist in project index", (!this.existsIn(configs, handle) ? 1 : 0) != 0);
        newHandle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!newHandle.exists() ? 1 : 0) != 0);
    }

    protected void closeAllEditors() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        activeWorkbenchWindow.getActivePage().closeAllEditors(false);
    }

    @Test
    public void testPersistIndex() throws CoreException {
        this.closeAllEditors();
        ILaunchConfigurationWorkingCopy wc1 = this.newConfiguration(null, "persist1local");
        ILaunchConfigurationWorkingCopy wc2 = this.newConfiguration((IContainer)this.getProject(), "persist2shared");
        ILaunchConfiguration lc1 = wc1.doSave();
        ILaunchConfiguration lc2 = wc2.doSave();
        IProject project = this.getProject();
        ILaunchConfiguration[] before = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"config should be in index", (boolean)this.existsIn(before, lc1));
        Assert.assertTrue((String)"config should be in index", (boolean)this.existsIn(before, lc2));
        project.close(null);
        ILaunchConfiguration[] during = this.getLaunchManager().getLaunchConfigurations();
        boolean local = true;
        ILaunchConfiguration[] iLaunchConfigurationArray = during;
        int n = during.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration d = iLaunchConfigurationArray[n2];
            local = local && (d.isLocal() || !d.getFile().getProject().equals((Object)project));
            ++n2;
        }
        project.open(null);
        Assert.assertTrue((String)"Should only be local configs when closed", (boolean)local);
        Object[] after = this.getLaunchManager().getLaunchConfigurations();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])after).as("compare number of configs", new Object[0])).hasSameSizeAs((Object)before);
        ILaunchConfiguration[] iLaunchConfigurationArray2 = before;
        int n3 = before.length;
        n = 0;
        while (n < n3) {
            ILaunchConfiguration b = iLaunchConfigurationArray2[n];
            Assert.assertTrue((String)"Config should exist after openning", (boolean)this.existsIn((ILaunchConfiguration[])after, b));
            ++n;
        }
        lc1.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!lc1.exists() ? 1 : 0) != 0);
        lc2.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!lc2.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.fFrom = this.getLaunchManager().getMovedFrom(configuration);
        Object object = this.fLock;
        synchronized (object) {
            this.fAdded = configuration;
            this.fLock.notifyAll();
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.fTo = this.getLaunchManager().getMovedTo(configuration);
        Object object = this.fLock;
        synchronized (object) {
            this.fRemoved = configuration;
            this.fLock.notifyAll();
        }
    }

    protected void addConfigListener() {
        this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    protected void removeConfigListener() {
        this.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProjectWithSharedConfig() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DeleteSharedConfig");
        try {
            Assert.assertFalse((String)"project should not exist yet", (boolean)project.exists());
            project.create(null);
            Assert.assertTrue((String)"project should now exist", (boolean)project.exists());
            project.open(null);
            Assert.assertTrue((String)"project should be open", (boolean)project.isOpen());
            ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)project, "ToBeDeleted");
            this.addConfigListener();
            ILaunchConfiguration configuration = wc.doSave();
            Assert.assertEquals((Object)configuration, (Object)this.fAdded);
            Object object = this.fLock;
            synchronized (object) {
                this.fRemoved = null;
                project.delete(true, false, null);
                if (this.fRemoved == null) {
                    this.fLock.wait(10000L);
                }
            }
            Assert.assertEquals((Object)configuration, (Object)this.fRemoved);
        }
        finally {
            if (project.exists()) {
                project.delete(true, false, null);
            }
            this.removeConfigListener();
        }
    }

    @Test
    public void testNestedWorkingCopyLocalConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "config123");
        IPath location = wc.getLocation();
        ILaunchConfiguration handle = wc.doSave();
        File file = location.toFile();
        Assert.assertTrue((String)"Configuration file should exist", (boolean)file.exists());
        Assert.assertEquals((String)"String1 should be String1", (Object)handle.getAttribute("String1", "Missing"), (Object)"String1");
        Assert.assertEquals((String)"Int1 should be 1", (long)handle.getAttribute("Int1", 0), (long)1L);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        Assert.assertTrue((String)"Configuration should exist in project index", (boolean)this.existsIn(configs, handle));
        wc = handle.getWorkingCopy();
        ILaunchConfigurationWorkingCopy nested = wc.getWorkingCopy();
        Assert.assertEquals((String)"String1 should be String1", (Object)nested.getAttribute("String1", "Missing"), (Object)"String1");
        Assert.assertEquals((String)"Int1 should be 1", (long)nested.getAttribute("Int1", 0), (long)1L);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)nested.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!nested.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        nested.setAttribute("String1", "StringOne");
        Assert.assertEquals((String)"Wrong attribute value", (Object)nested.getAttribute("String1", "Missing"), (Object)"StringOne");
        Assert.assertEquals((String)"Wrong attribute value", (Object)wc.getAttribute("String1", "Missing"), (Object)"String1");
        Assert.assertEquals((String)"Wrong attribute value", (Object)handle.getAttribute("String1", "Missing"), (Object)"String1");
        ILaunchConfigurationWorkingCopy parent = nested.getParent();
        Assert.assertEquals((String)"Wrong parent", (Object)wc, (Object)parent);
        Assert.assertNull((String)"Should have no parent", (Object)wc.getParent());
        nested.doSave();
        Assert.assertEquals((String)"Wrong attribute value", (Object)wc.getAttribute("String1", "Missing"), (Object)"StringOne");
        Assert.assertEquals((String)"Wrong attribute value", (Object)handle.getAttribute("String1", "Missing"), (Object)"String1");
        Assert.assertEquals((String)"Wrong original config", (Object)handle, (Object)wc.getOriginal());
        Assert.assertEquals((String)"Wrong original config", (Object)handle, (Object)nested.getOriginal());
        handle.delete();
        Assert.assertTrue((String)"Config should not exist after deletion", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateDeleteEFS() throws CoreException, URISyntaxException {
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        Assert.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = this.getProject().getFolder("efs");
        folder.createLink(new URI("debug", IPath.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        handle.delete();
        Assert.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
        folder.delete(0, null);
    }

    @Test
    public void testCreateDeleteEFSLink() throws CoreException, URISyntaxException {
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        Assert.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = this.getProject().getFolder("efs2");
        folder.createLink(new URI("debug", IPath.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        folder.delete(0, null);
        Assert.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testEFSProjectRename() throws Exception {
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject("RenameEFS");
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        IProject project = TestsPlugin.createProject("RenameEFS");
        IFileSystem fileSystem = EFS.getFileSystem((String)"debug");
        Assert.assertNotNull((String)"Missing debug EFS", (Object)fileSystem);
        IFolder folder = project.getFolder("efs2");
        folder.createLink(new URI("debug", IPath.ROOT.toString(), null), 0, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)folder, "efsConfig");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        IProjectDescription description = project.getDescription();
        description.setName("SFEemaneR");
        project.move(description, 32, null);
        Assert.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("SFEemaneR");
        Assert.assertTrue((String)"Project should exist", (boolean)project.exists());
        IFile file = project.getFile(IPath.fromOSString((String)"efs2/efsConfig.launch"));
        Assert.assertTrue((String)"launch config file should exist", (boolean)file.exists());
        handle = this.getLaunchManager().getLaunchConfiguration(file);
        Assert.assertTrue((String)"launch config should exist", (boolean)handle.exists());
        Assert.assertTrue((String)"String1 should be String1", (boolean)handle.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (handle.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)handle.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!handle.getAttribute("Boolean2", true) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shared location should be updated", (Object)file, (Object)handle.getFile());
        project.delete(0, null);
        Assert.assertTrue((String)"Configuration should not exist", (!handle.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testImport() throws Exception {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)this.getProject(), "Import4");
        ILaunchConfiguration handle = wc.doSave();
        Assert.assertTrue((String)"Configuration should exist", (boolean)handle.exists());
        File dir = TestsPlugin.getFileInPlugin("test-import");
        Assert.assertTrue((String)"Import directory does not exist", (boolean)dir.exists());
        LaunchManager manager = (LaunchManager)this.getLaunchManager();
        Listener listener = new Listener();
        try {
            this.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)listener);
            manager.importConfigurations(dir.listFiles(file -> file.isFile() && file.getName().endsWith("launch")), null);
            List<ILaunchConfiguration> removed = listener.getRemoved();
            Assert.assertEquals((String)"Should be one removed config", (long)1L, (long)removed.size());
            Assert.assertTrue((String)"Import4 should be removed", (boolean)removed.contains(handle));
            List<ILaunchConfiguration> added = listener.getAdded();
            Assert.assertEquals((String)"Should be 5 added configs", (long)5L, (long)added.size());
            HashSet<String> names = new HashSet<String>();
            for (ILaunchConfiguration lc : added) {
                names.add(lc.getName());
            }
            Assert.assertTrue((String)"Missing Name", (boolean)names.contains("Import1"));
            Assert.assertTrue((String)"Missing Name", (boolean)names.contains("Import2"));
            Assert.assertTrue((String)"Missing Name", (boolean)names.contains("Import3"));
            Assert.assertTrue((String)"Missing Name", (boolean)names.contains("Import4"));
            Assert.assertTrue((String)"Missing Name", (boolean)names.contains("Import5"));
            List<ILaunchConfiguration> changed = listener.getChanged();
            Assert.assertEquals((String)"Should be 1 changed config", (long)1L, (long)changed.size());
            Assert.assertEquals((String)"Wrong changed config", (Object)"Import4", (Object)changed.get(0).getName());
        }
        finally {
            manager.removeLaunchConfigurationListener((ILaunchConfigurationListener)listener);
        }
    }

    @Test
    public void testWorkingCopyGetLocation() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-get-location");
        IPath location = workingCopy.getLocation();
        Assert.assertEquals((String)"Wrong path for local working copy", (Object)LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH.append("test-get-location.launch"), (Object)location);
    }

    @Test
    public void testLaunchTimeStamp() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-time-stamp");
        ILaunch launch = workingCopy.launch("debug", null);
        try {
            String stamp = launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
            Assert.assertNotNull((String)"missing time stamp", (Object)stamp);
            long lstamp = Long.parseLong(stamp);
            Assert.assertTrue((String)"Time travel launch", (lstamp <= System.currentTimeMillis() ? 1 : 0) != 0);
        }
        finally {
            if (launch != null) {
                this.getLaunchManager().removeLaunch(launch);
            }
        }
    }

    @Test
    public void testTerminateTimeStamp() throws Exception {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-time-stamp");
        final Set terminatedLaunches = Collections.synchronizedSet(new HashSet());
        ILaunchesListener2 listener = new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesTerminated(ILaunch[] launches) {
                terminatedLaunches.addAll(Arrays.asList(launches));
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)listener);
        ILaunch launch = workingCopy.launch("debug", null);
        IProcess process = null;
        try {
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)new MockProcess(0L), (String)"test-terminate-timestamp");
            this.waitWhile(__ -> !terminatedLaunches.contains(launch), this.testTimeout, __ -> "Launch termination event did not occur: launch termination state is \"" + launch.isTerminated() + "\" and " + terminatedLaunches.size() + " launches have terminated");
            String launchTerminateTimestampUntyped = launch.getAttribute("org.eclipse.debug.core.terminate.timestamp");
            Assert.assertNotNull((String)"Time stamp is missing", (Object)launchTerminateTimestampUntyped);
            long launchTerminateTimestamp = Long.parseLong(launchTerminateTimestampUntyped);
            Assert.assertTrue((String)"Launch time is before current time", (launchTerminateTimestamp <= System.currentTimeMillis() ? 1 : 0) != 0);
        }
        finally {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)listener);
            if (launch != null) {
                this.getLaunchManager().removeLaunch(launch);
            }
            if (process != null) {
                process.terminate();
            }
        }
    }

    @Test
    public void testCancel() throws CoreException {
        ILaunchDelegate launchDelegate = ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).getLaunchDelegate(ID_TEST_LAUNCH_TYPE);
        TestLaunchDelegate testLaunchDelegate = (TestLaunchDelegate)launchDelegate.getDelegate();
        ILaunchConfigurationDelegate2 customLaunchDelegate = new ILaunchConfigurationDelegate2(){

            void sleep() {
            }

            public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
                this.sleep();
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }

            public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
                this.sleep();
                return !monitor.isCanceled();
            }

            public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
                this.sleep();
                return null;
            }

            public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
                this.sleep();
                return !monitor.isCanceled();
            }

            public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
                this.sleep();
                return !monitor.isCanceled();
            }
        };
        testLaunchDelegate.setDelegate(customLaunchDelegate);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "cancel me");
            int cancelCount = 0;
            int i = 0;
            while (i < 10000) {
                final AtomicInteger checkCount = new AtomicInteger(i);
                NullProgressMonitor monitor = new NullProgressMonitor(){

                    public boolean isCanceled() {
                        return super.isCanceled() || checkCount.getAndDecrement() <= 0;
                    }
                };
                ILaunch launch = workingCopy.launch("run", (IProgressMonitor)monitor);
                Assert.assertNotNull((Object)launch);
                if (!monitor.isCanceled()) break;
                ++cancelCount;
                ++i;
            }
            Assert.assertNotEquals((long)0L, (long)cancelCount);
        }
        finally {
            testLaunchDelegate.setDelegate(null);
        }
    }

    @Test
    public void testTerminateLaunchListener_Issue598() throws Exception {
        ILaunchConfigurationWorkingCopy workingCopy = this.newConfiguration(null, "test-launch-listener");
        final AtomicBoolean processStarted = new AtomicBoolean(false);
        final AtomicBoolean launchTerminated = new AtomicBoolean(false);
        ILaunchesListener2 listener = new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesTerminated(ILaunch[] launches) {
                launchTerminated.set(true);
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)listener);
        MockProcess mockProcess = new MockProcess(0L){

            @Override
            public int waitFor() throws InterruptedException {
                processStarted.set(true);
                return super.waitFor();
            }
        };
        Launch launch = new Launch((ILaunchConfiguration)workingCopy, "debug", null){

            public void addProcess(IProcess process) {
                long msecToWaitForProcessToStart = 500L;
                long startTimeMsec = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTimeMsec < msecToWaitForProcessToStart) {
                    Assert.assertFalse((String)"Process started before registering launch for notifications", (boolean)processStarted.get());
                }
                super.addProcess(process);
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        IProcess runtimeProcess = null;
        try {
            runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)mockProcess, (String)"test-terminate-launch-listener");
            this.waitWhile(__ -> !launchTerminated.get(), this.testTimeout, __ -> "Launch termination event did not occur");
        }
        finally {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)listener);
            if (launch != null) {
                this.getLaunchManager().removeLaunch((ILaunch)launch);
            }
            if (runtimeProcess != null) {
                runtimeProcess.terminate();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testMapAttributePersistence() throws CoreException, IOException {
        char[] chars2;
        char[] chars1;
        block13: {
            ILaunchConfigurationWorkingCopy c1 = this.newEmptyConfiguration((IContainer)this.getProject(), "testMapAttributes1");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Z", "z-value");
            map.put("Y", "y-value");
            map.put("X", "x-value");
            map.put("W", "w-value");
            map.put("V", "v-value");
            map.put("U", "u-value");
            map.put("T", "t-value");
            map.put("S", "s-value");
            map.put("R", "r-value");
            map.put("Q", "q-value");
            map.put("P", "p-value");
            map.put("O", "o-value");
            map.put("N", "n-value");
            map.put("M", "m-value");
            map.put("L", "l-value");
            map.put("K", "k-value");
            map.put("J", "j-value");
            map.put("I", "i-value");
            map.put("H", "h-value");
            map.put("G", "g-value");
            map.put("F", "f-value");
            map.put("E", "e-value");
            map.put("D", "d-value");
            map.put("C", "c-value");
            map.put("B", "b-value");
            map.put("A", "a-value");
            c1.setAttribute("Map-Attribute", map);
            c1.doSave();
            ILaunchConfigurationWorkingCopy c2 = this.newEmptyConfiguration((IContainer)this.getProject(), "testMapAttributes2");
            map = new HashMap();
            map.put("A", "a-value");
            map.put("Z", "z-value");
            map.put("B", "b-value");
            map.put("Y", "y-value");
            map.put("C", "c-value");
            map.put("X", "x-value");
            map.put("D", "d-value");
            map.put("W", "w-value");
            map.put("E", "e-value");
            map.put("V", "v-value");
            map.put("F", "f-value");
            map.put("U", "u-value");
            map.put("G", "g-value");
            map.put("T", "t-value");
            map.put("H", "h-value");
            map.put("S", "s-value");
            map.put("I", "i-value");
            map.put("R", "r-value");
            map.put("J", "j-value");
            map.put("Q", "q-value");
            map.put("K", "k-value");
            map.put("P", "p-value");
            map.put("L", "l-value");
            map.put("M", "m-value");
            map.put("O", "o-value");
            map.put("N", "n-value");
            c2.setAttribute("Map-Attribute", map);
            c2.doSave();
            Throwable throwable = null;
            Object var7_6 = null;
            try {
                InputStream in1 = c1.getFile().getContents();
                try {
                    try (InputStream in2 = c2.getFile().getContents();){
                        chars1 = LaunchConfigurationTests.getInputStreamAsCharArray(in1);
                        chars2 = LaunchConfigurationTests.getInputStreamAsCharArray(in2);
                    }
                    if (in1 == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in1 == null) throw throwable;
                    in1.close();
                    throw throwable;
                }
                in1.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Assertions.assertThat((char[])chars1).isEqualTo((Object)chars2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testSetAttributePersistence() throws CoreException, IOException {
        char[] chars2;
        char[] chars1;
        block13: {
            ILaunchConfigurationWorkingCopy c1 = this.newEmptyConfiguration((IContainer)this.getProject(), "testSetAttributes1");
            HashSet<String> set = new HashSet<String>();
            set.add("z-value");
            set.add("y-value");
            set.add("x-value");
            set.add("w-value");
            set.add("v-value");
            set.add("u-value");
            set.add("t-value");
            set.add("s-value");
            set.add("r-value");
            set.add("q-value");
            set.add("p-value");
            set.add("o-value");
            set.add("n-value");
            set.add("m-value");
            set.add("l-value");
            set.add("k-value");
            set.add("j-value");
            set.add("i-value");
            set.add("h-value");
            set.add("g-value");
            set.add("f-value");
            set.add("e-value");
            set.add("d-value");
            set.add("c-value");
            set.add("b-value");
            set.add("a-value");
            c1.setAttribute("Set-Attribute", set);
            c1.doSave();
            ILaunchConfigurationWorkingCopy c2 = this.newEmptyConfiguration((IContainer)this.getProject(), "testSetAttributes2");
            set = new HashSet();
            set.add("a-value");
            set.add("z-value");
            set.add("b-value");
            set.add("y-value");
            set.add("c-value");
            set.add("x-value");
            set.add("d-value");
            set.add("w-value");
            set.add("e-value");
            set.add("v-value");
            set.add("f-value");
            set.add("u-value");
            set.add("g-value");
            set.add("t-value");
            set.add("h-value");
            set.add("s-value");
            set.add("i-value");
            set.add("r-value");
            set.add("j-value");
            set.add("q-value");
            set.add("k-value");
            set.add("p-value");
            set.add("l-value");
            set.add("m-value");
            set.add("o-value");
            set.add("n-value");
            c2.setAttribute("Set-Attribute", set);
            c2.doSave();
            Throwable throwable = null;
            Object var7_6 = null;
            try {
                InputStream in1 = c1.getFile().getContents();
                try {
                    try (InputStream in2 = c2.getFile().getContents();){
                        chars1 = LaunchConfigurationTests.getInputStreamAsCharArray(in1);
                        chars2 = LaunchConfigurationTests.getInputStreamAsCharArray(in2);
                    }
                    if (in1 == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in1 == null) throw throwable;
                    in1.close();
                    throw throwable;
                }
                in1.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Assertions.assertThat((char[])chars1).isEqualTo((Object)chars2);
    }

    @Test
    public void testIllegalFileSepCharName() {
        try {
            this.newConfiguration(null, IPath.fromOSString((String)"some").append("nested").append("config").toOSString());
        }
        catch (CoreException e) {
            return;
        }
        Assert.assertTrue((String)"Should be an illegal argument - cannot nest local configurations", (boolean)false);
    }

    @Test
    public void testLegalFileSepCharName() {
        try {
            this.newConfiguration((IContainer)this.getProject(), IPath.fromOSString((String)"some").append("nested").append("config").toOSString());
        }
        catch (CoreException e) {
            Assert.assertTrue((String)"Should *not* be an illegal argument - can nest shared cofigurations", (boolean)false);
        }
    }

    @Test
    public void testIllegalCharName() {
        try {
            this.newConfiguration((IContainer)this.getProject(), "<config>");
        }
        catch (CoreException e) {
            return;
        }
        Assert.assertTrue((String)"Should be an illegal argument - illegal character used in name", (boolean)false);
    }

    @Test
    public void testRenameAndMoveShared() throws CoreException {
        IProject project = this.getProject();
        IFolder f1 = project.getFolder("f1");
        IFolder f2 = project.getFolder("f2");
        f1.create(false, true, null);
        f2.create(false, true, null);
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration((IContainer)f1, "start-here");
        ILaunchConfiguration orig = wc.doSave();
        wc = orig.getWorkingCopy();
        wc.setContainer((IContainer)f2);
        wc.rename("end-here");
        ILaunchConfiguration next = wc.doSave();
        Assert.assertFalse((String)"Original should not exist", (boolean)orig.exists());
        Assert.assertTrue((String)"Renamed and moved config should exist", (boolean)next.exists());
    }

    @Test
    public void testGetTypeImageFromURI() throws Exception {
        ImageDescriptor descriptor = DebugUITools.getImageDescriptor((String)"org.eclipse.debug.tests.launch.type1");
        Assert.assertNotNull((String)"The image descriptior type.image.1 must exist", (Object)descriptor);
        Assert.assertNotSame((String)"The image descriptor is not type.image.1", (Object)ImageDescriptor.getMissingImageDescriptor(), (Object)descriptor);
    }

    @Test
    public void testGetTyeImage() throws Exception {
        ImageDescriptor descriptor = DebugUITools.getImageDescriptor((String)ID_TEST_LAUNCH_TYPE);
        Assert.assertNotNull((String)"The image descriptior type.image.2 must exist", (Object)descriptor);
        Assert.assertNotSame((String)"The image descriptor is not type.image.2", (Object)ImageDescriptor.getMissingImageDescriptor(), (Object)descriptor);
    }

    @Test
    public void testGetProjectMappedResource1() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            Assert.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test.project", 4)});
            Object[] res = wc.getMappedResources();
            Assert.assertNotNull((String)"There should be mapped resources", (Object)res);
            Assertions.assertThat((Object[])res).hasSize(1);
        }
        finally {
            lc.delete();
        }
    }

    @Test
    public void testGetProjectMappedResource2() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            Assert.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test/project", 4)});
            IResource[] res = wc.getMappedResources();
            Assert.assertNull((String)"There should be no mapped resources", (Object)res);
        }
        finally {
            lc.delete();
        }
    }

    @Test
    public void testGetProjectMappedResource3() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            Assert.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("test\\project", 4)});
            IResource[] res = wc.getMappedResources();
            if ("win32".equals(Platform.getOS())) {
                Assert.assertNull((String)"There should be no mapped resources", (Object)res);
            } else {
                Assert.assertNotNull((String)"There should be mapped resources", (Object)res);
            }
        }
        finally {
            lc.delete();
        }
    }

    @Test
    public void testGetProjectMappedResource4() throws Exception {
        ILaunchConfigurationWorkingCopy lc = this.newConfiguration(null, "test.project.resource.mapping");
        try {
            ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
            Assert.assertNotNull((String)"Should have a working copy of the testig launch configuration", (Object)wc);
            this.setResourceMappings(wc, new ResourceItem[]{new ResourceItem("/project", 4)});
            IResource[] res = wc.getMappedResources();
            Assert.assertNotNull((String)"There should be mapped resources", (Object)res);
        }
        finally {
            lc.delete();
        }
    }

    @Test
    public void testNullLaunchConfigurationInLaunch() throws Exception {
        Launch l = new Launch(null, "run", null);
        LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
        Bundle b = Platform.getBundle((String)"org.eclipse.ui.externaltools");
        Assert.assertNotNull((String)"Must have found the external tools bundle", (Object)b);
        if (b.getState() != 32) {
            b.start();
        }
        lm.addLaunch((ILaunch)l);
        lm.removeLaunch((ILaunch)l);
    }

    protected void setResourceMappings(ILaunchConfigurationWorkingCopy config, ResourceItem[] resources) {
        ArrayList<String> paths = null;
        ArrayList<String> types = null;
        int size = resources.length;
        if (resources != null && size > 0) {
            paths = new ArrayList<String>(size);
            types = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                paths.add(resources[i].path);
                types.add(resources[i].type.toString());
                ++i;
            }
        }
        config.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, paths);
        config.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, types);
    }

    @Test
    public void testCopyAttributes() throws CoreException {
        ILaunchConfigurationWorkingCopy source = this.newPrototype(null, "test-copy-attributes-source");
        ILaunchConfigurationWorkingCopy dest = this.newEmptyConfiguration(null, "test-copy-attributes-dest");
        dest.copyAttributes((ILaunchConfiguration)source);
        Assert.assertTrue((String)"String1 should be String1", (boolean)dest.getAttribute("String1", "Missing").equals("String1"));
        Assert.assertTrue((String)"Int1 should be 1", (dest.getAttribute("Int1", 0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Boolean1 should be true", (boolean)dest.getAttribute("Boolean1", false));
        Assert.assertTrue((String)"Boolean2 should be false", (!dest.getAttribute("Boolean2", true) ? 1 : 0) != 0);
    }

    @Test
    public void testCreationFromPrototype() throws CoreException {
        ILaunchConfigurationWorkingCopy temp = this.newPrototype(null, "test-creation-from-prototype");
        temp.setAttribute("TEMPLATE", "TEMPLATE");
        ILaunchConfiguration prototype = temp.doSave();
        ILaunchConfigurationType type = temp.getType();
        ILaunchConfigurationWorkingCopy config = type.newInstance(null, "test-scopes");
        config.setPrototype(prototype, true);
        Assert.assertNotNull((String)"Made from wrong prototype", (Object)config.getAttribute("TEMPLATE", null));
        Assert.assertEquals((String)"Should refer to creation prototype", (Object)prototype, (Object)config.getPrototype());
    }

    @Test
    public void testIsPrototype() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newPrototype(null, "test-is-prototype");
        ILaunchConfiguration prototype = wc.doSave();
        Assert.assertTrue((String)"Should be a prototype", (boolean)prototype.isPrototype());
        ILaunchConfiguration[] prototypes = wc.getType().getPrototypes();
        ArrayList list = new ArrayList();
        Collections.addAll(list, prototypes);
        Assert.assertFalse((String)"Expecting at least prototype", (boolean)list.isEmpty());
        Assert.assertTrue((String)"Missing created prototype", (boolean)list.contains(prototype));
    }

    @Test
    public void testPrototypeChildren() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newPrototype(null, "test-references");
        ILaunchConfiguration prototype = wc.doSave();
        ILaunchConfigurationWorkingCopy r1 = this.newConfiguration(null, "referee-1");
        ILaunchConfigurationWorkingCopy r2 = this.newConfiguration(null, "referee-2");
        r1.setPrototype(prototype, false);
        r2.setPrototype(prototype, false);
        ILaunchConfiguration s1 = r1.doSave();
        ILaunchConfiguration s2 = r2.doSave();
        Collection children = prototype.getPrototypeChildren();
        ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration child : children) {
            list.add(child);
        }
        Assert.assertEquals((String)"Wrong number of prototype children", (long)2L, (long)list.size());
        Assert.assertTrue((String)"Missing reference", (boolean)list.contains(s1));
        Assert.assertTrue((String)"Missing reference", (boolean)list.contains(s2));
    }

    @Test
    public void testPrototypeRemoveBehavior() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "test-remove");
        ILaunchConfigurationWorkingCopy t1 = this.newEmptyPrototype(null, "prototype-1");
        t1.setAttribute("COMMON", "TEMPLATE-1");
        t1.setAttribute("T1", "T1");
        t1.setAttribute("String1", "String2");
        ILaunchConfiguration prototype = t1.doSave();
        Assert.assertEquals((Object)"String1", (Object)wc.getAttribute("String1", "wrong"));
        wc.setPrototype(prototype, true);
        wc.removeAttribute("String1");
        Assert.assertEquals((Object)"TEMPLATE-1", (Object)wc.getAttribute("COMMON", null));
        Assert.assertEquals((Object)"T1", (Object)wc.getAttribute("T1", null));
        Assert.assertNull((Object)wc.getAttribute("String1", null));
    }

    @Test
    public void testUnPrototype() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.newConfiguration(null, "test-un-prototype");
        ILaunchConfigurationWorkingCopy t1 = this.newEmptyPrototype(null, "prototype-un");
        t1.setAttribute("COMMON", "PROTOTYPE-1");
        t1.setAttribute("T1", "T1");
        t1.setAttribute("String1", "String2");
        ILaunchConfiguration prototype = t1.doSave();
        wc.setPrototype(prototype, true);
        ILaunchConfiguration configuration = wc.doSave();
        Assert.assertEquals((Object)prototype, (Object)configuration.getPrototype());
        wc = configuration.getWorkingCopy();
        wc.setPrototype(null, false);
        configuration = wc.doSave();
        Assert.assertNull((Object)configuration.getPrototype());
        Collection children = t1.getPrototypeChildren();
        Assert.assertFalse((boolean)children.iterator().hasNext());
    }

    @Test
    public void testNestedPrototypes() throws CoreException {
        ILaunchConfigurationWorkingCopy t1 = this.newPrototype(null, "test-nest-root");
        ILaunchConfigurationWorkingCopy t2 = this.newPrototype(null, "prototype-nested");
        ILaunchConfiguration prototype = t1.doSave();
        try {
            t2.setPrototype(prototype, true);
        }
        catch (CoreException e) {
            return;
        }
        Assert.assertTrue((String)"Shoud not be able to nest prototypes", (boolean)false);
    }

    @Test
    public void testIllegalPrototype() throws CoreException {
        ILaunchConfigurationWorkingCopy c1 = this.newConfiguration(null, "test-config");
        ILaunchConfigurationWorkingCopy t1 = this.newConfiguration(null, "test-not-a-prototype");
        ILaunchConfiguration config = t1.doSave();
        try {
            c1.setPrototype(config, true);
        }
        catch (CoreException e) {
            return;
        }
        Assert.assertTrue((String)"Should not be able to set configration as prototype", (boolean)false);
    }

    @Test
    public void testCopyPrototype() throws CoreException {
        ILaunchConfigurationWorkingCopy t1 = this.newEmptyPrototype(null, "prototype-to-duplicate");
        ILaunchConfigurationWorkingCopy t2 = t1.copy("duplicate-prototype");
        Assert.assertTrue((boolean)t2.isPrototype());
    }

    @Test
    public void testNewInstanceNotifiesListener() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        final ArrayList added = new ArrayList();
        ILaunchConfigurationListener listener = new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                added.add("Launch Configuration added");
            }
        };
        launchManager.addLaunchConfigurationListener(listener);
        String typeId = "org.eclipse.ui.externaltools.ProgramLaunchConfigurationType";
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(typeId);
        type.newInstance(null, "new-lc").doSave();
        Assert.assertEquals((long)1L, (long)added.size());
        Assert.assertEquals((Object)"Launch Configuration added", added.get(0));
    }

    static class Listener
    implements ILaunchConfigurationListener {
        private final List<ILaunchConfiguration> addedList = new ArrayList<ILaunchConfiguration>();
        private final List<ILaunchConfiguration> removedList = new ArrayList<ILaunchConfiguration>();
        private final List<ILaunchConfiguration> changedList = new ArrayList<ILaunchConfiguration>();

        Listener() {
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            this.addedList.add(configuration);
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            this.changedList.add(configuration);
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            this.removedList.add(configuration);
        }

        public List<ILaunchConfiguration> getAdded() {
            return this.addedList;
        }

        public List<ILaunchConfiguration> getChanged() {
            return this.changedList;
        }

        public List<ILaunchConfiguration> getRemoved() {
            return this.removedList;
        }
    }

    static class ResourceItem {
        String path;
        Integer type;

        public ResourceItem(String path, Integer type) {
            this.path = path;
            this.type = type;
        }
    }
}

