/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LaunchFavoriteTests
extends AbstractLaunchTest {
    private ILaunchConfiguration fConfig;

    private LaunchHistory getRunLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
    }

    private LaunchHistory getDebugLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getRunLaunchHistory().setFavorites(new ILaunchConfiguration[0]);
        this.getDebugLaunchHistory().setFavorites(new ILaunchConfiguration[0]);
        this.fConfig = this.getLaunchConfiguration(this.name.getMethodName());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ILaunchConfiguration configuration = this.getLaunchConfiguration();
        if (configuration.exists()) {
            configuration.delete();
        }
        super.tearDown();
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfig;
    }

    private ILaunchConfigurationWorkingCopy addFavorite(ILaunchConfiguration config, String groupId) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(config);
        ArrayList<String> list = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(groupId);
        wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        return wc;
    }

    private ILaunchConfigurationWorkingCopy removeFavorite(ILaunchConfiguration config, String groupId) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(config);
        List list = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
        if (list != null && list.remove(groupId)) {
            if (list.isEmpty()) {
                list = null;
            }
            wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        }
        return wc;
    }

    private ILaunchConfigurationWorkingCopy getWorkingCopy(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = config.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)config : config.getWorkingCopy();
        return wc;
    }

    private boolean containsFavorite(LaunchHistory history, ILaunchConfiguration configuration, int size) {
        Object[] favorites = history.getFavorites();
        Assert.assertNotNull((String)"No favorites", (Object)favorites);
        if (size != -1) {
            Assertions.assertThat((Object[])favorites).hasSize(size);
        }
        Object[] objectArray = favorites;
        int n = favorites.length;
        int n2 = 0;
        while (n2 < n) {
            Object favorite = objectArray[n2];
            if (configuration.equals(favorite)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Test
    public void testBecomeFavorite() throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.addFavorite(this.getLaunchConfiguration(), "org.eclipse.debug.ui.launchGroup.debug");
        this.addFavorite((ILaunchConfiguration)wc, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = wc.doSave();
        Assert.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        Assert.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
    }

    @Test
    public void testUnFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfigurationWorkingCopy wc = this.removeFavorite(this.getLaunchConfiguration(), "org.eclipse.debug.ui.launchGroup.debug");
        this.removeFavorite((ILaunchConfiguration)wc, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = wc.doSave();
        Assert.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 0));
        Assert.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 0));
    }

    @Test
    public void testDeleteConfiguration() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration configuration = this.getLaunchConfiguration();
        configuration.delete();
        Assert.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), configuration, 0));
        Assert.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), configuration, 0));
    }

    @Test
    public void testRenameFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        ILaunchConfiguration saved = copy.doSave();
        Assert.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        Assert.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
        saved.delete();
    }

    @Test
    public void testRenameBecomeFavorite() throws CoreException {
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        this.addFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.debug");
        this.addFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = copy.doSave();
        Assert.assertTrue((String)"Missing from debug favorites", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 1));
        Assert.assertTrue((String)"Missing from run favorites", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 1));
        saved.delete();
    }

    @Test
    public void testRenameUnFavorite() throws CoreException {
        this.testBecomeFavorite();
        ILaunchConfiguration original = this.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = original.getWorkingCopy();
        copy.rename("rename" + original.getName());
        this.removeFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.debug");
        this.removeFavorite((ILaunchConfiguration)copy, "org.eclipse.debug.ui.launchGroup.run");
        ILaunchConfiguration saved = copy.doSave();
        Assert.assertFalse((String)"Should not be a debug favorite", (boolean)this.containsFavorite(this.getDebugLaunchHistory(), saved, 0));
        Assert.assertFalse((String)"Should not be a run favorite", (boolean)this.containsFavorite(this.getRunLaunchHistory(), saved, 0));
        saved.delete();
    }
}

