/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.junit.Assert;
import org.junit.Test;

public class LaunchHistoryTests
extends AbstractLaunchTest {
    private LaunchHistory getRunLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.run");
    }

    private int getMaxHistorySize() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_history_size");
    }

    private void setMaxHistorySize(int value) {
        this.setPreference(DebugUIPlugin.getDefault().getPreferenceStore(), "org.eclipse.debug.ui.max_history_size", value);
    }

    private LaunchHistory getDebugLaunchHistory() {
        return this.getLaunchConfigurationManager().getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug");
    }

    @Test
    public void testHistoryAddition() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    @Test
    public void testHistoriesInSync() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        LaunchHistory debughistory = this.getDebugLaunchHistory();
        Assert.assertNotNull((String)"the debug launch history should not be null", (Object)debughistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"the run history should contain LaunchHistoryTest", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"the run recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        Assert.assertTrue((String)"the debug history should contain LaunchHistoryTest", (boolean)debughistory.contains(config));
        Assert.assertEquals((String)"the debug recent launch should be LaunchHistoryTest", (Object)debughistory.getRecentLaunch(), (Object)config);
    }

    @Test
    public void testHistoryReodering() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        Assert.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest2 config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest2", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    @Test
    public void testRenameConfigHistoryUpdate() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
        copy.rename("RenamedLaunchHistoryItem");
        config = copy.doSave();
        Assert.assertEquals((String)"the renamed config should still be the first on in the history", (Object)runhistory.getRecentLaunch(), (Object)config);
        copy = config.getWorkingCopy();
        copy.rename("LaunchHistoryTest");
        config = copy.doSave();
    }

    @Test
    public void testDeleteLaunchConfigurationHistoryUpdate() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest", (Object)runhistory.getRecentLaunch(), (Object)config);
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        Assert.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"The run history should contain the LaunchHistoryTest2 config", (boolean)runhistory.contains(config));
        Assert.assertEquals((String)"The most recent launch should be LaunchHistoryTest2", (Object)runhistory.getRecentLaunch(), (Object)config);
        config.delete();
        config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertEquals((String)"the run history should have LaunchHistoryTest as the recent launch after delete", (Object)runhistory.getRecentLaunch(), (Object)config);
    }

    @Test
    public void testLaunchHistorySize() throws CoreException {
        LaunchHistory runhistory = this.getRunLaunchHistory();
        Assert.assertNotNull((String)"The run launch history should not be null", (Object)runhistory);
        this.setMaxHistorySize(2);
        Assert.assertTrue((String)"the maximum history size should be 2", (this.getMaxHistorySize() == 2 ? 1 : 0) != 0);
        ILaunchConfiguration config = this.getLaunchConfiguration("LaunchHistoryTest");
        Assert.assertNotNull((String)"LaunchHistoryTest launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        config = this.getLaunchConfiguration("LaunchHistoryTest2");
        Assert.assertNotNull((String)"LaunchHistoryTest2 launch config should not be null", (Object)config);
        config.launch("run", (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertThat((Object[])runhistory.getHistory()).hasSize(this.getMaxHistorySize());
        Assertions.assertThat((Object[])runhistory.getCompleteLaunchHistory()).hasSizeGreaterThanOrEqualTo(runhistory.getHistory().length);
    }
}

