/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.debug.tests.launching.CancellingLaunchDelegate;
import org.eclipse.debug.tests.launching.ThrowingLaunchDelegate;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class LaunchManagerTests
extends AbstractLaunchTest {
    @Test
    public void testGenereateConfigName() {
        String originalName = "launch_configuration";
        String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)originalName, (Object)generatedName);
    }

    @Test
    public void testGenereateConfigNameBadChar() {
        String originalName = "config:name";
        String generatedName = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)originalName, (Object)generatedName);
    }

    @Test
    public void testGenerateValidName() {
        String originalName = "thisisavalidname";
        String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)originalName, (Object)generatedName);
    }

    @Test
    public void testGenerateConfigNameReservedName() {
        if ("win32".equals(Platform.getOS())) {
            String originalName = "aux";
            String generatedName = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(originalName);
            Assert.assertEquals((String)"unexpected generated configuration name", (Object)originalName, (Object)generatedName);
        }
    }

    @Test
    public void testGenerateBadConfigName() {
        String originalName = "config:name";
        String expectedName = "config_name";
        String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
    }

    @Test
    public void testGenerateConflictingName() {
        if ("win32".equals(Platform.getOS())) {
            String originalName = "aux";
            String expectedName = "launch_configuration";
            String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
            Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
        }
    }

    @Test
    public void testGenerateBadCharConflict() throws Exception {
        String originalName = "config:name";
        String expectedName = "config_name";
        String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
        this.getLaunchConfiguration(generatedName);
        expectedName = "config_name (1)";
        generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
        ILaunchConfiguration config = this.getLaunchConfiguration("config_name");
        config.delete();
    }

    @Test
    public void testGenerateBadNameConflict() throws Exception {
        if ("win32".equals(Platform.getOS())) {
            String originalName = "com2";
            String expectedName = "launch_configuration";
            String generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
            Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
            this.getLaunchConfiguration(generatedName);
            expectedName = "launch_configuration (1)";
            generatedName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
            Assert.assertEquals((String)"unexpected generated configuration name", (Object)expectedName, (Object)generatedName);
            ILaunchConfiguration config = this.getLaunchConfiguration("launch_configuration");
            config.delete();
        }
    }

    @Test
    public void testValidateConfigGoodName() {
        String configname = "configname";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)"the config name should not have thrown an exception during validation");
        }
    }

    @Test
    public void testValidateConfigBadCharName() {
        String configname = "config:name";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        Assert.fail((String)"the config name should have thrown an exception during validation");
    }

    @Test
    public void testValidateConfigBadName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "com1";
            try {
                this.getLaunchManager().isValidLaunchConfigurationName(configname);
            }
            catch (IllegalArgumentException iae) {
                return;
            }
            Assert.fail((String)"the config name should have thrown an exception during validation");
        }
    }

    @Test
    public void testGenerateNameExistingConfig() throws Exception {
        String originalName = "x.y.z.configname";
        this.getLaunchConfiguration(originalName);
        String generatedConfigurationName = this.getLaunchManager().generateLaunchConfigurationName(originalName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)(originalName + " (1)"), (Object)generatedConfigurationName);
        this.getLaunchConfiguration(generatedConfigurationName);
        generatedConfigurationName = this.getLaunchManager().generateLaunchConfigurationName(generatedConfigurationName);
        Assert.assertEquals((String)"unexpected generated configuration name", (Object)(originalName + " (2)"), (Object)generatedConfigurationName);
        ILaunchConfiguration config = this.getLaunchConfiguration(originalName);
        if (config != null) {
            config.delete();
        }
        if ((config = this.getLaunchConfiguration(originalName + " (1)")) != null) {
            config.delete();
        }
    }

    @Test
    public void testRemoveAcc() {
        String text = "&Remove";
        String label = LaunchManager.removeAccelerators((String)text);
        Assert.assertEquals((String)"the label should be 'Remove'", (Object)"Remove", (Object)label);
        text = "Remo&ve";
        label = LaunchManager.removeAccelerators((String)text);
        Assert.assertEquals((String)"the label should be 'Remove'", (Object)"Remove", (Object)label);
    }

    ILaunchConfiguration getCancellingConfiguration(boolean pre, boolean fin, boolean build) throws Exception {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType("cancelling.type");
        if (type != null) {
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("cancelling"));
            copy.setAttribute("cancel.preLaunchCheck", !pre);
            copy.setAttribute("cancel.finalLaunchCheck", !fin);
            copy.setAttribute("cancel.buildForLaunch", !build);
            return copy.doSave();
        }
        return null;
    }

    private void hasLaunches(Class<?> type, int count) {
        ILaunch[] launches = this.getLaunchManager().getLaunches();
        int num = 0;
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launche = iLaunchArray[n2];
            if (type.isInstance(launche)) {
                ++num;
            }
            ++n2;
        }
        Assert.assertEquals((String)"The number of expected launches is wrong", (long)count, (long)num);
    }

    void hasCancellingLaunches(int count) {
        this.hasLaunches(CancellingLaunchDelegate.CancellingLaunch.class, count);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testCancelledPreLaunchCheck() throws Exception {
        config = this.getCancellingConfiguration(true, false, false);
        Assert.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(0);
        }
        finally {
            var7_6 = launches = this.getLaunchManager().getLaunches();
            var6_8 = launches.length;
            var5_10 = 0;
            ** while (var5_10 < var6_8)
        }
lbl-1000:
        // 1 sources

        {
            launche = var7_6[var5_10];
            this.getLaunchManager().removeLaunch(launche);
            ++var5_10;
            continue;
        }
lbl18:
        // 1 sources

        config.delete();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testCancelledFinalLaunchCheck() throws Exception {
        config = this.getCancellingConfiguration(false, true, false);
        Assert.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(0);
        }
        finally {
            var7_6 = launches = this.getLaunchManager().getLaunches();
            var6_8 = launches.length;
            var5_10 = 0;
            ** while (var5_10 < var6_8)
        }
lbl-1000:
        // 1 sources

        {
            launche = var7_6[var5_10];
            this.getLaunchManager().removeLaunch(launche);
            ++var5_10;
            continue;
        }
lbl18:
        // 1 sources

        config.delete();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testCancelledBuildForLaunch() throws Exception {
        config = this.getCancellingConfiguration(false, false, true);
        Assert.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(1);
        }
        finally {
            var7_6 = launches = this.getLaunchManager().getLaunches();
            var6_8 = launches.length;
            var5_10 = 0;
            ** while (var5_10 < var6_8)
        }
lbl-1000:
        // 1 sources

        {
            launche = var7_6[var5_10];
            this.getLaunchManager().removeLaunch(launche);
            ++var5_10;
            continue;
        }
lbl18:
        // 1 sources

        config.delete();
    }

    @Test
    public void testNPE_Bug484882() throws Exception {
        final boolean[] stop = new boolean[1];
        final Throwable[] exception = new Throwable[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                ILaunchConfiguration[] config = new ILaunchConfiguration[10000];
                try {
                    int i = 0;
                    while (i < config.length && !stop[0]) {
                        config[i] = LaunchManagerTests.this.getLaunchConfiguration("Name" + i);
                        ++i;
                    }
                    ILaunchConfiguration[] iLaunchConfigurationArray = config;
                    int n = config.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration c = iLaunchConfigurationArray[n2];
                        if (c != null) {
                            c.delete();
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        };
        thread.start();
        try {
            ILaunchManager launchManager = this.getLaunchManager();
            while (thread.isAlive()) {
                launchManager.isExistingLaunchConfigurationName("Name");
            }
        }
        finally {
            stop[0] = true;
            thread.join(1000L);
            Assert.assertFalse((boolean)thread.isAlive());
            if (exception[0] != null) {
                throw new Exception("Exception in Thread", exception[0]);
            }
        }
    }

    private ILaunchConfiguration getThrowingConfiguration(ThrowingLaunchDelegate.ThrowingEnum throwingEnum) throws Exception {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType("throwing.type");
        if (type != null) {
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("throwing " + String.valueOf((Object)throwingEnum)));
            copy.setAttribute("throw.preLaunchCheck", ThrowingLaunchDelegate.ThrowingEnum.preLaunchCheck.equals((Object)throwingEnum));
            copy.setAttribute("throw.finalLaunchCheck", ThrowingLaunchDelegate.ThrowingEnum.finalLaunchCheck.equals((Object)throwingEnum));
            copy.setAttribute("throw.buildForLaunch", ThrowingLaunchDelegate.ThrowingEnum.buildForLaunch.equals((Object)throwingEnum));
            copy.setAttribute("throw.launch", ThrowingLaunchDelegate.ThrowingEnum.launch.equals((Object)throwingEnum));
            return copy.doSave();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void testThrowingLaunchDelegateMethod(ThrowingLaunchDelegate.ThrowingEnum throwingEnum) throws Exception {
        config = this.getThrowingConfiguration(throwingEnum);
        Assert.assertNotNull((String)"The throwing config should have been created", (Object)config);
        try {
            this.hasLaunches(ThrowingLaunchDelegate.ThrowingLaunch.class, 0);
            exception = (CoreException)Assert.assertThrows(CoreException.class, (ThrowingRunnable)(ThrowingRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(org.eclipse.debug.core.ILaunchConfiguration ), ()V)((ILaunchConfiguration)config));
            Assert.assertEquals((String)"Wrong method throwed exception", (Object)exception.getMessage(), (Object)throwingEnum.toString());
            this.hasLaunches(ThrowingLaunchDelegate.ThrowingLaunch.class, 0);
        }
        finally {
            var9_8 = launches = this.getLaunchManager().getLaunches();
            var8_10 = launches.length;
            var7_12 = 0;
            ** while (var7_12 < var8_10)
        }
lbl-1000:
        // 1 sources

        {
            launche = var9_8[var7_12];
            this.getLaunchManager().removeLaunch(launche);
            ++var7_12;
            continue;
        }
lbl18:
        // 1 sources

        config.delete();
    }

    @Test
    public void testThrowingPreLaunchCheck() throws Exception {
        this.testThrowingLaunchDelegateMethod(ThrowingLaunchDelegate.ThrowingEnum.preLaunchCheck);
    }

    @Test
    public void testThrowingFinalLaunchCheck() throws Exception {
        this.testThrowingLaunchDelegateMethod(ThrowingLaunchDelegate.ThrowingEnum.finalLaunchCheck);
    }

    @Test
    public void testThrowingBuildForLaunch() throws Exception {
        this.testThrowingLaunchDelegateMethod(ThrowingLaunchDelegate.ThrowingEnum.buildForLaunch);
    }

    @Test
    public void testThrowingLaunch() throws Exception {
        this.testThrowingLaunchDelegateMethod(ThrowingLaunchDelegate.ThrowingEnum.launch);
    }

    @Test
    public void testToolTipCalculationLogsError() throws Exception {
        LogListener logListener = new LogListener();
        Platform.addLogListener((ILogListener)logListener);
        Event event = new Event();
        Shell shell = DebugUIPlugin.getShell();
        event.widget = shell;
        DebugUIPlugin.getDefault().getLaunchingResourceManager().getfMouseListener().mouseEnter(new MouseEvent(event));
        Thread.sleep(15000L);
        Assert.assertTrue((String)"Tooltip calculation has logged exception", (boolean)logListener.getLogs().isEmpty());
    }

    private static /* synthetic */ void lambda$0(ILaunchConfiguration iLaunchConfiguration) throws Throwable {
        ILaunch iLaunch = iLaunchConfiguration.launch("run", (IProgressMonitor)new NullProgressMonitor(), true, true);
    }

    class LogListener
    implements ILogListener {
        private final Map<String, IStatus> logs = new HashMap<String, IStatus>();

        LogListener() {
        }

        public synchronized void logging(IStatus status, String plugin) {
            this.logs.put(plugin, status);
        }

        Map<String, IStatus> getLogs() {
            return this.logs;
        }
    }
}

