/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LaunchTests
extends AbstractLaunchTest {
    private InvocationHandler handler;
    private Runnable readIsTerminatedTask;
    private Runnable readIsDisconnectedTask;
    private Runnable writeProcessesTask;
    private Runnable writeDebugTargetsTask;
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Launch launch = new Launch(null, "run", null);
        this.handler = (proxy, method, args) -> {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (args.length == 1 && proxy == args[0]) {
                    return true;
                }
                return false;
            }
            return Boolean.TRUE;
        };
        this.readIsTerminatedTask = () -> {
            boolean bl = launch.isTerminated();
        };
        this.readIsDisconnectedTask = () -> {
            boolean bl = launch.isDisconnected();
        };
        this.writeProcessesTask = () -> {
            IProcess process = this.createProcessProxy();
            launch.addProcess(process);
            launch.removeProcess(process);
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            launch.addProcess(process);
            launch.removeProcess(process);
        };
        this.writeDebugTargetsTask = () -> {
            IDebugTarget target2 = this.createDebugTargetProxy();
            launch.addDebugTarget(target2);
            launch.removeDebugTarget(target2);
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            launch.addDebugTarget(target2);
            launch.removeDebugTarget(target2);
        };
    }

    @Test
    public void testTerminatedAndWriteTargets() throws Exception {
        Assert.assertTrue((boolean)this.testExecution(this.readIsTerminatedTask, this.writeDebugTargetsTask));
    }

    @Test
    public void testDisconnectedAndWriteTargets() throws Exception {
        Assert.assertTrue((boolean)this.testExecution(this.readIsDisconnectedTask, this.writeDebugTargetsTask));
    }

    @Test
    public void testTerminatedAndWriteProcesses() throws Exception {
        Assert.assertTrue((boolean)this.testExecution(this.readIsTerminatedTask, this.writeProcessesTask));
    }

    @Test
    public void testDisconnectedAndWriteProcesses() throws Exception {
        Assert.assertTrue((boolean)this.testExecution(this.readIsDisconnectedTask, this.writeProcessesTask));
    }

    @Test
    public void testProcessLaunchWithLongWorkingDirectory() throws CoreException, IOException {
        Assume.assumeTrue((boolean)Platform.OS.isWindows());
        int rootLength = tempFolder.getRoot().toString().length();
        String subPathElementsName = "subfolder-with-relativly-long-name";
        String[] segments = (String[])Collections.nCopies((400 - rootLength) / subPathElementsName.length(), subPathElementsName).toArray(String[]::new);
        File workingDirectory = tempFolder.newFolder(segments);
        Assert.assertTrue((workingDirectory.toString().length() > 300 ? 1 : 0) != 0);
        LaunchTests.startProcessAndAssertOutputContains(List.of("java", "--version"), workingDirectory, false, "jdk");
        LaunchTests.startProcessAndAssertOutputContains(List.of("java", "--version"), workingDirectory, true, "jdk");
    }

    private static void startProcessAndAssertOutputContains(List<String> cmdLine, File workingDirectory, boolean mergeOutput, String expectedOutput) throws CoreException, IOException {
        String output;
        Process process = DebugPlugin.exec((String[])((String[])cmdLine.toArray(String[]::new)), (File)workingDirectory, null, (boolean)mergeOutput);
        Throwable throwable = null;
        Object var7_7 = null;
        try (BufferedReader outputReader = new BufferedReader(process.inputReader());){
            output = outputReader.lines().collect(Collectors.joining());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((String)output.toLowerCase(Locale.ENGLISH)).contains(new CharSequence[]{expectedOutput});
    }

    private boolean testExecution(Runnable readTask, final Runnable writeTask) {
        int maxTrialCount = 2000;
        final Semaphore semaphore = new Semaphore(0);
        final AtomicInteger runs = new AtomicInteger();
        Job job = new Job("modify debug target"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    semaphore.acquire();
                    int i = 0;
                    while (i < 2000) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            writeTask.run();
                            ++i;
                        }
                        catch (Exception e1) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                }
                finally {
                    runs.set(2000);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        semaphore.release();
        try {
            while (runs.get() < 2000) {
                readTask.run();
                if (job.getResult() == null) continue;
                break;
            }
        }
        finally {
            System.out.println(this.name.getMethodName() + " runs: " + String.valueOf(runs));
            job.cancel();
        }
        Assert.assertEquals((long)2000L, (long)runs.get());
        return true;
    }

    private IDebugTarget createDebugTargetProxy() {
        IDebugTarget debugTarget = (IDebugTarget)Proxy.newProxyInstance(LaunchTests.class.getClassLoader(), new Class[]{IDebugTarget.class}, this.handler);
        return debugTarget;
    }

    private IProcess createProcessProxy() {
        IProcess process = (IProcess)Proxy.newProxyInstance(LaunchTests.class.getClassLoader(), new Class[]{IProcess.class, IDisconnect.class}, this.handler);
        return process;
    }
}

