/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.internal.core.RefreshScopeComparator;
import org.eclipse.debug.internal.core.sourcelookup.SourceLocatorMementoComparator;
import org.eclipse.debug.tests.TestsPlugin;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class RefreshTabTests
extends AbstractLaunchTest {
    protected void setSelection(IResource resource) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        Assert.assertNotNull((String)"The active workbench page should not be null", (Object)page);
        try {
            IViewPart part = page.showView("org.eclipse.ui.navigator.ProjectExplorer");
            IWorkbenchPartSite site = part.getSite();
            Assert.assertNotNull((String)"The part site for Project Explorere should not be null ", (Object)site);
            ISelectionProvider provider = site.getSelectionProvider();
            Assert.assertNotNull((String)"the selection provider should not be null for Project Explorer view", (Object)provider);
            provider.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        catch (PartInitException e) {
            Assert.assertNotNull((String)"Failed to open project explorer view", null);
        }
    }

    @Test
    public void testSelectedResource() throws CoreException {
        String scope = "${resource}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{resource});
    }

    @Test
    public void testSelectionsFolder() throws CoreException {
        String scope = "${container}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{resource.getParent()});
    }

    @Test
    public void testSelectionsProject() throws CoreException {
        String scope = "${project}";
        IFolder resource = this.getProject().getFolder("src");
        this.setSelection((IResource)resource);
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{resource.getProject()});
    }

    @Test
    public void testWorkspaceScope() throws CoreException {
        String scope = "${workspace}";
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()});
    }

    @Test
    public void testSpecificResource() throws CoreException {
        String scope = "${resource:/RefreshTabTests/some.file}";
        IFile resource = this.getProject().getFile("some.file");
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{resource});
    }

    @Test
    public void testWorkingSet() throws CoreException {
        String scope = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        IFile resource = this.getProject().getFile("some.file");
        Object[] result = RefreshTab.getRefreshResources((String)scope);
        Assertions.assertThat((Object[])result).containsExactly((Object[])new IResource[]{resource});
    }

    protected IProject getProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("RefreshTabTests");
        if (!project.exists()) {
            project = TestsPlugin.createProject("RefreshTabTests");
            IFolder folder = project.getFolder("src");
            folder.create(false, true, null);
            IFile file = project.getFile("some.file");
            file.create((InputStream)new ByteArrayInputStream("test file".getBytes()), false, null);
        }
        return project;
    }

    @Test
    public void testRefreshScopeComparator() {
        String oldStyle = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        String newStyle = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<resources>\n<item path=\"/RefreshTabTests/some.file\" type=\"1\"/>\n</resources>}";
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new RefreshScopeComparator().compare(oldStyle, newStyle));
        String s1 = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<resources>\n<item path=\"/RefreshTabTests/some.file1\" type=\"1\"/>\n</resources>}";
        String s2 = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<resources>\n<item path=\"/RefreshTabTests/some.file2\" type=\"1\"/>\n</resources>}";
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new RefreshScopeComparator().compare(s1, s1));
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new RefreshScopeComparator().compare(s2, s2));
        Assert.assertEquals((String)"Comparator should return -1", (long)-1L, (long)new RefreshScopeComparator().compare(s1, s2));
        Assert.assertEquals((String)"Comparator should return 1", (long)1L, (long)new RefreshScopeComparator().compare(s2, s1));
        Assert.assertEquals((String)"Comparator should return 1", (long)1L, (long)new RefreshScopeComparator().compare(s1, null));
        Assert.assertEquals((String)"Comparator should return -1", (long)-1L, (long)new RefreshScopeComparator().compare(null, s1));
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new RefreshScopeComparator().compare(null, null));
        String o1 = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file1\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        String o2 = "${working_set:<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<launchConfigurationWorkingSet factoryID=\"org.eclipse.ui.internal.WorkingSetFactory\" name=\"workingSet\" editPageId=\"org.eclipse.ui.resourceWorkingSetPage\">\n<item factoryID=\"org.eclipse.ui.internal.model.ResourceFactory\" path=\"/RefreshTabTests/some.file2\" type=\"1\"/>\n</launchConfigurationWorkingSet>}";
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new SourceLocatorMementoComparator().compare(o1, o1));
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new SourceLocatorMementoComparator().compare(o2, o2));
        Assert.assertEquals((String)"Comparator should return -1", (long)-1L, (long)new SourceLocatorMementoComparator().compare(o1, o2));
        Assert.assertEquals((String)"Comparator should return 1", (long)1L, (long)new SourceLocatorMementoComparator().compare(o2, o1));
        Assert.assertEquals((String)"Comparator should return 1", (long)1L, (long)new SourceLocatorMementoComparator().compare(o1, null));
        Assert.assertEquals((String)"Comparator should return -1", (long)-1L, (long)new SourceLocatorMementoComparator().compare(null, o1));
        Assert.assertEquals((String)"Comparator should return 0", (long)0L, (long)new SourceLocatorMementoComparator().compare(null, null));
    }

    @Test
    public void testResourceMemento() throws CoreException {
        Object[] resources = new IResource[]{this.getProject(), this.getProject().getFile("not.exist"), this.getProject().getFile("some.file")};
        String memento = RefreshUtil.toMemento((IResource[])resources);
        Object[] restore = RefreshUtil.toResources((String)memento);
        Assertions.assertThat((Object[])restore).containsExactly(resources);
    }

    @Test
    public void testEmptyResourceSet() throws CoreException {
        String memento = RefreshUtil.toMemento((IResource[])new IResource[0]);
        Object[] resources = RefreshUtil.toResources((String)memento);
        Assertions.assertThat((Object[])resources).isEmpty();
    }
}

