/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.sourcelookup;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.sourcelookup.TestLaunch;
import org.eclipse.debug.tests.sourcelookup.TestSourceDirector;
import org.eclipse.debug.tests.sourcelookup.TestSourceLocator;
import org.eclipse.debug.tests.sourcelookup.TestStackFrame;
import org.junit.Assert;
import org.junit.Test;

public class SourceLookupFacilityTests
extends AbstractDebugTest {
    TestStackFrame fReusableFrame = new TestStackFrame(new TestLaunch());
    TestSourceDirector fTestDirector = new TestSourceDirector();
    TestSourceLocator fTestLocator = new TestSourceLocator();

    @Test
    public void testLookupStringNoLocatorNoForce() throws Exception {
        try {
            String artifact = "Empty";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, null, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertNull((String)"Source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStringNoForce() throws Exception {
        try {
            String artifact = "One";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertEquals((String)"The results should be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStringForce() throws Exception {
        try {
            String artifact = "Two";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestDirector, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof String));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStringLocatorNoForce() throws Exception {
        try {
            String artifact = "Three";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertNull((String)"The source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeNoForce() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertEquals((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeForce() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestDirector, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeWithDebugElement1() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)new TestStackFrame(null), null, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertNull((String)"Source element should be null", (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeWithDebugElement2() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertEquals((String)"The results should be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeWithDebugElement3() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, null, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeWithDebugElement4() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertEquals((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLookupStackframeWithDebugElement5() throws Exception {
        try {
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            String value = (String)result.getSourceElement();
            result = SourceLookupFacility.getDefault().lookup((Object)this.fReusableFrame, (ISourceLocator)this.fTestLocator, true);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertTrue((String)"The result artifact should be a String", (boolean)(result.getArtifact() instanceof IStackFrame));
            Assert.assertTrue((String)"The result source element should be a String", (boolean)(result.getSourceElement() instanceof String));
            Assert.assertNotSame((String)"The results should not be equal", (Object)value, (Object)result.getSourceElement());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }

    @Test
    public void testLRU() throws Exception {
        try {
            int MAX_LRU_SIZE = 10;
            Field field = SourceLookupFacility.class.getDeclaredField("fLookupResults");
            field.setAccessible(true);
            Map map = (Map)field.get(SourceLookupFacility.getDefault());
            LinkedHashMap<CallSite, SourceLookupResult> cached = new LinkedHashMap<CallSite, SourceLookupResult>();
            int i = 0;
            while (i < 11) {
                String artifact = "" + i;
                SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
                Assert.assertNotNull((String)"There should be a result", (Object)result);
                Assert.assertFalse((boolean)cached.containsValue(result));
                cached.put((CallSite)((Object)artifact), result);
                result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
                Assert.assertTrue((boolean)cached.containsValue(result));
                Assert.assertTrue((map.size() <= 10 ? 1 : 0) != 0);
                ++i;
            }
            Assert.assertEquals((long)10L, (long)map.size());
            Assert.assertFalse((boolean)map.containsValue(cached.values().iterator().next()));
            String artifact = "0";
            SourceLookupResult result = SourceLookupFacility.getDefault().lookup((Object)artifact, (ISourceLocator)this.fTestLocator, false);
            Assert.assertNotNull((String)"There should be a result", (Object)result);
            Assert.assertFalse((boolean)new IdentityHashMap(cached).containsValue(result));
            Assert.assertEquals((long)10L, (long)map.size());
        }
        finally {
            SourceLookupFacility.shutdown();
        }
    }
}

