/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.ui;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.tests.ui.SpyTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.swt.widgets.Display;
import org.junit.Before;
import org.junit.Test;

public class LaunchConfigurationTabGroupViewerTest {
    private static final String LAUNCH_CONFIG_TYPE_ID = "org.eclipse.debug.ui.tests.launchConfigurationType1";
    private static final String LAUNCH_CONFIG_MODE = "run";
    private ILaunchConfigurationType fLaunchConfigurationType;
    private LaunchConfigurationsDialog fLaunchConfigurationsDialog;

    @Before
    public void createDialog() throws CoreException {
        this.fLaunchConfigurationType = this.getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIG_TYPE_ID);
        ILaunchConfigurationTabGroup tabGroup = this.getLaunchConfigurationTabGroup(this.fLaunchConfigurationType);
        this.fLaunchConfigurationsDialog = (LaunchConfigurationsDialog)this.createLaunchConfigurationDialog();
        tabGroup.createTabs((ILaunchConfigurationDialog)this.fLaunchConfigurationsDialog, LAUNCH_CONFIG_MODE);
        Object[] tabs = tabGroup.getTabs();
        Assertions.assertThat((Object[])tabs).hasSizeGreaterThanOrEqualTo(2);
        Assertions.assertThat((Object[])tabs).allSatisfy(tab -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)tab).isInstanceOf(SpyTab.class);
        });
        int typesOfTabs = Math.toIntExact(Arrays.stream(tabs).map(Object::getClass).distinct().count());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])tabs).withFailMessage("there are tabs of the exact same type in the group", new Object[0])).hasSize(typesOfTabs);
    }

    @Test
    public void testAllTabsAreInitializedByDefault() {
        ILaunchConfigurationTab[] tabs;
        ThrowingRunnable createAndSelect1LaunchConfig = () -> this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = this.runOnDialog(createAndSelect1LaunchConfig);
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            Assertions.assertThat((Object)((Object)((SpyTab)tab))).matches(SpyTab::isInitializedExactlyOnce, "should have been initialized exactly once");
            ++n2;
        }
    }

    @Test
    public void testNoTabsAreDeactivatedByDefault() {
        ILaunchConfigurationTab[] tabs;
        ThrowingRunnable createAndSelect1LaunchConfig = () -> this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = this.runOnDialog(createAndSelect1LaunchConfig);
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            Assertions.assertThat((Object)((Object)((SpyTab)tab))).matches(Predicate.not(SpyTab::isDeactivated), "should NOT have been deactivated");
            ++n2;
        }
    }

    @Test
    public void testFirstTabIsActivatedByDefault() {
        ThrowingRunnable createAndSelect1LaunchConfig = () -> this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
        ILaunchConfigurationTab[] tabs = this.runOnDialog(createAndSelect1LaunchConfig);
        SpyTab defaultTab = (SpyTab)tabs[0];
        Assertions.assertThat((Object)((Object)defaultTab)).matches(SpyTab::isActivatedExactlyOnce, "should have been activated exactly once");
        Assertions.assertThat((Object)((Object)defaultTab)).matches(Predicate.not(SpyTab::isDeactivated), "should NOT have been deactivated");
    }

    @Test
    public void testActivatingTabTwiceDoesNotDeactivateIt() {
        int tabIndex = 1;
        ThrowingRunnable selectTabTwice = () -> {
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
            this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(tabIndex);
            this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(tabIndex);
        };
        ILaunchConfigurationTab[] tabs = this.runOnDialog(selectTabTwice);
        SpyTab activeTab = (SpyTab)tabs[tabIndex];
        Assertions.assertThat((Object)((Object)activeTab)).matches(SpyTab::isActivatedExactlyOnce, "should have been activated exactly once");
        Assertions.assertThat((Object)((Object)activeTab)).matches(Predicate.not(SpyTab::isDeactivated), "should NOT have been deactivated");
    }

    @Test
    public void testOtherTabInOtherConfigIsActivated() {
        int secondTabIndex = 1;
        ThrowingRunnable setActiveTab = () -> {
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
            this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(secondTabIndex);
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
        };
        ILaunchConfigurationTab[] tabs = this.runOnDialog(setActiveTab);
        Assertions.assertThat((Object)((Object)((SpyTab)tabs[0]))).matches(Predicate.not(SpyTab::isActivated), "should not have been activated");
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            Assertions.assertThat((Object)((Object)((SpyTab)tab))).matches(Predicate.not(SpyTab::isDeactivated), "should not have been deactivated");
            ++n2;
        }
        Assertions.assertThat((Object)((Object)((SpyTab)tabs[secondTabIndex]))).matches(SpyTab::isActivated, "should have been activated");
    }

    @Test
    public void testOnlyDefaultTabInOtherConfigIsActivated() {
        int overflowTabIndex = Integer.MAX_VALUE;
        ThrowingRunnable setActiveTab = () -> {
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
            this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(overflowTabIndex);
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
        };
        ILaunchConfigurationTab[] tabs = this.runOnDialog(setActiveTab);
        Assertions.assertThat((Object)((Object)((SpyTab)tabs[0]))).matches(SpyTab::isActivated, "Should have been activated");
        int i = 1;
        while (i < tabs.length) {
            Assertions.assertThat((Object)((Object)((SpyTab)tabs[i]))).matches(Predicate.not(SpyTab::isActivated), "Should not have been activated");
            ++i;
        }
    }

    @Test
    public void testOtherTabIsActivated() {
        int secondTabIndex = 1;
        ThrowingRunnable setActiveTab = () -> {
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
            this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(secondTabIndex);
        };
        ILaunchConfigurationTab[] tabs = this.runOnDialog(setActiveTab);
        Assertions.assertThat((Object)((Object)((SpyTab)tabs[secondTabIndex]))).matches(SpyTab::isActivated, "should have been activated");
    }

    @Test
    public void testActivateAllTabs() {
        ThrowingRunnable activateSeveralTab = () -> {
            this.fLaunchConfigurationsDialog.getTabViewer().setInput((Object)this.createLaunchConfigurationInstance());
            int i = 0;
            while (i < this.fLaunchConfigurationsDialog.getTabViewer().getTabs().length) {
                this.fLaunchConfigurationsDialog.getTabViewer().setActiveTab(i);
                ++i;
            }
        };
        ILaunchConfigurationTab[] tabs = this.runOnDialog(activateSeveralTab);
        int i = 0;
        while (i < tabs.length) {
            Assertions.assertThat((Object)((Object)((SpyTab)tabs[i]))).matches(SpyTab::isActivatedExactlyOnce, "Tab '" + i + "' should have been activated exactly once");
            ++i;
        }
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfigurationInstance() throws CoreException {
        return this.fLaunchConfigurationType.newInstance(null, "MyLaunchConfiguration_" + System.currentTimeMillis());
    }

    private <T extends Exception> ILaunchConfigurationTab[] runOnDialog(ThrowingRunnable<T> runnable) {
        AtomicReference tabsRef = new AtomicReference();
        AtomicReference throwableRef = new AtomicReference();
        Display.getCurrent().asyncExec(() -> {
            try {
                try {
                    runnable.run();
                    tabsRef.set(this.fLaunchConfigurationsDialog.getTabs());
                }
                catch (Throwable e) {
                    throwableRef.set(e);
                    this.fLaunchConfigurationsDialog.close();
                }
            }
            finally {
                this.fLaunchConfigurationsDialog.close();
            }
        });
        this.fLaunchConfigurationsDialog.open();
        if (throwableRef.get() != null) {
            throw new AssertionError("An exception occurred while executing the runnable.", (Throwable)throwableRef.get());
        }
        return (ILaunchConfigurationTab[])tabsRef.get();
    }

    protected ILaunchConfigurationTabGroup getLaunchConfigurationTabGroup(ILaunchConfigurationType launchConfigurationType) throws CoreException {
        return LaunchConfigurationPresentationManager.getDefault().getTabGroup(launchConfigurationType, LAUNCH_CONFIG_MODE);
    }

    protected ILaunchConfigurationDialog createLaunchConfigurationDialog() {
        return new LaunchConfigurationsDialog(null, DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug"));
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private static interface ThrowingRunnable<T extends Exception> {
        public void run() throws T;
    }
}

