/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.view.memory;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.view.memory.DynamicRenderingBindings;
import org.eclipse.debug.tests.view.memory.MemoryBlockDynamic;
import org.eclipse.debug.tests.view.memory.MemoryBlockOne;
import org.eclipse.debug.tests.view.memory.MemoryBlockThree;
import org.eclipse.debug.tests.view.memory.MemoryBlockTwo;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.junit.Assert;
import org.junit.Test;

public class MemoryRenderingTests
extends AbstractDebugTest {
    @Test
    public void testRenderingTypes() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        Object[] types = manager.getRenderingTypes();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of contributed rendering types", new Object[0])).hasSizeGreaterThan(6);
        Assert.assertTrue((String)"Missing type 1", (this.indexOf(manager.getRenderingType("rendering_type_1"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type 2", (this.indexOf(manager.getRenderingType("rendering_type_2"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type 3", (this.indexOf(manager.getRenderingType("rendering_type_3"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.raw_memory"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.ascii"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.signedint"), types) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Missing type", (this.indexOf(manager.getRenderingType("org.eclipse.debug.ui.rendering.unsignedint"), types) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRenderingTypeNames() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        IMemoryRenderingType type = manager.getRenderingType("rendering_type_1");
        Assert.assertEquals((String)"Wrong name", (Object)"Rendering One", (Object)type.getLabel());
        type = manager.getRenderingType("rendering_type_2");
        Assert.assertEquals((String)"Wrong name", (Object)"Rendering Two", (Object)type.getLabel());
    }

    @Test
    public void testSingleBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        Object[] types = manager.getRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_1");
        }});
    }

    @Test
    public void testDoubleBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        Object[] types = manager.getRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(2)).satisfiesExactly(new ThrowingConsumer[]{firstBinding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)firstBinding.getId()).isEqualTo("rendering_type_1");
        }, secondBinding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)secondBinding.getId()).isEqualTo("rendering_type_2");
        }});
    }

    @Test
    public void testDefaultBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        Object[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_1");
        }});
    }

    @Test
    public void testNoDefaultBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        Object[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).isEmpty();
    }

    @Test
    public void testPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockOne block = new MemoryBlockOne();
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        Assert.assertEquals((String)"Wrong binding", (Object)"rendering_type_1", (Object)type.getId());
    }

    @Test
    public void testNoPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockTwo block = new MemoryBlockTwo();
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        Assert.assertNull((String)"Wrong binding", (Object)type);
    }

    @Test
    public void testDefaultWithoutPrimaryBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockThree block = new MemoryBlockThree();
        Object[] types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_3");
        }});
    }

    @Test
    public void testDynamicBinding() {
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockDynamic block = new MemoryBlockDynamic();
        Object[] types = manager.getRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_1");
        }});
        types = manager.getDefaultRenderingTypes((IMemoryBlock)block);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
            AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_1");
        }});
        IMemoryRenderingType type = manager.getPrimaryRenderingType((IMemoryBlock)block);
        ((ObjectAssert)Assertions.assertThat((Object)type).as("has correct binding", new Object[0])).isEqualTo((Object)manager.getRenderingType("rendering_type_1"));
    }

    @Test
    public void testBindingChangeNotification() {
        boolean[] changed = new boolean[1];
        IMemoryRenderingBindingsListener listener = () -> {
            boolean bl = blArray[0] = true;
        };
        IMemoryRenderingManager manager = DebugUITools.getMemoryRenderingManager();
        MemoryBlockDynamic block = new MemoryBlockDynamic();
        Object[] types = manager.getRenderingTypes((IMemoryBlock)block);
        try {
            manager.addListener(listener);
            Assert.assertFalse((String)"Renderings should not have changed yet", (boolean)changed[0]);
            DynamicRenderingBindings.setBinding("rendering_type_2");
            Assert.assertTrue((String)"Renderings should have changed", (boolean)changed[0]);
            types = manager.getRenderingTypes((IMemoryBlock)block);
            ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])types).as("number of bindings", new Object[0])).hasSize(1)).satisfiesExactly(new ThrowingConsumer[]{binding -> {
                AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)binding.getId()).isEqualTo("rendering_type_2");
            }});
        }
        finally {
            DynamicRenderingBindings.setBinding("rendering_type_1");
            manager.removeListener(listener);
        }
    }

    protected int indexOf(Object thing, Object[] list) {
        int i = 0;
        while (i < list.length) {
            Object object2 = list[i];
            if (object2.equals(thing)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

