/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.view.memory;

import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.HexIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.SignedIntegerRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.UnsignedIntegerRendering;
import org.eclipse.debug.tests.view.memory.TableRenderingTestsMemoryBlock;
import org.junit.Assert;
import org.junit.Test;

public class TableRenderingTests {
    private static final byte[] BYTES_1 = new byte[]{-121};
    private static final byte[] BYTES_2 = new byte[]{-104, 118};
    private static final byte[] BYTES_4 = new byte[]{-70, -104, 118, 84};
    private static final byte[] BYTES_8 = new byte[]{-2, -36, -70, -104, 118, 84, 50, 16};
    private static final byte[] BYTES_16 = new byte[16];
    private static final byte[] BYTES_24 = new byte[24];

    static {
        TableRenderingTests.BYTES_16[0] = -128;
        TableRenderingTests.BYTES_24[0] = -128;
    }

    @Test
    public void testHexIntegerRendering() throws DebugException {
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(1), BYTES_1, "87", "87");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(1), BYTES_2, "9876", "7698");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(2), BYTES_2, "9876", "9876");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(1), BYTES_4, "BA987654", "547698BA");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(2), BYTES_4, "BA987654", "7654BA98");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(4), BYTES_4, "BA987654", "BA987654");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(1), BYTES_8, "FEDCBA9876543210", "1032547698BADCFE");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(4), BYTES_8, "FEDCBA9876543210", "76543210FEDCBA98");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(4), BYTES_16, "80000000000000000000000000000000", "00000000000000000000000080000000");
        this.testIntegerRendering((AbstractIntegerRendering)this.createHexIntegerRendering(4), BYTES_24, "800000000000000000000000000000000000000000000000", "000000000000000000000000000000000000000080000000");
    }

    @Test
    public void testSignedIntegerRendering() throws DebugException {
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(1, BYTES_1.length), BYTES_1, "-121", "-121");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(1, BYTES_2.length), BYTES_2, "-26506", "30360");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(2, BYTES_2.length), BYTES_2, "-26506", "-26506");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(1, BYTES_4.length), BYTES_4, "-1164413356", "1417058490");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(2, BYTES_4.length), BYTES_4, "-1164413356", "1985264280");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(4, BYTES_4.length), BYTES_4, "-1164413356", "-1164413356");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(1, BYTES_8.length), BYTES_8, "-81985529216486896", "1167088121787636990");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(4, BYTES_8.length), BYTES_8, "-81985529216486896", "8526495043095935640");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(8, BYTES_8.length), BYTES_8, "-81985529216486896", "-81985529216486896");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(2, BYTES_16.length), BYTES_16, BigInteger.valueOf(2L).pow(127).negate().toString(), "32768");
        this.testIntegerRendering((AbstractIntegerRendering)this.createSignedIntegerRendering(2, BYTES_24.length), BYTES_24, BigInteger.valueOf(2L).pow(191).negate().toString(), "32768");
    }

    @Test
    public void testUnsignedIntegerRendering() throws DebugException {
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(1, BYTES_1.length), BYTES_1, "135", "135");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(1, BYTES_2.length), BYTES_2, "39030", "30360");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(2, BYTES_2.length), BYTES_2, "39030", "39030");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(1, BYTES_4.length), BYTES_4, "3130553940", "1417058490");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(2, BYTES_4.length), BYTES_4, "3130553940", "1985264280");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(4, BYTES_4.length), BYTES_4, "3130553940", "3130553940");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(1, BYTES_8.length), BYTES_8, "18364758544493064720", "1167088121787636990");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(4, BYTES_8.length), BYTES_8, "18364758544493064720", "8526495043095935640");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(8, BYTES_8.length), BYTES_8, "18364758544493064720", "18364758544493064720");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(2, BYTES_16.length), BYTES_16, BigInteger.valueOf(2L).pow(127).toString(), "32768");
        this.testIntegerRendering((AbstractIntegerRendering)this.createUnsignedIntegerRendering(2, BYTES_24.length), BYTES_24, BigInteger.valueOf(2L).pow(191).toString(), "32768");
    }

    private void testIntegerRendering(AbstractIntegerRendering rendering, byte[] bytes, String bigEndianString, String littleEndianString) throws DebugException {
        TableRenderingTestsMemoryBlock block = new TableRenderingTestsMemoryBlock(bytes, rendering.getAddressableSize());
        rendering.init(null, (IMemoryBlock)block);
        MemoryByte[] memoryBytes = block.getBytesFromOffset(BigInteger.ZERO, bytes.length / rendering.getAddressableSize());
        rendering.setDisplayEndianess(1);
        Assert.assertEquals((Object)bigEndianString, (Object)rendering.getString(null, null, memoryBytes));
        Assertions.assertThat((byte[])rendering.getBytes(null, null, memoryBytes, bigEndianString)).containsExactly(bytes);
        rendering.setDisplayEndianess(0);
        Assert.assertEquals((Object)littleEndianString, (Object)rendering.getString(null, null, memoryBytes));
        Assertions.assertThat((byte[])rendering.getBytes(null, null, memoryBytes, littleEndianString)).containsExactly(bytes);
    }

    private HexIntegerRendering createHexIntegerRendering(final int addressableSize) {
        return new HexIntegerRendering(null){

            public int getAddressableSize() {
                return addressableSize;
            }
        };
    }

    private SignedIntegerRendering createSignedIntegerRendering(final int addressableSize, final int bytesPerColumn) {
        return new SignedIntegerRendering(null){

            public int getAddressableSize() {
                return addressableSize;
            }

            public int getBytesPerColumn() {
                return bytesPerColumn;
            }
        };
    }

    private UnsignedIntegerRendering createUnsignedIntegerRendering(final int addressableSize, final int bytesPerColumn) {
        return new UnsignedIntegerRendering(null){

            public int getAddressableSize() {
                return addressableSize;
            }

            public int getBytesPerColumn() {
                return bytesPerColumn;
            }
        };
    }
}

