/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.function.Function;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractViewerModelTest
extends AbstractDebugTest {
    Display fDisplay;
    Shell fShell;
    IInternalTreeModelViewer fViewer;
    TestModelUpdatesListener fListener;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setMaximized(true);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer(this.fDisplay, this.fShell);
        this.fListener = this.createListener(this.fViewer);
        this.fShell.open();
        TestUtil.processUIEvents();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        TestUtil.processUIEvents();
        super.tearDown();
    }

    protected abstract IInternalTreeModelViewer createViewer(Display var1, Shell var2);

    protected abstract TestModelUpdatesListener createListener(IInternalTreeModelViewer var1);

    protected Function<AbstractDebugTest, String> createListenerErrorMessage() {
        return t -> "Listener not finished: " + String.valueOf(this.fListener);
    }
}

