/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.TreePath;
import org.junit.Assert;
import org.junit.Test;

public abstract class CheckTests
extends AbstractViewerModelTest {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, false, false);
    }

    @Test
    public void testSimpleSingleLevel() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    @Test
    public void testSimpleMultiLevel() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    @Test
    public void testCheckReceiver() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        boolean initialCheckState = element.getChecked();
        TreePath elementPath = new TreePath(new Object[]{element});
        ModelDelta delta = model.setElementChecked(elementPath, true, false);
        this.fListener.reset(elementPath, element, -1, true, false);
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        Assert.assertTrue((boolean)(element.getChecked() ^ initialCheckState));
    }

    @Test
    public void testUpdateCheck() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        TestModel.TestElement element = model.getRootElement().getChildren()[0];
        TreePath elementPath = new TreePath(new Object[]{element});
        ModelDelta delta = model.setElementChecked(elementPath, false, false);
        this.fListener.reset(elementPath, element, -1, true, false);
        model.postDelta((IModelDelta)delta);
        this.waitWhile(t -> !this.fListener.isFinished(8261), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }
}

