/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnPresentationTests
extends AbstractDebugTest
implements ITestModelUpdatesListenerConstants {
    private Display fDisplay;
    private Shell fShell;
    private TreeModelViewer fViewer;
    private TestModelUpdatesListener fListener;
    private boolean fResized = false;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createViewer();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.destroyViewer();
        super.tearDown();
    }

    void createViewer() {
        this.fDisplay = PlatformUI.getWorkbench().getDisplay();
        this.fShell = new Shell(this.fDisplay);
        this.fShell.setSize(800, 600);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = new TreeModelViewer((Composite)this.fShell, 0x10000000, (IPresentationContext)new PresentationContext("TestViewer"));
        this.fViewer.getTree().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ColumnPresentationTests.this.fResized = true;
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.fListener = new TestModelUpdatesListener((ITreeModelViewer)this.fViewer, false, false);
        this.fShell.open();
        TestUtil.processUIEvents();
    }

    void destroyViewer() throws Exception {
        this.fListener.dispose();
        this.fViewer.getPresentationContext().dispose();
        this.fShell.close();
        TestUtil.processUIEvents();
    }

    void recreateViewer() throws Exception {
        this.destroyViewer();
        this.createViewer();
    }

    private TestModel makeModel(MyColumnPresentation cp, String rootSufffix) throws Exception {
        MyModel model = new MyModel(cp);
        model.setRoot(new TestModel.TestElement(model, "root" + rootSufffix, new TestModel.TestElement[]{new TestModel.TestElement(model, "1", true, true, new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", true, false, new TestModel.TestElement[0]), new TestModel.TestElement(model, "3", false, true, new TestModel.TestElement[0]), new TestModel.TestElement(model, "4", false, false, new TestModel.TestElement[0]), new TestModel.TestElement(model, "5", new TestModel.TestElement[0]), new TestModel.TestElement(model, "6", new TestModel.TestElement[0])}));
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        return model;
    }

    @Test
    public void testInitialColumnAverageWidth() throws Exception {
        this.fResized = false;
        MyColumnPresentation colPre = new MyColumnPresentation();
        this.makeModel(colPre, "m1");
        Tree tree = this.fViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        int treeWidth = tree.getSize().x;
        int avgWidth = treeWidth / columns.length;
        if (this.fResized) {
            return;
        }
        int i = 0;
        while (i < columns.length - 1) {
            Assert.assertEquals((long)avgWidth, (long)columns[i].getWidth());
            ++i;
        }
    }

    @Test
    public void testInitialColumnWidth() throws Exception {
        this.fResized = false;
        MyColumnPresentation2 colPre = new MyColumnPresentation2();
        this.makeModel(colPre, "m2");
        Tree tree = this.fViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        if (this.fResized) {
            return;
        }
        int i = 0;
        while (i < columns.length) {
            int width = colPre.repliedWidths[i];
            if (width != -1) {
                Assert.assertEquals((long)width, (long)columns[i].getWidth());
            }
            ++i;
        }
    }

    @Test
    public void testRespectUserSettings() throws Exception {
        MyColumnPresentation2 colPre = new MyColumnPresentation2();
        this.makeModel(colPre, "m2");
        TreeColumn[] columns = this.fViewer.getTree().getColumns();
        int[] newWidths = new int[columns.length];
        int i = 0;
        while (i < columns.length) {
            newWidths[i] = columns[i].getWidth() + 10;
            columns[i].setWidth(newWidths[i]);
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            Assert.assertEquals((long)newWidths[i], (long)columns[i].getWidth());
            ++i;
        }
        this.makeModel(new MyColumnPresentation(), "m1");
        this.makeModel(colPre, "m3");
        columns = this.fViewer.getTree().getColumns();
        i = 0;
        while (i < columns.length) {
            Assert.assertEquals((long)newWidths[i], (long)columns[i].getWidth());
            ++i;
        }
        this.fViewer.setShowColumns(false);
        TestUtil.processUIEvents();
        this.waitWhile(t -> this.fViewer.getTree().getColumns().length > 0, this.createColumnsErrorMessage());
        this.fViewer.setShowColumns(true);
        TestUtil.processUIEvents();
        this.waitWhile(t -> this.fViewer.getTree().getColumns().length != newWidths.length, this.createColumnsErrorMessage());
        columns = this.fViewer.getTree().getColumns();
        i = 0;
        while (i < columns.length) {
            Assert.assertEquals((long)newWidths[i], (long)columns[i].getWidth());
            ++i;
        }
    }

    @Test
    public void testRespectMemento() throws Exception {
        MyColumnPresentation2 colPre = new MyColumnPresentation2();
        this.makeModel(colPre, "m2");
        TreeColumn[] columns = this.fViewer.getTree().getColumns();
        int[] newWidths = new int[columns.length];
        int i = 0;
        while (i < columns.length) {
            newWidths[i] = columns[i].getWidth() + 10;
            columns[i].setWidth(newWidths[i]);
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            Assert.assertEquals((long)newWidths[i], (long)columns[i].getWidth());
            ++i;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"TEST");
        this.fViewer.saveState((IMemento)memento);
        this.recreateViewer();
        this.fViewer.initState((IMemento)memento);
        this.makeModel(colPre, "m2");
        columns = this.fViewer.getTree().getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            Assert.assertEquals((long)newWidths[i2], (long)columns[i2].getWidth());
            ++i2;
        }
    }

    @Test
    public void testChangedColumnIds() throws Exception {
        MyColumnPresentation colPre = new MyColumnPresentation();
        this.makeModel(colPre, "m1");
        TreeColumn[] columns = this.fViewer.getTree().getColumns();
        this.fViewer.setVisibleColumns(new String[]{colPre.columnIds[0]});
        TestUtil.processUIEvents();
        this.waitWhile(t -> this.fViewer.getTree().getColumns().length != 1, this.createColumnsErrorMessage());
        this.makeModel(new MyColumnPresentation2(), "m2");
        String[] newColumnIds = MyColumnPresentation.makeDefaultColumnIds();
        newColumnIds[0] = "new_column_id";
        colPre = new MyColumnPresentation(newColumnIds);
        this.makeModel(colPre, "m3");
        columns = this.fViewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            Assert.assertEquals((Object)newColumnIds[i], (Object)columns[i].getText());
            ++i;
        }
    }

    private Function<AbstractDebugTest, String> createColumnsErrorMessage() {
        return t -> "Unexpected columns number: " + this.fViewer.getTree().getColumns().length;
    }

    private Function<AbstractDebugTest, String> createListenerErrorMessage() {
        return t -> "Listener not finished: " + String.valueOf(this.fListener);
    }

    static class MyColumnPresentation
    implements IColumnPresentation {
        private IPresentationContext fContext;
        protected String[] columnIds;

        MyColumnPresentation() {
            this(MyColumnPresentation.makeDefaultColumnIds());
        }

        static String[] makeDefaultColumnIds() {
            String[] columnIds = new String[5];
            int i = 0;
            while (i < columnIds.length) {
                columnIds[i] = "ColumnId_" + i;
                ++i;
            }
            return columnIds;
        }

        MyColumnPresentation(String[] columnIds) {
            this.columnIds = columnIds;
        }

        public void init(IPresentationContext context) {
            this.fContext = context;
        }

        public void dispose() {
            this.fContext = null;
        }

        public ImageDescriptor getImageDescriptor(String id) {
            return null;
        }

        protected IPresentationContext getPresentationContext() {
            return this.fContext;
        }

        public String[] getAvailableColumns() {
            return this.columnIds;
        }

        public String[] getInitialColumns() {
            return this.columnIds;
        }

        public String getHeader(String id) {
            if (Arrays.asList(this.columnIds).indexOf(id) != -1) {
                return id;
            }
            return null;
        }

        public String getId() {
            return "MyColumnPresentationID";
        }

        public boolean isOptional() {
            return true;
        }
    }

    static class MyColumnPresentation2
    extends MyColumnPresentation
    implements IColumnPresentation2 {
        int[] repliedWidths;

        MyColumnPresentation2() {
            int i = 0;
            while (i < this.columnIds.length) {
                int n = i++;
                this.columnIds[n] = String.valueOf(this.columnIds[n]) + "_2";
            }
            this.repliedWidths = new int[this.columnIds.length];
            Arrays.fill(this.repliedWidths, -2);
        }

        public int getInitialColumnWidth(String id, int treeWidgetWidth, String[] visibleColumnIds) {
            int i = 0;
            while (i < this.columnIds.length) {
                if (id.equals(this.columnIds[i]) && i == 0) {
                    this.repliedWidths[i] = 2 * (treeWidgetWidth / visibleColumnIds.length);
                    return this.repliedWidths[i];
                }
                if (id.equals(this.columnIds[i]) && (i == 1 || i == 2)) {
                    this.repliedWidths[i] = treeWidgetWidth / visibleColumnIds.length / 2;
                    return this.repliedWidths[i];
                }
                if (id.equals(this.columnIds[i]) && i == 3) {
                    this.repliedWidths[i] = treeWidgetWidth / visibleColumnIds.length;
                    return this.repliedWidths[i];
                }
                if (id.equals(this.columnIds[i]) && i == 4) {
                    this.repliedWidths[i] = -1;
                    return this.repliedWidths[i];
                }
                ++i;
            }
            return -1;
        }

        @Override
        public String getId() {
            return "MyColumnPresentation2ID";
        }
    }

    static class MyModel
    extends TestModel
    implements IColumnPresentationFactory {
        MyColumnPresentation colPresenation;

        MyModel(MyColumnPresentation cp1) {
            this.colPresenation = cp1;
        }

        public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
            if (this.colPresenation != null) {
                return this.colPresenation;
            }
            return null;
        }

        public String getColumnPresentationId(IPresentationContext context, Object element) {
            if (this.colPresenation != null) {
                return this.colPresenation.getId();
            }
            return null;
        }
    }
}

