/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.TreePath;
import org.junit.Assert;
import org.junit.Test;

public abstract class ContentTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, true, true);
    }

    @Test
    public void testSimpleSingleLevel() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Assert.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 6));
    }

    @Test
    public void testSimpleMultiLevel() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
        Assert.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 3));
    }

    @Test
    public void testLabelUpdatesCompletedOutOfSequence1() throws Exception {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureLabelUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> testModelWithCapturedUpdates.fCapturedUpdates.size() < testModelWithCapturedUpdates.getRootElement().fChildren.length, this.createModelErrorMessage(model));
        List<IViewerUpdate> firstUpdates = model.fCapturedUpdates;
        model.fCapturedUpdates = Collections.synchronizedList(new ArrayList(2));
        model.getElement(model.findElement("1")).setLabelAppendix(" - changed");
        model.getElement(model.findElement("2")).setLabelAppendix(" - changed");
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> testModelWithCapturedUpdates.fCapturedUpdates.size() < testModelWithCapturedUpdates.getRootElement().fChildren.length, this.createModelErrorMessage(model));
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            model.fCapturedUpdates.get(i).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.size()) {
            ILabelUpdate capturedUpdate = (ILabelUpdate)firstUpdates.get(i);
            Assert.assertTrue((boolean)capturedUpdate.isCanceled());
            capturedUpdate.done();
            ++i;
        }
        this.waitWhile(t -> !this.fListener.isFinished(32), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    private Function<AbstractDebugTest, String> createModelErrorMessage(TestModelWithCapturedUpdates model) {
        return t -> "Unxexpected model state: captured updates: " + String.valueOf(testModelWithCapturedUpdates.fCapturedUpdates) + ", root children: " + Arrays.toString((Object[])testModelWithCapturedUpdates.getRootElement().fChildren);
    }

    @Test
    public void testLabelUpdatesCompletedOutOfSequence2() throws Exception {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureLabelUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> testModelWithCapturedUpdates.fCapturedUpdates.size() < testModelWithCapturedUpdates.getRootElement().fChildren.length, this.createModelErrorMessage(model));
        List<IViewerUpdate> firstUpdates = model.fCapturedUpdates;
        model.fCapturedUpdates = Collections.synchronizedList(new ArrayList(2));
        model.setElementChildren(TreePath.EMPTY, new TestModel.TestElement[]{new TestModel.TestElement(model, "1-new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2-new", new TestModel.TestElement[0])});
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> testModelWithCapturedUpdates.fCapturedUpdates.size() < testModelWithCapturedUpdates.getRootElement().fChildren.length, this.createModelErrorMessage(model));
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            model.fCapturedUpdates.get(i).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.size()) {
            ILabelUpdate capturedUpdate = (ILabelUpdate)firstUpdates.get(i);
            Assert.assertTrue((boolean)capturedUpdate.isCanceled());
            capturedUpdate.done();
            ++i;
        }
        this.waitWhile(t -> !this.fListener.isFinished(32), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    public void _x_testChildrenUpdatesCompletedOutOfSequence() throws Exception {
        TestModelWithCapturedUpdates model = new TestModelWithCapturedUpdates();
        model.fCaptureChildrenUpdates = true;
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{new TestModel.TestElement(model, "1", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2", new TestModel.TestElement[0])}));
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.areCapturedChildrenUpdatesComplete(testModelWithCapturedUpdates.fCapturedUpdates, testModelWithCapturedUpdates.getRootElement().fChildren.length), this.createModelErrorMessage(model));
        IChildrenUpdate[] firstUpdates = model.fCapturedUpdates.toArray(new IChildrenUpdate[0]);
        model.fCapturedUpdates.clear();
        model.setElementChildren(TreePath.EMPTY, new TestModel.TestElement[]{new TestModel.TestElement(model, "1-new", new TestModel.TestElement[0]), new TestModel.TestElement(model, "2-new", new TestModel.TestElement[0])});
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, false, false);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.areCapturedChildrenUpdatesComplete(testModelWithCapturedUpdates.fCapturedUpdates, testModelWithCapturedUpdates.getRootElement().fChildren.length), this.createModelErrorMessage(model));
        int i = 0;
        while (i < model.fCapturedUpdates.size()) {
            model.fCapturedUpdates.get(i).done();
            ++i;
        }
        i = 0;
        while (i < firstUpdates.length) {
            firstUpdates[i].done();
            ++i;
        }
        this.waitWhile(t -> !this.fListener.isFinished(32), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY);
    }

    private boolean areCapturedChildrenUpdatesComplete(List<IViewerUpdate> capturedUpdates, int childCount) {
        ArrayList<Integer> expectedChildren = new ArrayList<Integer>();
        int i = 0;
        while (i < childCount) {
            expectedChildren.add(i);
            ++i;
        }
        IChildrenUpdate[] updates = capturedUpdates.toArray(new IChildrenUpdate[0]);
        int i2 = 0;
        while (i2 < updates.length) {
            int j = 0;
            while (j < updates[i2].getLength()) {
                expectedChildren.remove((Object)(updates[i2].getOffset() + j));
                ++j;
            }
            ++i2;
        }
        return expectedChildren.isEmpty();
    }

    static class TestModelWithCapturedUpdates
    extends TestModel {
        boolean fCaptureLabelUpdates = false;
        boolean fCaptureChildrenUpdates = false;
        List<IViewerUpdate> fCapturedUpdates = Collections.synchronizedList(new ArrayList());

        TestModelWithCapturedUpdates() {
        }

        @Override
        public void update(IChildrenUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                TestModel.TestElement element = (TestModel.TestElement)((Object)updates[i].getElement());
                int endOffset = updates[i].getOffset() + updates[i].getLength();
                int j = updates[i].getOffset();
                while (j < endOffset) {
                    if (j < element.getChildren().length) {
                        updates[i].setChild((Object)element.getChildren()[j], j);
                    }
                    ++j;
                }
                if (this.fCaptureChildrenUpdates) {
                    this.fCapturedUpdates.add((IViewerUpdate)updates[i]);
                } else {
                    updates[i].done();
                }
                ++i;
            }
        }

        @Override
        public void update(ILabelUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                TestModel.TestElement element = (TestModel.TestElement)((Object)updates[i].getElement());
                updates[i].setLabel(element.getLabel(), 0);
                if (updates[i] instanceof ICheckUpdate && Boolean.TRUE.equals(updates[i].getPresentationContext().getProperty("org.eclipse.debug.ui.check"))) {
                    ((ICheckUpdate)updates[i]).setChecked(element.getChecked(), element.getGrayed());
                }
                if (this.fCaptureLabelUpdates) {
                    this.fCapturedUpdates.add((IViewerUpdate)updates[i]);
                } else {
                    updates[i].done();
                }
                ++i;
            }
        }
    }
}

