/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewerFilter;
import org.eclipse.debug.tests.TestUtil;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.StateTests;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.junit.Assert;
import org.junit.Test;

public abstract class FilterTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, true, true);
    }

    protected IInternalTreeModelViewer getInternalViewer() {
        return this.fViewer;
    }

    @Test
    public void testSimpleSingleLevel() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter("2")});
    }

    @Test
    public void testSimpleSingleLevelWithTMVFilter() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter("2", (Object)model.getRootElement())});
    }

    @Test
    public void testSimpleSingleLevelWithMixedFilters() throws Exception {
        TestModel model = TestModel.simpleSingleLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter("2", (Object)model.getRootElement()), new TestViewerFilter("1")});
    }

    @Test
    public void testSimpleMultiLevel() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter(".1"), new TestViewerFilter(".2")});
    }

    @Test
    public void testSimpleMultiLevelWithTMVFilter() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestTMVFilter(".1", null), new TestTMVFilter(".2", null)});
    }

    @Test
    public void testSimpleMultiLevelWithMixedFilters() throws Exception {
        TestModel model = TestModel.simpleMultiLevel();
        this.doTestSimpleLevel(model, new ViewerFilter[]{new TestViewerFilter(".1"), new TestTMVFilter(".2", null)});
    }

    private void doTestSimpleLevel(TestModel model, ViewerFilter[] filters) throws Exception {
        this.fViewer.setAutoExpandLevel(-1);
        this.fViewer.setFilters(filters);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), filters, -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, false, filters);
    }

    @Test
    public void testLargeSingleLevel() throws Exception {
        this.doTestLargeSingleLevel(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    @Test
    public void testLargeSingleLevelWithTMVFilter() throws Exception {
        this.doTestLargeSingleLevel(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestLargeSingleLevel(ViewerFilter[] filters) throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 3000, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
    }

    @Test
    public void testReplacedUnrealizedFilteredElement() throws Exception {
        this.doTestReplacedUnrealizedFilteredElement(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    @Test
    public void testReplacedUnrealizedFilteredElementWithTMVFilter() throws Exception {
        this.doTestReplacedUnrealizedFilteredElement(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestReplacedUnrealizedFilteredElement(ViewerFilter[] filters) throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 300, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        TestModel.TestElement replacedElement = new TestModel.TestElement(model, "replaced element", new TestModel.TestElement[0]);
        ModelDelta replaceDelta = model.replaceElementChild(TreePath.EMPTY, 200, replacedElement);
        this.fListener.reset();
        model.postDelta((IModelDelta)replaceDelta);
        this.waitWhile(t -> !this.fListener.isFinished(64), this.createListenerErrorMessage());
        this.fListener.reset();
        this.fViewer.reveal(TreePath.EMPTY, 150);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        Object[] replacedElementPaths = this.fViewer.getElementPaths((Object)replacedElement);
        Assertions.assertThat((Object[])replacedElementPaths).hasSizeGreaterThan(0);
    }

    @Test
    public void testRefreshUnrealizedFilteredElement() throws Exception {
        this.doTestRefreshUnrealizedFilteredElement(new ViewerFilter[]{new TestViewerFilter("2")});
    }

    @Test
    public void testRefreshUnrealizedFilteredElementWithTMVFilter() throws Exception {
        this.doTestRefreshUnrealizedFilteredElement(new ViewerFilter[]{new TestTMVFilter("2", null)});
    }

    private void doTestRefreshUnrealizedFilteredElement(ViewerFilter[] filters) throws Exception {
        TestModel model = new TestModel();
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[0]));
        model.setElementChildren(TreePath.EMPTY, TestModel.makeSingleLevelModelElements(model, 300, "model."));
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        TestModel.TestElement replacedElement = new TestModel.TestElement(model, "replaced element", new TestModel.TestElement[0]);
        model.replaceElementChild(TreePath.EMPTY, 200, replacedElement);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        this.fListener.reset();
        this.fViewer.reveal(TreePath.EMPTY, 150);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        Object[] replacedElementPaths = this.fViewer.getElementPaths((Object)replacedElement);
        Assertions.assertThat((Object[])replacedElementPaths).hasSizeGreaterThan(0);
    }

    @Test
    public void testRefreshToUnfilterElements() throws Exception {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestViewerFilter(".1"), new TestViewerFilter(".2")});
    }

    @Test
    public void testRefreshToUnfilterElementsWithTMVFilter() throws Exception {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestTMVFilter(".1", null), new TestTMVFilter(".2", null)});
    }

    @Test
    public void testRefreshToUnfilterElementsWithMixedFilters() throws Exception {
        this.doTestRefreshToUnfilterElements(new ViewerFilter[]{new TestViewerFilter(".1"), new TestTMVFilter(".2", null)});
    }

    private void doTestRefreshToUnfilterElements(ViewerFilter[] filters) throws Exception {
        ViewerFilter[] filters1 = filters;
        TestModel model = TestModel.simpleMultiLevel();
        this.fViewer.setFilters(filters);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fListener.reset();
        this.fViewer.setAutoExpandLevel(-1);
        this.fViewer.setInput((Object)model.getRootElement());
        TestUtil.waitForJobs(this.name.getMethodName(), 300L, 5000L, new Object[0]);
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        filters1 = new ViewerFilter[]{};
        this.fViewer.setFilters(filters1);
        this.fListener.reset();
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, false, filters1);
    }

    @Test
    public void testPreserveExpandedOnMultLevelContent() throws Exception {
        TestModel model = StateTests.alternatingSubsreesModel(6);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true);
        StateTests.expandAlternateElements(this.fListener, model, true);
        TreeSelection originalSelection = new TreeSelection(new TreePath[]{model.findElement("5"), model.findElement("5.1"), model.findElement("6")});
        this.fViewer.setSelection((ISelection)originalSelection);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        ViewerFilter[] filters = new ViewerFilter[]{new TestViewerFilter("^1$")};
        this.fViewer.setFilters(filters);
        this.fListener.reset(false, false);
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), filters, -1, 12479);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true, filters);
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
        Assert.assertTrue((boolean)this.fListener.checkCoalesced(TreePath.EMPTY, 0, 6));
        filters = new ViewerFilter[]{};
        this.fViewer.setFilters(filters);
        this.fListener.reset();
        this.fListener.addUpdates(this.getInternalViewer(), TreePath.EMPTY, model.getRootElement(), filters, -1, 12479);
        model.postDelta((IModelDelta)new ModelDelta((Object)model.getRootElement(), 1024));
        this.waitWhile(t -> !this.fListener.isFinished(12991), this.createListenerErrorMessage());
        model.validateData((ITreeModelViewer)this.fViewer, TreePath.EMPTY, true, filters);
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("2")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("3.1")));
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("4")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5")));
        Assert.assertTrue((boolean)this.getInternalViewer().getExpandedState((Object)model.findElement("5.1")));
        Assert.assertTrue((!this.getInternalViewer().getExpandedState((Object)model.findElement("6")) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)StateTests.areTreeSelectionsEqual((ITreeSelection)originalSelection, (ITreeSelection)this.fViewer.getSelection()));
    }

    static class TestTMVFilter
    extends TreeModelViewerFilter {
        Pattern fPattern;
        Object fParentElement;

        TestTMVFilter(String pattern, Object parentElement) {
            this.fPattern = Pattern.compile(pattern);
            this.fParentElement = parentElement;
        }

        public boolean isApplicable(ITreeModelViewer viewer, Object parentElement) {
            if (this.fParentElement != null) {
                return this.fParentElement.equals(parentElement);
            }
            return true;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TestModel.TestElement) {
                TestModel.TestElement te = (TestModel.TestElement)((Object)element);
                return !this.fPattern.matcher(te.getLabel()).find();
            }
            return true;
        }
    }

    static class TestViewerFilter
    extends ViewerFilter {
        Pattern fPattern;

        TestViewerFilter(String pattern) {
            this.fPattern = Pattern.compile(pattern);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TestModel.TestElement) {
                TestModel.TestElement te = (TestModel.TestElement)((Object)element);
                return !this.fPattern.matcher(te.getLabel()).find();
            }
            return true;
        }
    }
}

