/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.debug.tests.AbstractDebugTest;
import org.eclipse.jface.viewers.TreePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterTransformTests
extends AbstractDebugTest {
    public Object root;
    public Object element0;
    public Object element1;
    public Object element2;
    public Object element3;
    public Object element4;
    public Object element5;
    public Object element6;
    public Object element7;
    public FilterTransform transform;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.transform = new FilterTransform();
        this.root = new Object();
        this.element0 = new Object();
        this.element1 = new Object();
        this.element2 = new Object();
        this.element3 = new Object();
        this.element4 = new Object();
        this.element5 = new Object();
        this.element6 = new Object();
        this.element7 = new Object();
        Assert.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 0, this.element0));
        Assert.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 2, this.element2));
        Assert.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 3, this.element3));
        Assert.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 6, this.element6));
        Assert.assertTrue((boolean)this.transform.addFilteredIndex(TreePath.EMPTY, 7, this.element7));
    }

    @Test
    public void testRemoveMiddleElementFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element3);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{0, 2, 5, 6});
    }

    @Test
    public void testRemoveFirstElementFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element0);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{1, 2, 5, 6});
    }

    @Test
    public void testRemoveLastFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        this.transform.removeElementFromFilters(TreePath.EMPTY, this.element7);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{0, 2, 3, 6});
    }

    @Test
    public void testClearMiddleElementFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        this.transform.clear(TreePath.EMPTY, 3);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 3));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{0, 2, 6, 7});
    }

    @Test
    public void testClearFirstElementFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        this.transform.clear(TreePath.EMPTY, 0);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{2, 3, 6, 7});
    }

    @Test
    public void testClearLastFromFilters() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        this.transform.clear(TreePath.EMPTY, 7);
        Assert.assertFalse((String)"Element should be unfiltered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 7));
        ((AbstractIntArrayAssert)Assertions.assertThat((int[])this.transform.getFilteredChildren(TreePath.EMPTY)).as("filter state", new Object[0])).containsExactly(new int[]{0, 2, 3, 6});
    }

    @Test
    public void testViewToModelCount() {
        Assert.assertEquals((String)"Wrong model count", (long)8L, (long)this.transform.viewToModelCount(TreePath.EMPTY, 3));
    }

    @Test
    public void testViewToModelIndex() {
        Assert.assertEquals((String)"Wrong model index", (long)1L, (long)this.transform.viewToModelIndex(TreePath.EMPTY, 0));
        Assert.assertEquals((String)"Wrong model index", (long)4L, (long)this.transform.viewToModelIndex(TreePath.EMPTY, 1));
        Assert.assertEquals((String)"Wrong model index", (long)5L, (long)this.transform.viewToModelIndex(TreePath.EMPTY, 2));
    }

    @Test
    public void testAddAlreadyFiltered() {
        Assert.assertTrue((String)"Element should be filtered", (boolean)this.transform.isFiltered(TreePath.EMPTY, 0));
        boolean added = this.transform.addFilteredIndex(TreePath.EMPTY, 0, this.element0);
        Assert.assertFalse((String)"Filter should not be added - should already have been there", (boolean)added);
    }

    @Test
    public void testRegression200325() {
        this.transform.setModelChildCount(TreePath.EMPTY, 2);
        try {
            this.transform.addFilteredIndex(TreePath.EMPTY, 3, new Object());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Assert.fail((String)"AIOOBE Exception should not be thrown here, setModelChildCount should leave FilterTransform$Node in a consistent state");
        }
    }
}

