/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.viewer.model;

import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.tests.viewer.model.AbstractViewerModelTest;
import org.eclipse.debug.tests.viewer.model.ITestModelUpdatesListenerConstants;
import org.eclipse.debug.tests.viewer.model.TestModel;
import org.eclipse.debug.tests.viewer.model.TestModelUpdatesListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.junit.Assert;
import org.junit.Test;

public abstract class LazyTests
extends AbstractViewerModelTest
implements ITestModelUpdatesListenerConstants {
    @Override
    protected TestModelUpdatesListener createListener(IInternalTreeModelViewer viewer) {
        return new TestModelUpdatesListener((ITreeModelViewer)viewer, true, true);
    }

    private TestModel largeSubtreeModel(int size) {
        TestModel model = new TestModel();
        TestModel.TestElement[] children = new TestModel.TestElement[size];
        int i = 0;
        while (i < size) {
            children[i] = new TestModel.TestElement(model, "1." + i, new TestModel.TestElement[0]);
            ++i;
        }
        TestModel.TestElement element = new TestModel.TestElement(model, "1", children);
        model.setRoot(new TestModel.TestElement(model, "root", new TestModel.TestElement[]{element}));
        return model;
    }

    @Test
    public void testExpandLargeSubTree() throws Exception {
        TestModel model = this.largeSubtreeModel(1000);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), 1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(12479), this.createListenerErrorMessage());
        TestModel.TestElement rootElement = model.getRootElement();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta expandDelta = model.getBaseDelta(rootDelta);
        TestModel.TestElement expandElement = rootElement.getChildren()[0];
        expandDelta.addNode((Object)expandElement, 0, 0x100000, expandElement.getChildren().length);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(true);
        TreePath expandElementPath = model.findElement("1");
        this.fListener.addChildreCountUpdate(expandElementPath);
        this.fListener.addLabelUpdate(expandElementPath);
        int i = 0;
        while (i < 250) {
            this.fListener.addChildreUpdate(expandElementPath, i);
            TreePath childPath = expandElementPath.createChildPath((Object)expandElement.getChildren()[i]);
            this.fListener.addLabelUpdate(childPath);
            this.fListener.addHasChildrenUpdate(childPath);
            ++i;
        }
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(67), this.createListenerErrorMessage());
    }

    @Test
    public void testReplaceAndSelectInSubTreeTree() throws Exception {
        TestModel model = this.largeSubtreeModel(1000);
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset();
        this.fListener.setFailOnMultipleModelUpdateSequences(true);
        this.fListener.setFailOnRedundantUpdates(false);
        this.fViewer.setInput((Object)model.getRootElement());
        this.fListener.addLabelUpdate(model.findElement("1.0"));
        this.waitWhile(t -> !this.fListener.isFinished(8199), this.createListenerErrorMessage());
        this.fViewer.setSelection((ISelection)new TreeSelection(new TreePath[]{model.findElement("1.0")}));
        TestModel.TestElement rootElement = model.getRootElement();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta baseDelta = model.getBaseDelta(rootDelta);
        TestModel.TestElement _1Element = rootElement.getChildren()[0];
        ModelDelta _1Delta = baseDelta.addNode((Object)_1Element, 0, 0, _1Element.getChildren().length);
        TestModel.TestElement _1_0_newElement = new TestModel.TestElement(model, "1.0 - new", new TestModel.TestElement[0]);
        TreePath _1ElementPath = model.findElement("1");
        model.replaceElementChild(_1ElementPath, 0, _1_0_newElement);
        _1Delta.addNode((Object)_1_0_newElement, 0, 0x200000);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(true);
        TreePath _1_0_newElementPath = model.findElement("1.0 - new");
        this.fListener.addLabelUpdate(_1_0_newElementPath);
        model.postDelta((IModelDelta)rootDelta);
        this.waitWhile(t -> !this.fListener.isFinished(8261), this.createListenerErrorMessage());
        Assert.assertEquals((Object)((IStructuredSelection)this.fViewer.getSelection()).getFirstElement(), (Object)((Object)_1_0_newElement));
    }

    @Test
    public void testContentRefresh() throws Exception {
        TestModel model = this.largeSubtreeModel(1000);
        this.fViewer.setAutoExpandLevel(-1);
        this.fListener.reset(TreePath.EMPTY, model.getRootElement(), -1, true, true);
        this.fViewer.setInput((Object)model.getRootElement());
        this.waitWhile(t -> !this.fListener.isFinished(3), this.createListenerErrorMessage());
        this.fViewer.setAutoExpandLevel(0);
        this.fListener.reset();
        this.fListener.setFailOnRedundantUpdates(false);
        this.fViewer.reveal(model.findElement("1"), 500);
        this.waitWhile(t -> !this.fListener.isFinished(2), this.createListenerErrorMessage());
        TestModel.TestElement rootElement = model.getRootElement();
        ModelDelta rootDelta = new ModelDelta((Object)rootElement, 0);
        ModelDelta expandDelta = model.getBaseDelta(rootDelta);
        TestModel.TestElement expandElement = rootElement.getChildren()[0];
        expandDelta.addNode((Object)expandElement, 0, 1024, expandElement.getChildren().length);
        int repeatCount = 0;
        while (repeatCount < 3) {
            this.fListener.reset();
            this.fListener.setFailOnRedundantUpdates(true);
            TreePath refreshElementPath = model.findElement("1");
            this.fListener.addRedundantExceptionChildCount(refreshElementPath);
            this.fListener.addRedundantExceptionLabel(refreshElementPath);
            this.fListener.addChildreUpdate(TreePath.EMPTY, 0);
            this.fListener.addHasChildrenUpdate(refreshElementPath);
            this.fListener.addChildreCountUpdate(refreshElementPath);
            this.fListener.addLabelUpdate(refreshElementPath);
            int i = 499;
            while (i < 750) {
                this.fListener.addChildreUpdate(refreshElementPath, i);
                TreePath childPath = refreshElementPath.createChildPath((Object)expandElement.getChildren()[i]);
                this.fListener.addLabelUpdate(childPath);
                this.fListener.addHasChildrenUpdate(childPath);
                ++i;
            }
            model.postDelta((IModelDelta)rootDelta);
            while (!this.fListener.isFinished(66)) {
                if (this.fDisplay.readAndDispatch()) continue;
                Thread.sleep(0L);
            }
            ++repeatCount;
        }
    }
}

